/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.nio.ByteBuffer;

@Deprecated
public final class Ac4Util {
    public static final int AC40_SYNCWORD = 44096;
    public static final int AC41_SYNCWORD = 44097;
    public static final int MAX_RATE_BYTES_PER_SECOND = 336000;
    private static final int CHANNEL_COUNT_2 = 2;
    public static final int SAMPLE_HEADER_SIZE = 7;
    public static final int HEADER_SIZE_FOR_PARSER = 16;
    private static final int[] SAMPLE_COUNT = new int[]{2002, 2000, 1920, 1601, 1600, 1001, 1000, 960, 800, 800, 480, 400, 400, 2048};

    public static Format parseAc4AnnexEFormat(ParsableByteArray data, String trackId, String language, @Nullable DrmInitData drmInitData) {
        data.skipBytes(1);
        int sampleRate = (data.readUnsignedByte() & 0x20) >> 5 == 1 ? 48000 : 44100;
        return new Format.Builder().setId(trackId).setSampleMimeType("audio/ac4").setChannelCount(2).setSampleRate(sampleRate).setDrmInitData(drmInitData).setLanguage(language).build();
    }

    public static SyncFrameInfo parseAc4SyncframeInfo(ParsableBitArray data) {
        int bitstreamVersion;
        int headerSize = 0;
        int syncWord = data.readBits(16);
        headerSize += 2;
        int frameSize = data.readBits(16);
        headerSize += 2;
        if (frameSize == 65535) {
            frameSize = data.readBits(24);
            headerSize += 3;
        }
        frameSize += headerSize;
        if (syncWord == 44097) {
            frameSize += 2;
        }
        if ((bitstreamVersion = data.readBits(2)) == 3) {
            bitstreamVersion += Ac4Util.readVariableBits(data, 2);
        }
        int sequenceCounter = data.readBits(10);
        if (data.readBit() && data.readBits(3) > 0) {
            data.skipBits(2);
        }
        int sampleRate = data.readBit() ? 48000 : 44100;
        int frameRateIndex = data.readBits(4);
        int sampleCount = 0;
        if (sampleRate == 44100 && frameRateIndex == 13) {
            sampleCount = SAMPLE_COUNT[frameRateIndex];
        } else if (sampleRate == 48000 && frameRateIndex < SAMPLE_COUNT.length) {
            sampleCount = SAMPLE_COUNT[frameRateIndex];
            switch (sequenceCounter % 5) {
                case 1: 
                case 3: {
                    if (frameRateIndex != 3 && frameRateIndex != 8) break;
                    ++sampleCount;
                    break;
                }
                case 2: {
                    if (frameRateIndex != 8 && frameRateIndex != 11) break;
                    ++sampleCount;
                    break;
                }
                case 4: {
                    if (frameRateIndex != 3 && frameRateIndex != 8 && frameRateIndex != 11) break;
                    ++sampleCount;
                    break;
                }
            }
        }
        return new SyncFrameInfo(bitstreamVersion, 2, sampleRate, frameSize, sampleCount);
    }

    public static int parseAc4SyncframeSize(byte[] data, int syncword) {
        if (data.length < 7) {
            return -1;
        }
        int headerSize = 2;
        int frameSize = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        headerSize += 2;
        if (frameSize == 65535) {
            frameSize = (data[4] & 0xFF) << 16 | (data[5] & 0xFF) << 8 | data[6] & 0xFF;
            headerSize += 3;
        }
        if (syncword == 44097) {
            headerSize += 2;
        }
        return frameSize += headerSize;
    }

    public static int parseAc4SyncframeAudioSampleCount(ByteBuffer buffer) {
        byte[] bufferBytes = new byte[16];
        int position = buffer.position();
        buffer.get(bufferBytes);
        buffer.position(position);
        return Ac4Util.parseAc4SyncframeInfo((ParsableBitArray)new ParsableBitArray((byte[])bufferBytes)).sampleCount;
    }

    public static void getAc4SampleHeader(int size, ParsableByteArray buffer) {
        buffer.reset(7);
        byte[] data = buffer.getData();
        data[0] = -84;
        data[1] = 64;
        data[2] = -1;
        data[3] = -1;
        data[4] = (byte)(size >> 16 & 0xFF);
        data[5] = (byte)(size >> 8 & 0xFF);
        data[6] = (byte)(size & 0xFF);
    }

    private static int readVariableBits(ParsableBitArray data, int bitsPerRead) {
        int value = 0;
        while (true) {
            value += data.readBits(bitsPerRead);
            if (!data.readBit()) break;
            ++value;
            value <<= bitsPerRead;
        }
        return value;
    }

    private Ac4Util() {
    }

    public static final class SyncFrameInfo {
        public final int bitstreamVersion;
        public final int sampleRate;
        public final int channelCount;
        public final int frameSize;
        public final int sampleCount;

        private SyncFrameInfo(int bitstreamVersion, int channelCount, int sampleRate, int frameSize, int sampleCount) {
            this.bitstreamVersion = bitstreamVersion;
            this.channelCount = channelCount;
            this.sampleRate = sampleRate;
            this.frameSize = frameSize;
            this.sampleCount = sampleCount;
        }
    }
}

