/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.flac;

import com.google.android.exoplayer2.extractor.BinarySearchSeeker;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.FlacFrameReader;
import com.google.android.exoplayer2.extractor.FlacStreamMetadata;
import java.io.IOException;

@Deprecated
final class FlacBinarySearchSeeker
extends BinarySearchSeeker {
    public FlacBinarySearchSeeker(FlacStreamMetadata flacStreamMetadata, int frameStartMarker, long firstFramePosition, long inputLength) {
        super(flacStreamMetadata::getSampleNumber, new FlacTimestampSeeker(flacStreamMetadata, frameStartMarker), flacStreamMetadata.getDurationUs(), 0L, flacStreamMetadata.totalSamples, firstFramePosition, inputLength, flacStreamMetadata.getApproxBytesPerFrame(), Math.max(6, flacStreamMetadata.minFrameSize));
    }

    private static final class FlacTimestampSeeker
    implements BinarySearchSeeker.TimestampSeeker {
        private final FlacStreamMetadata flacStreamMetadata;
        private final int frameStartMarker;
        private final FlacFrameReader.SampleNumberHolder sampleNumberHolder;

        private FlacTimestampSeeker(FlacStreamMetadata flacStreamMetadata, int frameStartMarker) {
            this.flacStreamMetadata = flacStreamMetadata;
            this.frameStartMarker = frameStartMarker;
            this.sampleNumberHolder = new FlacFrameReader.SampleNumberHolder();
        }

        @Override
        public BinarySearchSeeker.TimestampSearchResult searchForTimestamp(ExtractorInput input, long targetSampleNumber) throws IOException {
            long searchPosition = input.getPosition();
            long leftFrameFirstSampleNumber = this.findNextFrame(input);
            long leftFramePosition = input.getPeekPosition();
            input.advancePeekPosition(Math.max(6, this.flacStreamMetadata.minFrameSize));
            long rightFrameFirstSampleNumber = this.findNextFrame(input);
            long rightFramePosition = input.getPeekPosition();
            if (leftFrameFirstSampleNumber <= targetSampleNumber && rightFrameFirstSampleNumber > targetSampleNumber) {
                return BinarySearchSeeker.TimestampSearchResult.targetFoundResult(leftFramePosition);
            }
            if (rightFrameFirstSampleNumber <= targetSampleNumber) {
                return BinarySearchSeeker.TimestampSearchResult.underestimatedResult(rightFrameFirstSampleNumber, rightFramePosition);
            }
            return BinarySearchSeeker.TimestampSearchResult.overestimatedResult(leftFrameFirstSampleNumber, searchPosition);
        }

        private long findNextFrame(ExtractorInput input) throws IOException {
            while (input.getPeekPosition() < input.getLength() - 6L && !FlacFrameReader.checkFrameHeaderFromPeek(input, this.flacStreamMetadata, this.frameStartMarker, this.sampleNumberHolder)) {
                input.advancePeekPosition(1);
            }
            if (input.getPeekPosition() >= input.getLength() - 6L) {
                input.advancePeekPosition((int)(input.getLength() - input.getPeekPosition()));
                return this.flacStreamMetadata.totalSamples;
            }
            return this.sampleNumberHolder.sampleNumber;
        }
    }
}

