/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.DtsUtil;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@Deprecated
public final class DtsReader
implements ElementaryStreamReader {
    private static final int STATE_FINDING_SYNC = 0;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private static final int HEADER_SIZE = 18;
    private final ParsableByteArray headerScratchBytes = new ParsableByteArray(new byte[18]);
    @Nullable
    private final String language;
    private @MonotonicNonNull String formatId;
    private @MonotonicNonNull TrackOutput output;
    private int state = 0;
    private int bytesRead;
    private int syncBytes;
    private long sampleDurationUs;
    private @MonotonicNonNull Format format;
    private int sampleSize;
    private long timeUs = -9223372036854775807L;

    public DtsReader(@Nullable String language) {
        this.language = language;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.bytesRead = 0;
        this.syncBytes = 0;
        this.timeUs = -9223372036854775807L;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        idGenerator.generateNewId();
        this.formatId = idGenerator.getFormatId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 1);
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        if (pesTimeUs != -9223372036854775807L) {
            this.timeUs = pesTimeUs;
        }
    }

    @Override
    public void consume(ParsableByteArray data) {
        Assertions.checkStateNotNull((Object)this.output);
        block5: while (data.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    if (!this.skipToNextSync(data)) continue block5;
                    this.state = 1;
                    continue block5;
                }
                case 1: {
                    if (!this.continueRead(data, this.headerScratchBytes.getData(), 18)) continue block5;
                    this.parseHeader();
                    this.headerScratchBytes.setPosition(0);
                    this.output.sampleData(this.headerScratchBytes, 18);
                    this.state = 2;
                    continue block5;
                }
                case 2: {
                    int bytesToRead = Math.min(data.bytesLeft(), this.sampleSize - this.bytesRead);
                    this.output.sampleData(data, bytesToRead);
                    this.bytesRead += bytesToRead;
                    if (this.bytesRead != this.sampleSize) continue block5;
                    if (this.timeUs != -9223372036854775807L) {
                        this.output.sampleMetadata(this.timeUs, 1, this.sampleSize, 0, null);
                        this.timeUs += this.sampleDurationUs;
                    }
                    this.state = 0;
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public void packetFinished() {
    }

    private boolean continueRead(ParsableByteArray source, byte[] target, int targetLength) {
        int bytesToRead = Math.min(source.bytesLeft(), targetLength - this.bytesRead);
        source.readBytes(target, this.bytesRead, bytesToRead);
        this.bytesRead += bytesToRead;
        return this.bytesRead == targetLength;
    }

    private boolean skipToNextSync(ParsableByteArray pesBuffer) {
        while (pesBuffer.bytesLeft() > 0) {
            this.syncBytes <<= 8;
            this.syncBytes |= pesBuffer.readUnsignedByte();
            if (!DtsUtil.isSyncWord(this.syncBytes)) continue;
            byte[] headerData = this.headerScratchBytes.getData();
            headerData[0] = (byte)(this.syncBytes >> 24 & 0xFF);
            headerData[1] = (byte)(this.syncBytes >> 16 & 0xFF);
            headerData[2] = (byte)(this.syncBytes >> 8 & 0xFF);
            headerData[3] = (byte)(this.syncBytes & 0xFF);
            this.bytesRead = 4;
            this.syncBytes = 0;
            return true;
        }
        return false;
    }

    @RequiresNonNull(value={"output"})
    private void parseHeader() {
        byte[] frameData = this.headerScratchBytes.getData();
        if (this.format == null) {
            this.format = DtsUtil.parseDtsFormat(frameData, this.formatId, this.language, null);
            this.output.format(this.format);
        }
        this.sampleSize = DtsUtil.getDtsFrameSize(frameData);
        this.sampleDurationUs = (int)(1000000L * (long)DtsUtil.parseDtsAudioSampleCount(frameData) / (long)this.format.sampleRate);
    }
}

