/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Deprecated
public final class HlsMultivariantPlaylist
extends HlsPlaylist {
    public static final HlsMultivariantPlaylist EMPTY = new HlsMultivariantPlaylist("", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), false, Collections.emptyMap(), Collections.emptyList());
    public static final int GROUP_INDEX_VARIANT = 0;
    public static final int GROUP_INDEX_AUDIO = 1;
    public static final int GROUP_INDEX_SUBTITLE = 2;
    public final List<Uri> mediaPlaylistUrls;
    public final List<Variant> variants;
    public final List<Rendition> videos;
    public final List<Rendition> audios;
    public final List<Rendition> subtitles;
    public final List<Rendition> closedCaptions;
    @Nullable
    public final Format muxedAudioFormat;
    @Nullable
    public final List<Format> muxedCaptionFormats;
    public final Map<String, String> variableDefinitions;
    public final List<DrmInitData> sessionKeyDrmInitData;

    public HlsMultivariantPlaylist(String baseUri, List<String> tags, List<Variant> variants, List<Rendition> videos, List<Rendition> audios, List<Rendition> subtitles, List<Rendition> closedCaptions, @Nullable Format muxedAudioFormat, @Nullable List<Format> muxedCaptionFormats, boolean hasIndependentSegments, Map<String, String> variableDefinitions, List<DrmInitData> sessionKeyDrmInitData) {
        super(baseUri, tags, hasIndependentSegments);
        this.mediaPlaylistUrls = Collections.unmodifiableList(HlsMultivariantPlaylist.getMediaPlaylistUrls(variants, videos, audios, subtitles, closedCaptions));
        this.variants = Collections.unmodifiableList(variants);
        this.videos = Collections.unmodifiableList(videos);
        this.audios = Collections.unmodifiableList(audios);
        this.subtitles = Collections.unmodifiableList(subtitles);
        this.closedCaptions = Collections.unmodifiableList(closedCaptions);
        this.muxedAudioFormat = muxedAudioFormat;
        this.muxedCaptionFormats = muxedCaptionFormats != null ? Collections.unmodifiableList(muxedCaptionFormats) : null;
        this.variableDefinitions = Collections.unmodifiableMap(variableDefinitions);
        this.sessionKeyDrmInitData = Collections.unmodifiableList(sessionKeyDrmInitData);
    }

    public HlsMultivariantPlaylist copy(List<StreamKey> streamKeys) {
        return new HlsMultivariantPlaylist(this.baseUri, this.tags, HlsMultivariantPlaylist.copyStreams(this.variants, 0, streamKeys), Collections.emptyList(), HlsMultivariantPlaylist.copyStreams(this.audios, 1, streamKeys), HlsMultivariantPlaylist.copyStreams(this.subtitles, 2, streamKeys), Collections.emptyList(), this.muxedAudioFormat, this.muxedCaptionFormats, this.hasIndependentSegments, this.variableDefinitions, this.sessionKeyDrmInitData);
    }

    public static HlsMultivariantPlaylist createSingleVariantMultivariantPlaylist(String variantUrl) {
        List<Variant> variant = Collections.singletonList(Variant.createMediaPlaylistVariantUrl(Uri.parse((String)variantUrl)));
        return new HlsMultivariantPlaylist("", Collections.emptyList(), variant, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, false, Collections.emptyMap(), Collections.emptyList());
    }

    private static List<Uri> getMediaPlaylistUrls(List<Variant> variants, List<Rendition> videos, List<Rendition> audios, List<Rendition> subtitles, List<Rendition> closedCaptions) {
        ArrayList<Uri> mediaPlaylistUrls = new ArrayList<Uri>();
        for (int i = 0; i < variants.size(); ++i) {
            Uri uri = variants.get((int)i).url;
            if (mediaPlaylistUrls.contains(uri)) continue;
            mediaPlaylistUrls.add(uri);
        }
        HlsMultivariantPlaylist.addMediaPlaylistUrls(videos, mediaPlaylistUrls);
        HlsMultivariantPlaylist.addMediaPlaylistUrls(audios, mediaPlaylistUrls);
        HlsMultivariantPlaylist.addMediaPlaylistUrls(subtitles, mediaPlaylistUrls);
        HlsMultivariantPlaylist.addMediaPlaylistUrls(closedCaptions, mediaPlaylistUrls);
        return mediaPlaylistUrls;
    }

    private static void addMediaPlaylistUrls(List<Rendition> renditions, List<Uri> out) {
        for (int i = 0; i < renditions.size(); ++i) {
            Uri uri = renditions.get((int)i).url;
            if (uri == null || out.contains(uri)) continue;
            out.add(uri);
        }
    }

    private static <T> List<T> copyStreams(List<T> streams, int groupIndex, List<StreamKey> streamKeys) {
        ArrayList<T> copiedStreams = new ArrayList<T>(streamKeys.size());
        block0: for (int i = 0; i < streams.size(); ++i) {
            T stream = streams.get(i);
            for (int j = 0; j < streamKeys.size(); ++j) {
                StreamKey streamKey = streamKeys.get(j);
                if (streamKey.groupIndex != groupIndex || streamKey.streamIndex != i) continue;
                copiedStreams.add(stream);
                continue block0;
            }
        }
        return copiedStreams;
    }

    public static final class Variant {
        public final Uri url;
        public final Format format;
        @Nullable
        public final String videoGroupId;
        @Nullable
        public final String audioGroupId;
        @Nullable
        public final String subtitleGroupId;
        @Nullable
        public final String captionGroupId;

        public Variant(Uri url, Format format, @Nullable String videoGroupId, @Nullable String audioGroupId, @Nullable String subtitleGroupId, @Nullable String captionGroupId) {
            this.url = url;
            this.format = format;
            this.videoGroupId = videoGroupId;
            this.audioGroupId = audioGroupId;
            this.subtitleGroupId = subtitleGroupId;
            this.captionGroupId = captionGroupId;
        }

        public static Variant createMediaPlaylistVariantUrl(Uri url) {
            Format format = new Format.Builder().setId("0").setContainerMimeType("application/x-mpegURL").build();
            return new Variant(url, format, null, null, null, null);
        }

        public Variant copyWithFormat(Format format) {
            return new Variant(this.url, format, this.videoGroupId, this.audioGroupId, this.subtitleGroupId, this.captionGroupId);
        }
    }

    public static final class Rendition {
        @Nullable
        public final Uri url;
        public final Format format;
        public final String groupId;
        public final String name;

        public Rendition(@Nullable Uri url, Format format, String groupId, String name) {
            this.url = url;
            this.format = format;
            this.groupId = groupId;
            this.name = name;
        }
    }
}

