/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.b;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.gj;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
implements SafeParcelable {
    public static final Parcelable.Creator<CastDevice> CREATOR = new b();
    private final int xJ;
    private String Ae;
    String Af;
    private Inet4Address Ag;
    private String Ah;
    private String Ai;
    private String Aj;
    private int Ak;
    private List<WebImage> Al;
    private int Am;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons, int capabilities) {
        this.xJ = versionCode;
        this.Ae = deviceId;
        this.Af = hostAddress;
        if (this.Af != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.Af);
                if (inetAddress instanceof Inet4Address) {
                    this.Ag = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.Ag = null;
            }
        }
        this.Ah = friendlyName;
        this.Ai = modelName;
        this.Aj = deviceVersion;
        this.Ak = servicePort;
        this.Al = icons;
        this.Am = capabilities;
    }

    private CastDevice() {
        this(2, null, null, null, null, null, -1, new ArrayList<WebImage>(), 0);
    }

    int getVersionCode() {
        return this.xJ;
    }

    public String getDeviceId() {
        return this.Ae;
    }

    public Inet4Address getIpAddress() {
        return this.Ag;
    }

    public String getFriendlyName() {
        return this.Ah;
    }

    public String getModelName() {
        return this.Ai;
    }

    public String getDeviceVersion() {
        return this.Aj;
    }

    public int getServicePort() {
        return this.Ak;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.Al);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.Al.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.Al.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.Al) {
            int n2 = webImage3.getWidth();
            int n3 = webImage3.getHeight();
            if (n2 >= preferredWidth && n3 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n2 || webImage.getHeight() <= n3)) continue;
                webImage = webImage3;
                continue;
            }
            if (n2 >= preferredWidth || n3 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n2 || webImage2.getHeight() >= n3)) continue;
            webImage2 = webImage3;
        }
        Object object = null;
        object = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.Al.get(0));
        return object;
    }

    public boolean hasIcons() {
        return !this.Al.isEmpty();
    }

    public int getCapabilities() {
        return this.Am;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.Ah, this.Ae);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return gj.a(this.Ae, castDevice.Ae) && gj.a(this.Ag, castDevice.Ag) && gj.a(this.Ai, castDevice.Ai) && gj.a(this.Ah, castDevice.Ah) && gj.a(this.Aj, castDevice.Aj) && this.Ak == castDevice.Ak && gj.a(this.Al, castDevice.Al) && this.Am == castDevice.Am;
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return gj.a(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.Ae == null ? 0 : this.Ae.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }
}

