/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.internal.gj;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.io;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    private final String Aq;
    private int Ar;
    private String As;
    private MediaMetadata At;
    private long Au;
    private List<MediaTrack> Av;
    private TextTrackStyle Aw;
    private JSONObject Ax;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.Aq = contentId;
        this.Ar = -1;
    }

    MediaInfo(JSONObject json) throws JSONException {
        int n2;
        JSONObject jSONObject;
        this.Aq = json.getString("contentId");
        String string2 = json.getString("streamType");
        this.Ar = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.As = json.getString("contentType");
        if (json.has("metadata")) {
            jSONObject = json.getJSONObject("metadata");
            n2 = jSONObject.getInt("metadataType");
            this.At = new MediaMetadata(n2);
            this.At.b(jSONObject);
        }
        this.Au = gj.b(json.optDouble("duration", 0.0));
        if (json.has("tracks")) {
            this.Av = new ArrayList<MediaTrack>();
            jSONObject = json.getJSONArray("tracks");
            for (n2 = 0; n2 < jSONObject.length(); ++n2) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(n2);
                MediaTrack mediaTrack = new MediaTrack(jSONObject2);
                this.Av.add(mediaTrack);
            }
        } else {
            this.Av = null;
        }
        if (json.has("textTrackStyle")) {
            jSONObject = json.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.b(jSONObject);
            this.Aw = textTrackStyle;
        } else {
            this.Aw = null;
        }
        this.Ax = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.Aq;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.Ar = streamType;
    }

    public int getStreamType() {
        return this.Ar;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.As = contentType;
    }

    public String getContentType() {
        return this.As;
    }

    void a(MediaMetadata mediaMetadata) {
        this.At = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.At;
    }

    void m(long l2) throws IllegalArgumentException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Stream duration cannot be negative");
        }
        this.Au = l2;
    }

    public long getStreamDuration() {
        return this.Au;
    }

    void b(List<MediaTrack> list) {
        this.Av = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.Av;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.Aw = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.Aw;
    }

    void setCustomData(JSONObject customData) {
        this.Ax = customData;
    }

    public JSONObject getCustomData() {
        return this.Ax;
    }

    void dT() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.Aq)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.As)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.Ar == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject dU() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.Aq);
            switch (this.Ar) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.As != null) {
                jSONObject.put("contentType", (Object)this.As);
            }
            if (this.At != null) {
                jSONObject.put("metadata", (Object)this.At.dU());
            }
            jSONObject.put("duration", gj.o(this.Au));
            if (this.Av != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.Av) {
                    jSONArray.put((Object)mediaTrack.dU());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.Aw != null) {
                jSONObject.put("textTrackStyle", (Object)this.Aw.dU());
            }
            if (this.Ax != null) {
                jSONObject.put("customData", (Object)this.Ax);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.Ax == null != (mediaInfo.Ax == null)) {
            return false;
        }
        if (this.Ax != null && mediaInfo.Ax != null && !io.d(this.Ax, mediaInfo.Ax)) {
            return false;
        }
        return gj.a(this.Aq, mediaInfo.Aq) && this.Ar == mediaInfo.Ar && gj.a(this.As, mediaInfo.As) && gj.a(this.At, mediaInfo.At) && this.Au == mediaInfo.Au;
    }

    public int hashCode() {
        return hl.hashCode(this.Aq, this.Ar, this.As, this.At, this.Au, String.valueOf(this.Ax));
    }

    public static class Builder {
        private final MediaInfo Ay;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.Ay = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.Ay.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.Ay.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.Ay.a(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.Ay.m(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.Ay.setCustomData(customData);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> mediaTracks) {
            this.Ay.b(mediaTracks);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.Ay.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.Ay.dT();
            return this.Ay;
        }
    }
}

