/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.internal.gj;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.io;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long AP;
    private int AQ;
    private String Aq;
    private String As;
    private String mName;
    private String Ao;
    private int AR;
    private JSONObject Ax;

    MediaTrack(JSONObject json) throws JSONException {
        this.b(json);
    }

    MediaTrack(long id2, int type) throws IllegalArgumentException {
        this.clear();
        this.AP = id2;
        if (type <= 0 || type > 3) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.AQ = type;
    }

    public long getId() {
        return this.AP;
    }

    public int getType() {
        return this.AQ;
    }

    public String getContentId() {
        return this.Aq;
    }

    public void setContentId(String contentId) {
        this.Aq = contentId;
    }

    public String getContentType() {
        return this.As;
    }

    public void setContentType(String contentType) {
        this.As = contentType;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getLanguage() {
        return this.Ao;
    }

    void setLanguage(String language) {
        this.Ao = language;
    }

    public int getSubtype() {
        return this.AR;
    }

    void R(int n2) throws IllegalArgumentException {
        if (n2 <= -1 || n2 > 5) {
            throw new IllegalArgumentException("invalid subtype " + n2);
        }
        if (n2 != 0 && this.AQ != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.AR = n2;
    }

    public JSONObject getCustomData() {
        return this.Ax;
    }

    void setCustomData(JSONObject customData) {
        this.Ax = customData;
    }

    private void clear() {
        this.AP = 0L;
        this.AQ = 0;
        this.Aq = null;
        this.mName = null;
        this.Ao = null;
        this.AR = -1;
        this.Ax = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void b(JSONObject jSONObject) throws JSONException {
        this.clear();
        this.AP = jSONObject.getLong("trackId");
        String string2 = jSONObject.getString("type");
        if ("TEXT".equals(string2)) {
            this.AQ = 1;
        } else if ("AUDIO".equals(string2)) {
            this.AQ = 2;
        } else {
            if (!"VIDEO".equals(string2)) throw new JSONException("invalid type: " + string2);
            this.AQ = 3;
        }
        this.Aq = jSONObject.optString("trackContentId", null);
        this.As = jSONObject.optString("trackContentType", null);
        this.mName = jSONObject.optString("name", null);
        this.Ao = jSONObject.optString("language", null);
        if (jSONObject.has("subtype")) {
            string2 = jSONObject.getString("subtype");
            if ("SUBTITLES".equals(string2)) {
                this.AR = 1;
            } else if ("CAPTIONS".equals(string2)) {
                this.AR = 2;
            } else if ("DESCRIPTIONS".equals(string2)) {
                this.AR = 3;
            } else if ("CHAPTERS".equals(string2)) {
                this.AR = 4;
            } else {
                if (!"METADATA".equals(string2)) throw new JSONException("invalid subtype: " + string2);
                this.AR = 5;
            }
        } else {
            this.AR = 0;
        }
        this.Ax = jSONObject.optJSONObject("customData");
    }

    public JSONObject dU() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.AP);
            switch (this.AQ) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.Aq != null) {
                jSONObject.put("trackContentId", (Object)this.Aq);
            }
            if (this.As != null) {
                jSONObject.put("trackContentType", (Object)this.As);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.Ao)) {
                jSONObject.put("language", (Object)this.Ao);
            }
            switch (this.AR) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.Ax != null) {
                jSONObject.put("customData", (Object)this.Ax);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)other;
        if (this.Ax == null != (mediaTrack.Ax == null)) {
            return false;
        }
        if (this.Ax != null && mediaTrack.Ax != null && !io.d(this.Ax, mediaTrack.Ax)) {
            return false;
        }
        return this.AP == mediaTrack.AP && this.AQ == mediaTrack.AQ && gj.a(this.Aq, mediaTrack.Aq) && gj.a(this.As, mediaTrack.As) && gj.a(this.mName, mediaTrack.mName) && gj.a(this.Ao, mediaTrack.Ao) && this.AR == mediaTrack.AR;
    }

    public int hashCode() {
        return hl.hashCode(this.AP, this.AQ, this.Aq, this.As, this.mName, this.Ao, this.AR, this.Ax);
    }

    public static class Builder {
        private final MediaTrack AS;

        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            this.AS = new MediaTrack(trackId, trackType);
        }

        public Builder setContentId(String contentId) {
            this.AS.setContentId(contentId);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.AS.setContentType(contentType);
            return this;
        }

        public Builder setName(String trackName) {
            this.AS.setName(trackName);
            return this;
        }

        public Builder setLanguage(String language) {
            this.AS.setLanguage(language);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.AS.setLanguage(gj.b(locale));
            return this;
        }

        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            this.AS.R(subtype);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.AS.setCustomData(customData);
            return this;
        }

        public MediaTrack build() {
            return this.AS;
        }
    }
}

