/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.internal.gj;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.io;
import com.google.android.gms.internal.iq;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    private float Bp;
    private int Bq;
    private int ta;
    private int Br;
    private int Bs;
    private int Bt;
    private int Bu;
    private int Bv;
    private String Bw;
    private int Bx;
    private int By;
    private JSONObject Ax;

    public TextTrackStyle() {
        this.clear();
    }

    public void setFontScale(float fontScale) {
        this.Bp = fontScale;
    }

    public float getFontScale() {
        return this.Bp;
    }

    public void setForegroundColor(int foregroundColor) {
        this.Bq = foregroundColor;
    }

    public int getForegroundColor() {
        return this.Bq;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.ta = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.ta;
    }

    public void setEdgeType(int edgeType) {
        if (edgeType < 0 || edgeType > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.Br = edgeType;
    }

    public int getEdgeType() {
        return this.Br;
    }

    public void setEdgeColor(int edgeColor) {
        this.Bs = edgeColor;
    }

    public int getEdgeColor() {
        return this.Bs;
    }

    public void setWindowType(int windowType) {
        if (windowType < 0 || windowType > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.Bt = windowType;
    }

    public int getWindowType() {
        return this.Bt;
    }

    public void setWindowColor(int windowColor) {
        this.Bu = windowColor;
    }

    public int getWindowColor() {
        return this.Bu;
    }

    public void setWindowCornerRadius(int windowCornerRadius) {
        if (windowCornerRadius < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.Bv = windowCornerRadius;
    }

    public int getWindowCornerRadius() {
        return this.Bv;
    }

    public void setFontFamily(String fontFamily) {
        this.Bw = fontFamily;
    }

    public String getFontFamily() {
        return this.Bw;
    }

    public void setFontGenericFamily(int fontGenericFamily) {
        if (fontGenericFamily < 0 || fontGenericFamily > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.Bx = fontGenericFamily;
    }

    public int getFontGenericFamily() {
        return this.Bx;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle < 0 || fontStyle > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.By = fontStyle;
    }

    public int getFontStyle() {
        return this.By;
    }

    public void setCustomData(JSONObject customData) {
        this.Ax = customData;
    }

    public JSONObject getCustomData() {
        return this.Ax;
    }

    private void clear() {
        this.Bp = 1.0f;
        this.Bq = 0;
        this.ta = 0;
        this.Br = -1;
        this.Bs = 0;
        this.Bt = -1;
        this.Bu = 0;
        this.Bv = 0;
        this.Bw = null;
        this.Bx = -1;
        this.By = -1;
        this.Ax = null;
    }

    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!iq.gd()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl2 = typeface.isBold();
            boolean bl3 = typeface.isItalic();
            if (bl2 && bl3) {
                textTrackStyle.setFontStyle(3);
            } else if (bl2) {
                textTrackStyle.setFontStyle(1);
            } else if (bl3) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void b(JSONObject jSONObject) throws JSONException {
        String string2;
        this.clear();
        this.Bp = (float)jSONObject.optDouble("fontScale", 1.0);
        this.Bq = this.ah(jSONObject.optString("foregroundColor"));
        this.ta = this.ah(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.Br = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.Br = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.Br = 2;
            } else if ("RAISED".equals(string2)) {
                this.Br = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.Br = 4;
            }
        }
        this.Bs = this.ah(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.Bt = 0;
            } else if ("NORMAL".equals(string2)) {
                this.Bt = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.Bt = 2;
            }
        }
        this.Bu = this.ah(jSONObject.optString("windowColor"));
        if (this.Bt == 2) {
            this.Bv = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.Bw = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.Bx = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.Bx = 1;
            } else if ("SERIF".equals(string2)) {
                this.Bx = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.Bx = 3;
            } else if ("CASUAL".equals(string2)) {
                this.Bx = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.Bx = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.Bx = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.By = 0;
            } else if ("BOLD".equals(string2)) {
                this.By = 1;
            } else if ("ITALIC".equals(string2)) {
                this.By = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.By = 3;
            }
        }
        this.Ax = jSONObject.optJSONObject("customData");
    }

    public JSONObject dU() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.Bp);
            if (this.Bq != 0) {
                jSONObject.put("foregroundColor", (Object)this.o(this.Bq));
            }
            if (this.ta != 0) {
                jSONObject.put("backgroundColor", (Object)this.o(this.ta));
            }
            switch (this.Br) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.Bs != 0) {
                jSONObject.put("edgeColor", (Object)this.o(this.Bs));
            }
            switch (this.Bt) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.Bu != 0) {
                jSONObject.put("windowColor", (Object)this.o(this.Bu));
            }
            if (this.Bt == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.Bv);
            }
            if (this.Bw != null) {
                jSONObject.put("fontFamily", (Object)this.Bw);
            }
            switch (this.Bx) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.By) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.Ax != null) {
                jSONObject.put("customData", (Object)this.Ax);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String o(int n2) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n2), Color.green((int)n2), Color.blue((int)n2), Color.alpha((int)n2));
    }

    private int ah(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n2 = Integer.parseInt(string2.substring(1, 3), 16);
                int n3 = Integer.parseInt(string2.substring(3, 5), 16);
                int n4 = Integer.parseInt(string2.substring(5, 7), 16);
                int n5 = Integer.parseInt(string2.substring(7, 9), 16);
                return Color.argb((int)n5, (int)n2, (int)n3, (int)n4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)other;
        if (this.Ax == null != (textTrackStyle.Ax == null)) {
            return false;
        }
        if (this.Ax != null && textTrackStyle.Ax != null && !io.d(this.Ax, textTrackStyle.Ax)) {
            return false;
        }
        return this.Bp == textTrackStyle.Bp && this.Bq == textTrackStyle.Bq && this.ta == textTrackStyle.ta && this.Br == textTrackStyle.Br && this.Bs == textTrackStyle.Bs && this.Bt == textTrackStyle.Bt && this.Bv == textTrackStyle.Bv && gj.a(this.Bw, textTrackStyle.Bw) && this.Bx == textTrackStyle.Bx && this.By == textTrackStyle.By;
    }

    public int hashCode() {
        return hl.hashCode(Float.valueOf(this.Bp), this.Bq, this.ta, this.Br, this.Bs, this.Bt, this.Bu, this.Bv, this.Bw, this.Bx, this.By, this.Ax);
    }
}

