/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.common.data.f;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.hn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataHolder
implements SafeParcelable {
    public static final f CREATOR = new f();
    private final int xJ;
    private final String[] ED;
    Bundle EE;
    private final CursorWindow[] EF;
    private final int CQ;
    private final Bundle EG;
    int[] EH;
    int EI;
    boolean mClosed = false;
    private Object EJ;
    private boolean EK = true;
    private static final a EL = new a(new String[0], null){};

    DataHolder(int versionCode, String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.xJ = versionCode;
        this.ED = columns;
        this.EF = windows;
        this.CQ = statusCode;
        this.EG = metadata;
    }

    public DataHolder(String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.xJ = 1;
        this.ED = hn.f(columns);
        this.EF = hn.f(windows);
        this.CQ = statusCode;
        this.EG = metadata;
        this.eR();
    }

    public void b(Object object) {
        this.EJ = object;
    }

    private DataHolder(a builder, int statusCode, Bundle metadata) {
        this(builder.ED, DataHolder.a(builder, -1), statusCode, metadata);
    }

    public void eR() {
        int n2;
        this.EE = new Bundle();
        for (n2 = 0; n2 < this.ED.length; ++n2) {
            this.EE.putInt(this.ED[n2], n2);
        }
        this.EH = new int[this.EF.length];
        n2 = 0;
        for (int i2 = 0; i2 < this.EF.length; ++i2) {
            this.EH[i2] = n2;
            int n3 = this.EF[i2].getStartPosition();
            int n4 = n2 - n3;
            n2 += this.EF[i2].getNumRows() - n4;
        }
        this.EI = n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        f.a(this, dest, flags);
    }

    int getVersionCode() {
        return this.xJ;
    }

    String[] eS() {
        return this.ED;
    }

    CursorWindow[] eT() {
        return this.EF;
    }

    public int getStatusCode() {
        return this.CQ;
    }

    public Bundle eP() {
        return this.EG;
    }

    private static CursorWindow[] a(a a2, int n2) {
        if (a2.ED.length == 0) {
            return new CursorWindow[0];
        }
        List list = n2 < 0 || n2 >= a2.EM.size() ? a2.EM : a2.EM.subList(0, n2);
        int n3 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(a2.ED.length);
        try {
            int n4 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!cursorWindow.allocRow()) {
                    Log.d((String)"DataHolder", (String)("Allocating additional cursor window for large data set (row " + i2 + ")"));
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i2);
                    cursorWindow.setNumColumns(a2.ED.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                    n4 = 0;
                }
                Map map = (Map)list.get(i2);
                boolean bl2 = true;
                for (int i3 = 0; i3 < a2.ED.length && bl2; ++i3) {
                    String string2 = a2.ED[i3];
                    Object v2 = map.get(string2);
                    if (v2 == null) {
                        bl2 = cursorWindow.putNull(n4, i3);
                        continue;
                    }
                    if (v2 instanceof String) {
                        bl2 = cursorWindow.putString((String)v2, n4, i3);
                        continue;
                    }
                    if (v2 instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v2).longValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v2).intValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Boolean) {
                        boolean bl3 = (Boolean)v2;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, n4, i3);
                        continue;
                    }
                    if (v2 instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v2, n4, i3);
                        continue;
                    }
                    if (v2 instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v2).doubleValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v2).floatValue(), n4, i3);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported object for column " + string2 + ": " + v2);
                }
                if (!bl2) {
                    Log.d((String)"DataHolder", (String)("Couldn't populate window data for row " + i2 + " - allocating new window."));
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setNumColumns(a2.ED.length);
                    arrayList.add(cursorWindow);
                    n4 = 0;
                    --i2;
                    continue;
                }
                ++n4;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i4 = 0; i4 < n5; ++i4) {
                ((CursorWindow)arrayList.get(i4)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void e(String string2, int n2) {
        if (this.EE == null || !this.EE.containsKey(string2)) {
            throw new IllegalArgumentException("No such column: " + string2);
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n2 < 0 || n2 >= this.EI) {
            throw new CursorIndexOutOfBoundsException(n2, this.EI);
        }
    }

    public boolean av(String string2) {
        return this.EE.containsKey(string2);
    }

    public long a(String string2, int n2, int n3) {
        this.e(string2, n2);
        return this.EF[n3].getLong(n2, this.EE.getInt(string2));
    }

    public int b(String string2, int n2, int n3) {
        this.e(string2, n2);
        return this.EF[n3].getInt(n2, this.EE.getInt(string2));
    }

    public String c(String string2, int n2, int n3) {
        this.e(string2, n2);
        return this.EF[n3].getString(n2, this.EE.getInt(string2));
    }

    public boolean d(String string2, int n2, int n3) {
        this.e(string2, n2);
        Long l2 = this.EF[n3].getLong(n2, this.EE.getInt(string2));
        return l2 == 1L;
    }

    public float e(String string2, int n2, int n3) {
        this.e(string2, n2);
        return this.EF[n3].getFloat(n2, this.EE.getInt(string2));
    }

    public byte[] f(String string2, int n2, int n3) {
        this.e(string2, n2);
        return this.EF[n3].getBlob(n2, this.EE.getInt(string2));
    }

    public Uri g(String string2, int n2, int n3) {
        String string3 = this.c(string2, n2, n3);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void a(String string2, int n2, int n3, CharArrayBuffer charArrayBuffer) {
        this.e(string2, n2);
        this.EF[n3].copyStringToBuffer(n2, this.EE.getInt(string2), charArrayBuffer);
    }

    public boolean h(String string2, int n2, int n3) {
        this.e(string2, n2);
        return this.EF[n3].isNull(n2, this.EE.getInt(string2));
    }

    public int getCount() {
        return this.EI;
    }

    public int ae(int n2) {
        int n3;
        hn.A(n2 >= 0 && n2 < this.EI);
        for (n3 = 0; n3 < this.EH.length; ++n3) {
            if (n2 >= this.EH[n3]) continue;
            --n3;
            break;
        }
        if (n3 == this.EH.length) {
            --n3;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i2 = 0; i2 < this.EF.length; ++i2) {
                    this.EF[i2].close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.EK && this.EF.length > 0 && !this.isClosed()) {
                String string2 = this.EJ == null ? "internal object: " + this.toString() : this.EJ.toString();
                Log.e((String)"DataBuffer", (String)("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call close() on all DataBuffer extending objects when you are done with them. (" + string2 + ")"));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static DataHolder af(int n2) {
        return DataHolder.a(n2, null);
    }

    public static DataHolder a(int n2, Bundle bundle) {
        return new DataHolder(EL, n2, bundle);
    }

    public static class a {
        private final String[] ED;
        private final ArrayList<HashMap<String, Object>> EM;
        private final String EN;
        private final HashMap<Object, Integer> EO;
        private boolean EP;
        private String EQ;

        private a(String[] stringArray, String string2) {
            this.ED = hn.f(stringArray);
            this.EM = new ArrayList();
            this.EN = string2;
            this.EO = new HashMap();
            this.EP = false;
            this.EQ = null;
        }
    }
}

