/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.il;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int xJ;
    private final String zM;
    private final String Lk;
    private final String Mk;
    private final String Ml;
    private final String Mm;
    private final String Mn;
    private final Uri Mo;
    private final Uri Mp;
    private final Uri Mq;
    private final boolean Mr;
    private final boolean Ms;
    private final String Mt;
    private final int Mu;
    private final int Mv;
    private final int Mw;
    private final boolean Mx;
    private final boolean My;
    private final String Mz;
    private final String MA;
    private final String MB;
    private final boolean MC;
    private final boolean MD;
    private final boolean ME;

    public GameEntity(Game game) {
        this.xJ = 4;
        this.zM = game.getApplicationId();
        this.Mk = game.getPrimaryCategory();
        this.Ml = game.getSecondaryCategory();
        this.Mm = game.getDescription();
        this.Mn = game.getDeveloperName();
        this.Lk = game.getDisplayName();
        this.Mo = game.getIconImageUri();
        this.Mz = game.getIconImageUrl();
        this.Mp = game.getHiResImageUri();
        this.MA = game.getHiResImageUrl();
        this.Mq = game.getFeaturedImageUri();
        this.MB = game.getFeaturedImageUrl();
        this.Mr = game.gH();
        this.Ms = game.gJ();
        this.Mt = game.gK();
        this.Mu = game.gL();
        this.Mv = game.getAchievementTotalCount();
        this.Mw = game.getLeaderboardCount();
        this.Mx = game.isRealTimeMultiplayerEnabled();
        this.My = game.isTurnBasedMultiplayerEnabled();
        this.MC = game.isMuted();
        this.MD = game.gI();
        this.ME = game.areSnapshotsEnabled();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled) {
        this.xJ = versionCode;
        this.zM = applicationId;
        this.Lk = displayName;
        this.Mk = primaryCategory;
        this.Ml = secondaryCategory;
        this.Mm = description;
        this.Mn = developerName;
        this.Mo = iconImageUri;
        this.Mz = iconImageUrl;
        this.Mp = hiResImageUri;
        this.MA = hiResImageUrl;
        this.Mq = featuredImageUri;
        this.MB = featuredImageUrl;
        this.Mr = playEnabledGame;
        this.Ms = instanceInstalled;
        this.Mt = instancePackageName;
        this.Mu = gameplayAclStatus;
        this.Mv = achievementTotalCount;
        this.Mw = leaderboardCount;
        this.Mx = realTimeEnabled;
        this.My = turnBasedEnabled;
        this.MC = muted;
        this.MD = identitySharingConfirmed;
        this.ME = snapshotsEnabled;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public String getApplicationId() {
        return this.zM;
    }

    @Override
    public String getDisplayName() {
        return this.Lk;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        il.b(this.Lk, dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.Mk;
    }

    @Override
    public String getSecondaryCategory() {
        return this.Ml;
    }

    @Override
    public String getDescription() {
        return this.Mm;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        il.b(this.Mm, dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.Mn;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        il.b(this.Mn, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.Mo;
    }

    @Override
    public String getIconImageUrl() {
        return this.Mz;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.Mp;
    }

    @Override
    public String getHiResImageUrl() {
        return this.MA;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.Mq;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.MB;
    }

    @Override
    public boolean isMuted() {
        return this.MC;
    }

    @Override
    public boolean gI() {
        return this.MD;
    }

    @Override
    public boolean gH() {
        return this.Mr;
    }

    @Override
    public boolean gJ() {
        return this.Ms;
    }

    @Override
    public String gK() {
        return this.Mt;
    }

    @Override
    public int gL() {
        return this.Mu;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.Mv;
    }

    @Override
    public int getLeaderboardCount() {
        return this.Mw;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.Mx;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.My;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.ME;
    }

    @Override
    public Game freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.a(this);
    }

    static int a(Game game) {
        return hl.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.gH(), game.gJ(), game.gK(), game.gL(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.gI(), game.areSnapshotsEnabled());
    }

    public boolean equals(Object obj) {
        return GameEntity.a(this, obj);
    }

    static boolean a(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return hl.equal(game2.getApplicationId(), game.getApplicationId()) && hl.equal(game2.getDisplayName(), game.getDisplayName()) && hl.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && hl.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && hl.equal(game2.getDescription(), game.getDescription()) && hl.equal(game2.getDeveloperName(), game.getDeveloperName()) && hl.equal(game2.getIconImageUri(), game.getIconImageUri()) && hl.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && hl.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && hl.equal(game2.gH(), game.gH()) && hl.equal(game2.gJ(), game.gJ()) && hl.equal(game2.gK(), game.gK()) && hl.equal(game2.gL(), game.gL()) && hl.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && hl.equal(game2.getLeaderboardCount(), game.getLeaderboardCount()) && hl.equal(game2.isRealTimeMultiplayerEnabled(), game.isRealTimeMultiplayerEnabled()) && hl.equal(game2.isTurnBasedMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled() && hl.equal(game2.isMuted(), game.isMuted()) && hl.equal(game2.gI(), game.gI())) && hl.equal(game2.areSnapshotsEnabled(), game.areSnapshotsEnabled());
    }

    public String toString() {
        return GameEntity.b(this);
    }

    static String b(Game game) {
        return hl.e(game).a("ApplicationId", game.getApplicationId()).a("DisplayName", game.getDisplayName()).a("PrimaryCategory", game.getPrimaryCategory()).a("SecondaryCategory", game.getSecondaryCategory()).a("Description", game.getDescription()).a("DeveloperName", game.getDeveloperName()).a("IconImageUri", game.getIconImageUri()).a("IconImageUrl", game.getIconImageUrl()).a("HiResImageUri", game.getHiResImageUri()).a("HiResImageUrl", game.getHiResImageUrl()).a("FeaturedImageUri", game.getFeaturedImageUri()).a("FeaturedImageUrl", game.getFeaturedImageUrl()).a("PlayEnabledGame", game.gH()).a("InstanceInstalled", game.gJ()).a("InstancePackageName", game.gK()).a("AchievementTotalCount", game.getAchievementTotalCount()).a("LeaderboardCount", game.getLeaderboardCount()).a("RealTimeMultiplayerEnabled", game.isRealTimeMultiplayerEnabled()).a("TurnBasedMultiplayerEnabled", game.isTurnBasedMultiplayerEnabled()).a("AreSnapshotsEnabled", game.areSnapshotsEnabled()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fm()) {
            GameEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.zM);
            dest.writeString(this.Lk);
            dest.writeString(this.Mk);
            dest.writeString(this.Ml);
            dest.writeString(this.Mm);
            dest.writeString(this.Mn);
            dest.writeString(this.Mo == null ? null : this.Mo.toString());
            dest.writeString(this.Mp == null ? null : this.Mp.toString());
            dest.writeString(this.Mq == null ? null : this.Mq.toString());
            dest.writeInt(this.Mr ? 1 : 0);
            dest.writeInt(this.Ms ? 1 : 0);
            dest.writeString(this.Mt);
            dest.writeInt(this.Mu);
            dest.writeInt(this.Mv);
            dest.writeInt(this.Mw);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity bd(Parcel parcel) {
            boolean bl2 = GameEntity.c(GameEntity.fl());
            if (bl2 || GameEntity.aA(GameEntity.class.getCanonicalName())) {
                return super.bd(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            String string8 = parcel.readString();
            Uri uri = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri2 = string9 == null ? null : Uri.parse((String)string9);
            String string10 = parcel.readString();
            Uri uri3 = string10 == null ? null : Uri.parse((String)string10);
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            String string11 = parcel.readString();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            boolean bl5 = false;
            boolean bl6 = false;
            String string12 = null;
            String string13 = null;
            String string14 = null;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            return new GameEntity(4, string2, string3, string4, string5, string6, string7, uri, uri2, uri3, bl3, bl4, string11, n2, n3, n4, bl5, bl6, string12, string13, string14, bl7, bl8, bl9);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.bd(x0);
        }
    }
}

