/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.PlayerLevelCreator;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.hn;

public final class PlayerLevel
implements SafeParcelable {
    public static final PlayerLevelCreator CREATOR = new PlayerLevelCreator();
    private final int xJ;
    private final int MW;
    private final long MX;
    private final long MY;

    public PlayerLevel(int value, long minXp, long maxXp) {
        this(1, value, minXp, maxXp);
    }

    PlayerLevel(int versionCode, int levelNumber, long minXp, long maxXp) {
        hn.a(minXp >= 0L, "Min XP must be positive!");
        hn.a(maxXp > minXp, "Max XP must be more than min XP!");
        this.xJ = versionCode;
        this.MW = levelNumber;
        this.MX = minXp;
        this.MY = maxXp;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    public int getLevelNumber() {
        return this.MW;
    }

    public long getMinXp() {
        return this.MX;
    }

    public long getMaxXp() {
        return this.MY;
    }

    public int hashCode() {
        return hl.hashCode(this.MW, this.MX, this.MY);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)obj;
        return hl.equal(playerLevel.getLevelNumber(), this.getLevelNumber()) && hl.equal(playerLevel.getMinXp(), this.getMinXp()) && hl.equal(playerLevel.getMaxXp(), this.getMaxXp());
    }

    public String toString() {
        return hl.e(this).a("LevelNumber", this.getLevelNumber()).a("MinXp", this.getMinXp()).a("MaxXp", this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelCreator.a(this, out, flags);
    }
}

