/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.api.b;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.a;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.LibjingleNativeSocket;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.RealTimeSocketImpl;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.internal.game.ExtendedGameBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.internal.gy;
import com.google.android.gms.internal.hc;
import com.google.android.gms.internal.hj;
import com.google.android.gms.internal.hn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GamesClientImpl
extends hc<IGamesService>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    EventIncrementManager Nm = new EventIncrementManager(){

        @Override
        public EventIncrementCache hs() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String Nn;
    private final String yN;
    private final Map<String, RealTimeSocket> No;
    private PlayerEntity Np;
    private GameEntity Nq;
    private final PopupManager Nr;
    private boolean Ns = false;
    private boolean Nt = false;
    private int Nu;
    private final Binder Nv;
    private final long Nw;
    private final boolean Nx;
    private final int Ny;
    private final boolean Nz;
    private final String NA;

    public GamesClientImpl(Context context, Looper looper, String gamePackageName, String accountName, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener, String[] scopes, int gravity, View gamesContentView, boolean isHeadless, boolean showConnectingPopup, int connectingPopupGravity, boolean retryingSignIn, int sdkVariant, String forceResolveAccountKey) {
        super(context, looper, connectedListener, connectionFailedListener, scopes);
        this.Nn = gamePackageName;
        this.yN = hn.f(accountName);
        this.Nv = new Binder();
        this.No = new HashMap<String, RealTimeSocket>();
        this.Nr = PopupManager.a(this, gravity);
        this.f(gamesContentView);
        this.Nt = showConnectingPopup;
        this.Nu = connectingPopupGravity;
        this.Nw = this.hashCode();
        this.Nx = isHeadless;
        this.Nz = retryingSignIn;
        this.Ny = sdkVariant;
        this.NA = forceResolveAccountKey;
        this.registerConnectionCallbacks(this);
        this.registerConnectionFailedListener(this);
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (this.Ns) {
            this.Nr.hG();
            this.Ns = false;
        }
    }

    @Override
    public void onConnectionSuspended(int cause) {
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        this.Ns = false;
    }

    public void cg(int n2) {
        this.Nr.setGravity(n2);
    }

    public void f(View view) {
        this.Nr.g(view);
    }

    @Override
    protected void b(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string2.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            hn.a(!bl2, "Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty");
        } else {
            hn.a(bl2, "Games APIs requires %s to function.", "https://www.googleapis.com/auth/games");
        }
    }

    @Override
    public void connect() {
        this.gT();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.Ns = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.fo();
                iGamesService.hr();
                this.Nm.flush();
                iGamesService.q(this.Nw);
            }
            catch (RemoteException remoteException) {
                GamesLog.j("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        this.hq();
        super.disconnect();
    }

    @Override
    protected String bp() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String bq() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService ah(IBinder iBinder) {
        return IGamesService.Stub.aj(iBinder);
    }

    @Override
    public Bundle ea() {
        try {
            Bundle bundle = ((IGamesService)this.fo()).ea();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return null;
        }
    }

    private void gT() {
        this.Np = null;
    }

    @Override
    protected void a(hj hj2, hc.e e2) throws RemoteException {
        String string2 = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.Nx);
        bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.Nt);
        bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.Nu);
        bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.Nz);
        bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.Ny);
        bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.NA);
        hj2.a(e2, 5077000, this.getContext().getPackageName(), this.yN, this.fn(), this.Nn, this.Nr.hI(), string2, bundle);
    }

    public String gU() {
        try {
            return ((IGamesService)this.fo()).gU();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return null;
        }
    }

    public String gV() {
        try {
            return ((IGamesService)this.fo()).gV();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player gW() {
        this.ci();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Np == null) {
                try (PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.fo()).ht());){
                    if (playerBuffer.getCount() > 0) {
                        this.Np = (PlayerEntity)playerBuffer.get(0).freeze();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.j("GamesClientImpl", "service died");
                }
            }
        }
        return this.Np;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game gX() {
        this.ci();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Nq == null) {
                try (GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.fo()).hv());){
                    if (gameBuffer.getCount() > 0) {
                        this.Nq = (GameEntity)gameBuffer.get(0).freeze();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.j("GamesClientImpl", "service died");
                }
            }
        }
        return this.Nq;
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String[] stringArray) {
        try {
            ((IGamesService)this.fo()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        if (!string2.equals("played_with")) {
            throw new IllegalArgumentException("Invalid player collection: " + string2);
        }
        try {
            ((IGamesService)this.fo()).d(new PlayersLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2, String string3, int n2, boolean bl2, boolean bl3) {
        if (!string2.equals("played_with") && !string2.equals("circled")) {
            throw new IllegalArgumentException("Invalid player collection: " + string2);
        }
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2, string3, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.fo()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent gY() {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).gY();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent aR(String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).aR(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void b(a.d<Leaderboards.LeaderboardMetadataResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.fo()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LeaderboardMetadataResult> d2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.fo()).c((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadPlayerScoreResult> d2, String string2, String string3, int n2, int n3) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(d2), string2, string3, n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadScoresResult> d2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(d2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Leaderboards.LoadScoresResult> d2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.fo()).b((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(d2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadScoresResult> d2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n2, int n3) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(d2), leaderboardScoreBuffer.iv().iw(), n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.SubmitScoreResult> d2, String string2, long l2, String string3) {
        try {
            SubmitScoreBinderCallbacks submitScoreBinderCallbacks = d2 == null ? null : new SubmitScoreBinderCallbacks(d2);
            ((IGamesService)this.fo()).a((IGamesCallbacks)submitScoreBinderCallbacks, string2, l2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent gZ() {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).gZ();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void c(a.d<Achievements.LoadAchievementsResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Achievements.UpdateAchievementResult> d2, String string2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.fo()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string2, this.Nr.hI(), this.Nr.hH());
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Achievements.UpdateAchievementResult> d2, String string2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.fo()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string2, this.Nr.hI(), this.Nr.hH());
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Achievements.UpdateAchievementResult> d2, String string2, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.fo()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string2, n2, this.Nr.hI(), this.Nr.hH());
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Achievements.UpdateAchievementResult> d2, String string2, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.fo()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string2, n2, this.Nr.hI(), this.Nr.hH());
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<Events.LoadEventsResult> d2, boolean bl2) {
        try {
            this.Nm.flush();
            ((IGamesService)this.fo()).f((IGamesCallbacks)new EventsLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Events.LoadEventsResult> d2, boolean bl2, String ... stringArray) {
        try {
            this.Nm.flush();
            ((IGamesService)this.fo()).a((IGamesCallbacks)new EventsLoadedBinderCallback(d2), bl2, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void l(String string2, int n2) {
        this.Nm.l(string2, n2);
    }

    public Intent ha() {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).ha();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent hb() {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).hb();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(OnInvitationReceivedListener onInvitationReceivedListener) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(onInvitationReceivedListener);
            ((IGamesService)this.fo()).a((IGamesCallbacks)invitationReceivedBinderCallback, this.Nw);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void hc() {
        try {
            ((IGamesService)this.fo()).r(this.Nw);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(onTurnBasedMatchUpdateReceivedListener);
            ((IGamesService)this.fo()).b((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.Nw);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void hd() {
        try {
            ((IGamesService)this.fo()).s(this.Nw);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(QuestUpdateListener questUpdateListener) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(questUpdateListener);
            ((IGamesService)this.fo()).d((IGamesCallbacks)questUpdateBinderCallback, this.Nw);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void he() {
        try {
            ((IGamesService)this.fo()).u(this.Nw);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(OnRequestReceivedListener onRequestReceivedListener) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(onRequestReceivedListener);
            ((IGamesService)this.fo()).c((IGamesCallbacks)requestReceivedBinderCallback, this.Nw);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void hf() {
        try {
            ((IGamesService)this.fo()).t(this.Nw);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent hg() {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).hg();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(Room room, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).a((RoomEntity)room.freeze(), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent hh() {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).hh();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void f(a.d<GamesMetadata.LoadGamesResult> d2) {
        try {
            ((IGamesService)this.fo()).d(new GamesLoadedBinderCallback(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Status> d2) {
        try {
            this.Nm.flush();
            ((IGamesService)this.fo()).a(new SignOutCompleteBinderCallbacks(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public int hi() {
        int n2 = 4368;
        try {
            n2 = ((IGamesService)this.fo()).hi();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public String hj() {
        try {
            return ((IGamesService)this.fo()).hj();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return null;
        }
    }

    public void c(a.d<Invitations.LoadInvitationsResult> d2, int n2) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new InvitationsLoadedBinderCallback(d2), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void m(String string2, int n2) {
        try {
            ((IGamesService)this.fo()).m(string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void n(String string2, int n2) {
        try {
            ((IGamesService)this.fo()).n(string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent a(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).a(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, TurnBasedMatchConfig turnBasedMatchConfig) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(d2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.iC(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).l(new TurnBasedMatchInitiatedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void e(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).m(new TurnBasedMatchInitiatedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public int hk() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.fo()).hk();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void a(a.d<TurnBasedMultiplayer.UpdateMatchResult> d2, String string2, byte[] byArray, String string3, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(d2), string2, byArray, string3, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.UpdateMatchResult> d2, String string2, byte[] byArray, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(d2), string2, byArray, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void f(a.d<TurnBasedMultiplayer.LeaveMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).o(new TurnBasedMatchLeftBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.LeaveMatchResult> d2, String string2, String string3) {
        try {
            ((IGamesService)this.fo()).c((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(d2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void g(a.d<TurnBasedMultiplayer.CancelMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).n(new TurnBasedMatchCanceledBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void aS(String string2) {
        try {
            ((IGamesService)this.fo()).ba(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.LoadMatchesResult> d2, int n2, int[] nArray) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(d2), n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void h(a.d<TurnBasedMultiplayer.LoadMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).p(new TurnBasedMatchLoadedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent b(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).b(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((IGamesService)this.fo()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Nv, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), roomConfig.isSocketEnabled(), this.Nw);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((IGamesService)this.fo()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Nv, roomConfig.getInvitationId(), roomConfig.isSocketEnabled(), this.Nw);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(RoomUpdateListener roomUpdateListener, String string2) {
        try {
            ((IGamesService)this.fo()).c((IGamesCallbacks)new RoomBinderCallbacks(roomUpdateListener), string2);
            this.hq();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public int a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback, byte[] byArray, String string2, String string3) {
        try {
            return ((IGamesService)this.fo()).a((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(reliableMessageSentCallback), byArray, string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string2, String[] stringArray) {
        hn.b(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.fo()).b(byArray, string2, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int d(byte[] byArray, String string2) {
        try {
            return ((IGamesService)this.fo()).b(byArray, string2, null);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return -1;
        }
    }

    public RealTimeSocket l(String string2, String string3) {
        if (string3 == null || !ParticipantUtils.bn(string3)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        RealTimeSocket realTimeSocket = this.No.get(string3);
        if (realTimeSocket == null || realTimeSocket.isClosed()) {
            return this.aT(string3);
        }
        return realTimeSocket;
    }

    private RealTimeSocket aT(String string2) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = ((IGamesService)this.fo()).bb(string2);
            if (parcelFileDescriptor != null) {
                GamesLog.i("GamesClientImpl", "Created native libjingle socket.");
                LibjingleNativeSocket libjingleNativeSocket = new LibjingleNativeSocket(parcelFileDescriptor);
                this.No.put(string2, libjingleNativeSocket);
                return libjingleNativeSocket;
            }
            GamesLog.i("GamesClientImpl", "Unable to create native libjingle socket, resorting to old socket.");
            String string3 = ((IGamesService)this.fo()).aW(string2);
            if (string3 == null) {
                return null;
            }
            LocalSocket localSocket = new LocalSocket();
            try {
                localSocket.connect(new LocalSocketAddress(string3));
            }
            catch (IOException iOException) {
                GamesLog.k("GamesClientImpl", "connect() call failed on socket: " + iOException.getMessage());
                return null;
            }
            RealTimeSocketImpl realTimeSocketImpl = new RealTimeSocketImpl(localSocket, string2);
            this.No.put(string2, realTimeSocketImpl);
            return realTimeSocketImpl;
        }
        catch (RemoteException remoteException) {
            GamesLog.k("GamesClientImpl", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void ch(int n2) {
        try {
            ((IGamesService)this.fo()).ch(n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent hl() {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).hl();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(int n2, byte[] byArray, int n3, Bitmap bitmap, String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).a(n2, byArray, n3, string2);
            hn.b(bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public int hm() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.fo()).hm();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int hn() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.fo()).hn();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void b(a.d<Requests.UpdateRequestsResult> d2, String[] stringArray) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(d2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Requests.UpdateRequestsResult> d2, String[] stringArray) {
        try {
            ((IGamesService)this.fo()).b((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(d2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.LoadRequestsResult> d2, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(d2), n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent a(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).a(nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent aU(String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).aU(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void i(a.d<Quests.AcceptQuestResult> d2, String string2) {
        try {
            this.Nm.flush();
            ((IGamesService)this.fo()).u(new QuestAcceptedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Quests.ClaimMilestoneResult> d2, String string2, String string3) {
        try {
            this.Nm.flush();
            ((IGamesService)this.fo()).f(new QuestMilestoneClaimBinderCallbacks(d2, string3), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Quests.LoadQuestsResult> d2, int[] nArray, int n2, boolean bl2) {
        try {
            this.Nm.flush();
            ((IGamesService)this.fo()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(d2), nArray, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Quests.LoadQuestsResult> d2, boolean bl2, String[] stringArray) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(d2), stringArray, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Quests.LoadQuestsResult> d2, String string2, String string3, int[] nArray, int n2, boolean bl2) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(d2), string2, string3, nArray, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Quests.LoadQuestsResult> d2, String string2, String string3, boolean bl2, String[] stringArray) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(d2), string2, string3, stringArray, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public int ho() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.fo()).ho();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int hp() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.fo()).hp();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public Intent a(String string2, boolean bl2, boolean bl3, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.fo()).a(string2, bl2, bl3, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void e(a.d<Snapshots.LoadSnapshotsResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.fo()).d((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Snapshots.OpenSnapshotResult> d2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.fo()).e((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(d2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Snapshots.CommitSnapshotResult> d2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) {
        Contents contents = snapshot.getContents();
        hn.b(contents, (Object)"Must provide a previously opened Snapshot");
        a a2 = snapshotMetadataChange.iI();
        if (a2 != null) {
            a2.a(this.getContext().getCacheDir());
        }
        snapshot.iH();
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(d2), snapshot.getMetadata().getSnapshotId(), snapshotMetadataChange, contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(Snapshot snapshot) {
        Contents contents = snapshot.getContents();
        hn.b(contents, (Object)"Must provide a previously opened Snapshot");
        snapshot.iH();
        try {
            ((IGamesService)this.fo()).a(contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void j(a.d<Snapshots.DeleteSnapshotResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).r(new SnapshotDeletedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Snapshots.OpenSnapshotResult> d2, String string2, String string3, SnapshotMetadataChange snapshotMetadataChange, Contents contents) {
        a a2 = snapshotMetadataChange.iI();
        if (a2 != null) {
            a2.a(this.getContext().getCacheDir());
        }
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(d2), string2, string3, snapshotMetadataChange, contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void k(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).e((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void l(a.d<GamesMetadata.LoadGameInstancesResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).f((IGamesCallbacks)new GameInstancesLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<GamesMetadata.LoadExtendedGamesResult> d2, int n2, int n3, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(d2), n2, n3, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3, bl4, bl5);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).e(new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).f(new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void e(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).c(new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void m(a.d<GamesMetadata.LoadGameSearchSuggestionsResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).q(new GameSearchSuggestionsLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Leaderboards.LeaderboardMetadataResult> d2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.fo()).d((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LeaderboardMetadataResult> d2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.fo()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadScoresResult> d2, String string2, String string3, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(d2), string2, string3, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Leaderboards.LoadScoresResult> d2, String string2, String string3, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.fo()).b(new LeaderboardScoresLoadedBinderCallback(d2), string2, string3, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).e(new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2, int n2, boolean bl2) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void f(a.d<Players.LoadPlayersResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void e(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).d(new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void g(a.d<Players.LoadPlayersResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.fo()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2, null, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void g(a.d<Players.LoadOwnerCoverPhotoUrisResult> d2) {
        try {
            ((IGamesService)this.fo()).j(new OwnerCoverPhotoUrisLoadedBinderCallback(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void n(a.d<Players.LoadXpForGameCategoriesResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).s(new PlayerXpForGameCategoriesLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Players.LoadXpStreamResult> d2, String string2, int n2) {
        try {
            ((IGamesService)this.fo()).b((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(d2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<Players.LoadXpStreamResult> d2, String string2, int n2) {
        try {
            ((IGamesService)this.fo()).c((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(d2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Achievements.LoadAchievementsResult> d2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(d2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2, String string3) {
        try {
            ((IGamesService)this.fo()).d((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(d2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2, String string3) {
        try {
            ((IGamesService)this.fo()).e((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(d2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void e(a.d<Invitations.LoadInvitationsResult> d2, String string2, int n2) {
        try {
            ((IGamesService)this.fo()).b((IGamesCallbacks)new InvitationsLoadedBinderCallback(d2), string2, n2, false);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void o(a.d<Invitations.LoadInvitationsResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).k(new InvitationsLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.LoadMatchesResult> d2, String string2, int n2, int[] nArray) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(d2), string2, n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void h(a.d<Acls.LoadAclResult> d2) {
        try {
            ((IGamesService)this.fo()).h(new NotifyAclLoadedBinderCallback(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void p(a.d<Status> d2, String string2) {
        try {
            ((IGamesService)this.fo()).j(new NotifyAclUpdatedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<Notifications.GameMuteStatusChangeResult> d2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(d2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void q(a.d<Notifications.GameMuteStatusLoadResult> d2, String string2) {
        try {
            ((IGamesService)this.fo()).i(new GameMuteStatusLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    @Deprecated
    public void i(a.d<Notifications.ContactSettingLoadResult> d2) {
        try {
            ((IGamesService)this.fo()).e((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(d2), false);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void f(a.d<Notifications.ContactSettingLoadResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.fo()).e((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Status> d2, boolean bl2, Bundle bundle) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(d2), bl2, bundle);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void j(a.d<Notifications.InboxCountResult> d2) {
        try {
            ((IGamesService)this.fo()).t(new InboxCountsLoadedBinderCallback(d2), null);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.SendRequestResult> d2, String string2, String[] stringArray, int n2, byte[] byArray, int n3) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new RequestSentBinderCallbacks(d2), string2, stringArray, n2, byArray, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.UpdateRequestsResult> d2, String string2, String string3, String[] stringArray) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(d2), string2, string3, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.LoadRequestsResult> d2, String string2, String string3, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(d2), string2, string3, n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void f(a.d<Requests.LoadRequestSummariesResult> d2, String string2, int n2) {
        try {
            ((IGamesService)this.fo()).a((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(d2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Snapshots.LoadSnapshotsResult> d2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.fo()).c((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(d2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    private void hq() {
        for (RealTimeSocket realTimeSocket : this.No.values()) {
            try {
                realTimeSocket.close();
            }
            catch (IOException iOException) {
                GamesLog.b("GamesClientImpl", "IOException:", iOException);
            }
        }
        this.No.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.fo()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                GamesLog.j("GamesClientImpl", "service died");
            }
        }
    }

    public void hr() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.fo()).hr();
            }
            catch (RemoteException remoteException) {
                GamesLog.j("GamesClientImpl", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room Q(DataHolder dataHolder) {
        Room room = null;
        try (RoomBuffer roomBuffer = new RoomBuffer(dataHolder);){
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.Ns = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface x(IBinder iBinder) {
        return this.ah(iBinder);
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status yw;
        private final String NH;

        DeleteSnapshotResultImpl(int statusCode, String snapshotId) {
            this.yw = new Status(statusCode);
            this.NH = snapshotId;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }

        @Override
        public String getSnapshotId() {
            return this.NH;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends b
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata NG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try (SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);){
                this.NG = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0)) : null;
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.NG;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends b
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot Oj;
        private final String Ok;
        private final Snapshot Ol;
        private final Contents Om;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents currentContents) {
            this(dataHolder, null, currentContents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder metadataHolder, String conflictId, Contents currentContents, Contents conflictContents, Contents resolutionContents) {
            super(metadataHolder);
            try (SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(metadataHolder);){
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.Oj = null;
                    this.Ol = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    gy.A(metadataHolder.getStatusCode() != 4004);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.Oj = new SnapshotEntity(snapshotMetadataEntity, currentContents);
                    this.Ol = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.Oj = new SnapshotEntity(snapshotMetadataEntity, currentContents);
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(1));
                    this.Ol = new SnapshotEntity(snapshotMetadataEntity2, conflictContents);
                }
            }
            this.Ok = conflictId;
            this.Om = resolutionContents;
        }

        @Override
        public Snapshot getSnapshot() {
            return this.Oj;
        }

        @Override
        public String getConflictId() {
            return this.Ok;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.Ol;
        }

        @Override
        public Contents getResolutionContents() {
            return this.Om;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends b
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.DD);
        }
    }

    private static final class LoadQuestsResultImpl
    extends b
    implements Quests.LoadQuestsResult {
        private final DataHolder DD;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.DD = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.DD);
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends b
    implements Quests.ClaimMilestoneResult {
        private final Milestone NF;
        private final Quest ND;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String milestoneId) {
            super(dataHolder);
            try (QuestBuffer questBuffer = new QuestBuffer(dataHolder);){
                if (questBuffer.getCount() > 0) {
                    this.ND = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.ND.iE();
                    int n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!list.get(i2).getMilestoneId().equals(milestoneId)) continue;
                        this.NF = list.get(i2);
                        return;
                    }
                    this.NF = null;
                } else {
                    this.NF = null;
                    this.ND = null;
                }
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.NF;
        }

        @Override
        public Quest getQuest() {
            return this.ND;
        }
    }

    private static final class AcceptQuestResultImpl
    extends b
    implements Quests.AcceptQuestResult {
        private final Quest ND;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try (QuestBuffer questBuffer = new QuestBuffer(dataHolder);){
                this.ND = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
        }

        @Override
        public Quest getQuest() {
            return this.ND;
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends b
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status yw;
        private final Bundle NZ;

        LoadRequestsResultImpl(Status status, Bundle requestData) {
            this.yw = status;
            this.NZ = requestData;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string2 = RequestType.cm(requestType);
            if (!this.NZ.containsKey(string2)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.NZ.get(string2);
            return new GameRequestBuffer(dataHolder);
        }

        @Override
        public void release() {
            for (String string2 : this.NZ.keySet()) {
                DataHolder dataHolder = (DataHolder)this.NZ.getParcelable(string2);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends b
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes OR;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.OR = RequestUpdateOutcomes.U(dataHolder);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.OR.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.OR.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends b
    implements Requests.SendRequestResult {
        private final GameRequest Ox;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try (GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);){
                this.Ox = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status yw;
        private final Bundle NK;

        InboxCountResultImpl(Status status, Bundle inboxCounts) {
            this.yw = status;
            this.NK = inboxCounts;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends b
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status yw;
        private final String NI;
        private final boolean NJ;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.yw = new Status(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.NI = dataHolder.c("external_game_id", 0, 0);
                    this.NJ = dataHolder.d("muted", 0, 0);
                } else {
                    this.NI = null;
                    this.NJ = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status yw;
        private final String NI;
        private final boolean NJ;

        public GameMuteStatusChangeResultImpl(int statusCode, String externalGameId, boolean isMuted) {
            this.yw = new Status(statusCode);
            this.NI = externalGameId;
            this.NJ = isMuted;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }
    }

    private static final class LoadAclResultImpl
    extends b
    implements Acls.LoadAclResult {
        LoadAclResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status yw;
        private final String NE;

        CancelMatchResultImpl(Status status, String externalMatchId) {
            this.yw = status;
            this.NE = externalMatchId;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }

        @Override
        public String getMatchId() {
            return this.NE;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends b {
        final TurnBasedMatch Oh;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            try (TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);){
                this.Oh = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
        }

        public TurnBasedMatch getMatch() {
            return this.Oh;
        }
    }

    private static final class SubmitScoreResultImpl
    extends b
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData OJ;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.OJ = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.OJ;
        }
    }

    private static final class LoadOwnerCoverPhotoUrisResultImpl
    implements Players.LoadOwnerCoverPhotoUrisResult {
        private final Status yw;
        private final Bundle HJ;

        LoadOwnerCoverPhotoUrisResultImpl(int statusCode, Bundle bundle) {
            this.yw = new Status(statusCode);
            this.HJ = bundle;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends b
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer Oe;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Oe = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status yw;
        private final List<String> Oc;
        private final Bundle Od;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle xpData) {
            this.yw = status;
            this.Oc = xpData.getStringArrayList("game_category_list");
            this.Od = xpData;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }
    }

    private static final class LoadPlayersResultImpl
    extends b
    implements Players.LoadPlayersResult {
        private final PlayerBuffer NY;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NY = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.NY;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status yw;
        private final LoadMatchesResponse NW;

        LoadMatchesResultImpl(Status status, Bundle matchData) {
            this.yw = status;
            this.NW = new LoadMatchesResponse(matchData);
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.NW;
        }

        @Override
        public void release() {
            this.NW.close();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends b
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer NV;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NV = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.NV;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends b
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity NX;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerScoreResultImpl(DataHolder scoreHolder) {
            super(scoreHolder);
            try (LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(scoreHolder);){
                this.NX = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)leaderboardScoreBuffer.get(0).freeze() : null;
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.NX;
        }
    }

    private static final class LoadScoresResultImpl
    extends b
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity Oa;
        private final LeaderboardScoreBuffer Ob;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder leaderboard, DataHolder scores) {
            super(scores);
            try (LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(leaderboard);){
                this.Oa = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            this.Ob = new LeaderboardScoreBuffer(scores);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.Oa;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.Ob;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends b
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer NO;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NO = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.NO;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends b
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        LoadGameSearchSuggestionsResultImpl(DataHolder data) {
            super(data);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends b
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer NT;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NT = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadExtendedGamesResultImpl
    extends b
    implements GamesMetadata.LoadExtendedGamesResult {
        private final ExtendedGameBuffer NS;

        LoadExtendedGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NS = new ExtendedGameBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends b
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer NU;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NU = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.NU;
        }
    }

    private static final class LoadEventResultImpl
    extends b
    implements Events.LoadEventsResult {
        private final EventBuffer NR;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NR = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.NR;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status yw;
        private final String OQ;

        UpdateAchievementResultImpl(int statusCode, String achievementId) {
            this.yw = new Status(statusCode);
            this.OQ = achievementId;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }

        @Override
        public String getAchievementId() {
            return this.OQ;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends b
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer NQ;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NQ = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.NQ;
        }
    }

    private final class RealTimeMessageSentCallback
    extends hc.b<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int CQ;
        private final String Ot;
        private final int Ou;

        RealTimeMessageSentCallback(RealTimeMultiplayer.ReliableMessageSentCallback listener, int statusCode, int token, String recipientParticipantId) {
            super(listener);
            this.CQ = statusCode;
            this.Ou = token;
            this.Ot = recipientParticipantId;
        }

        public void a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.CQ, this.Ou, this.Ot);
            }
        }

        @Override
        protected void fp() {
        }

        @Override
        public /* synthetic */ void d(Object object) {
            this.a((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private final class MessageReceivedCallback
    extends hc.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage Oi;

        MessageReceivedCallback(RealTimeMessageReceivedListener listener, RealTimeMessage message) {
            super(listener);
            this.Oi = message;
        }

        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.Oi);
            }
        }

        @Override
        protected void fp() {
        }

        @Override
        public /* synthetic */ void d(Object object) {
            this.a((RealTimeMessageReceivedListener)object);
        }
    }

    private final class P2PDisconnectedCallback
    extends hc.b<RoomStatusUpdateListener> {
        private final String On;

        P2PDisconnectedCallback(RoomStatusUpdateListener listener, String participantId) {
            super(listener);
            this.On = participantId;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PDisconnected(this.On);
            }
        }

        @Override
        protected void fp() {
        }

        @Override
        public /* synthetic */ void d(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    private final class P2PConnectedCallback
    extends hc.b<RoomStatusUpdateListener> {
        private final String On;

        P2PConnectedCallback(RoomStatusUpdateListener listener, String participantId) {
            super(listener);
            this.On = participantId;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PConnected(this.On);
            }
        }

        @Override
        protected void fp() {
        }

        @Override
        public /* synthetic */ void d(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    private final class PeerDisconnectedCallback
    extends AbstractPeerStatusCallback {
        PeerDisconnectedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private final class PeerConnectedCallback
    extends AbstractPeerStatusCallback {
        PeerConnectedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private final class PeerDeclinedCallback
    extends AbstractPeerStatusCallback {
        PeerDeclinedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private final class PeerLeftRoomCallback
    extends AbstractPeerStatusCallback {
        PeerLeftRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private final class PeerJoinedRoomCallback
    extends AbstractPeerStatusCallback {
        PeerJoinedRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private final class PeerInvitedToRoomCallback
    extends AbstractPeerStatusCallback {
        PeerInvitedToRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private final class DisconnectedFromRoomCallback
    extends AbstractRoomStatusCallback {
        DisconnectedFromRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private final class ConnectedToRoomCallback
    extends AbstractRoomStatusCallback {
        ConnectedToRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private final class RoomAutoMatchingCallback
    extends AbstractRoomStatusCallback {
        RoomAutoMatchingCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private final class RoomConnectingCallback
    extends AbstractRoomStatusCallback {
        RoomConnectingCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private final class RoomConnectedCallback
    extends AbstractRoomCallback {
        RoomConnectedCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    private final class LeftRoomCallback
    extends hc.b<RoomUpdateListener> {
        private final int CQ;
        private final String NP;

        LeftRoomCallback(RoomUpdateListener listener, int statusCode, String roomId) {
            super(listener);
            this.CQ = statusCode;
            this.NP = roomId;
        }

        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.CQ, this.NP);
        }

        @Override
        protected void fp() {
        }

        @Override
        public /* synthetic */ void d(Object object) {
            this.a((RoomUpdateListener)object);
        }
    }

    private final class JoinedRoomCallback
    extends AbstractRoomCallback {
        public JoinedRoomCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    private final class RoomCreatedCallback
    extends AbstractRoomCallback {
        public RoomCreatedCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    private abstract class AbstractPeerStatusCallback
    extends AbstractRoomStatusCallback {
        private final ArrayList<String> NC;

        AbstractPeerStatusCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder);
            this.NC = new ArrayList();
            int n2 = participantIds.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.NC.add(participantIds[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.NC);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private abstract class AbstractRoomStatusCallback
    extends hc.d<RoomStatusUpdateListener> {
        AbstractRoomStatusCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.a(roomStatusUpdateListener, GamesClientImpl.this.Q(dataHolder));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    private abstract class AbstractRoomCallback
    extends hc.d<RoomUpdateListener> {
        AbstractRoomCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.a(roomUpdateListener, GamesClientImpl.this.Q(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    private final class RequestRemovedCallback
    extends hc.b<OnRequestReceivedListener> {
        private final String Oy;

        RequestRemovedCallback(OnRequestReceivedListener listener, String requestId) {
            super(listener);
            this.Oy = requestId;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.Oy);
        }

        @Override
        protected void fp() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    private final class RequestReceivedCallback
    extends hc.b<OnRequestReceivedListener> {
        private final GameRequest Ox;

        RequestReceivedCallback(OnRequestReceivedListener listener, GameRequest request) {
            super(listener);
            this.Ox = request;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.Ox);
        }

        @Override
        protected void fp() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    private final class QuestCompletedCallback
    extends hc.b<QuestUpdateListener> {
        private final Quest ND;

        QuestCompletedCallback(QuestUpdateListener listener, Quest quest) {
            super(listener);
            this.ND = quest;
        }

        protected void b(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.ND);
        }

        @Override
        protected void fp() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((QuestUpdateListener)object);
        }
    }

    private final class MatchRemovedCallback
    extends hc.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final String Of;

        MatchRemovedCallback(OnTurnBasedMatchUpdateReceivedListener listener, String matchId) {
            super(listener);
            this.Of = matchId;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.Of);
        }

        @Override
        protected void fp() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private final class MatchUpdateReceivedCallback
    extends hc.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch Oh;

        MatchUpdateReceivedCallback(OnTurnBasedMatchUpdateReceivedListener listener, TurnBasedMatch match) {
            super(listener);
            this.Oh = match;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.Oh);
        }

        @Override
        protected void fp() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private final class InvitationRemovedCallback
    extends hc.b<OnInvitationReceivedListener> {
        private final String NN;

        InvitationRemovedCallback(OnInvitationReceivedListener listener, String invitationId) {
            super(listener);
            this.NN = invitationId;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.NN);
        }

        @Override
        protected void fp() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    private final class InvitationReceivedCallback
    extends hc.b<OnInvitationReceivedListener> {
        private final Invitation NM;

        InvitationReceivedCallback(OnInvitationReceivedListener listener, Invitation invitation) {
            super(listener);
            this.NM = invitation;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.NM);
        }

        @Override
        protected void fp() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Snapshots.DeleteSnapshotResult> yO;

        public SnapshotDeletedBinderCallbacks(a.d<Snapshots.DeleteSnapshotResult> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void g(int n2, String string2) {
            this.yO.a(new DeleteSnapshotResultImpl(n2, string2));
        }
    }

    private final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Snapshots.CommitSnapshotResult> OG;

        public SnapshotCommittedBinderCallbacks(a.d<Snapshots.CommitSnapshotResult> resultHolder) {
            this.OG = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void J(DataHolder dataHolder) {
            this.OG.a(new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Snapshots.OpenSnapshotResult> OH;

        public SnapshotOpenedBinderCallbacks(a.d<Snapshots.OpenSnapshotResult> resultHolder) {
            this.OH = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, Contents contents) {
            this.OH.a(new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void a(DataHolder dataHolder, String string2, Contents contents, Contents contents2, Contents contents3) {
            this.OH.a(new OpenSnapshotResultImpl(dataHolder, string2, contents, contents2, contents3));
        }
    }

    private final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Snapshots.LoadSnapshotsResult> OI;

        public SnapshotsLoadedBinderCallbacks(a.d<Snapshots.LoadSnapshotsResult> resultHolder) {
            this.OI = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void I(DataHolder dataHolder) {
            this.OI.a(new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Quests.LoadQuestsResult> Os;

        public QuestsLoadedBinderCallbacks(a.d<Quests.LoadQuestsResult> resultHolder) {
            this.Os = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void O(DataHolder dataHolder) {
            this.Os.a(new LoadQuestsResultImpl(dataHolder));
        }
    }

    private final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Quests.ClaimMilestoneResult> Op;
        private final String Oq;

        public QuestMilestoneClaimBinderCallbacks(a.d<Quests.ClaimMilestoneResult> resultHolder, String milestoneId) {
            this.Op = hn.b(resultHolder, (Object)"Holder must not be null");
            this.Oq = hn.b(milestoneId, (Object)"MilestoneId must not be null");
        }

        @Override
        public void K(DataHolder dataHolder) {
            this.Op.a(new ClaimMilestoneResultImpl(dataHolder, this.Oq));
        }
    }

    private final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Quests.AcceptQuestResult> Oo;

        public QuestAcceptedBinderCallbacks(a.d<Quests.AcceptQuestResult> resultHolder) {
            this.Oo = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void L(DataHolder dataHolder) {
            this.Oo.a(new AcceptQuestResultImpl(dataHolder));
        }
    }

    private final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.LoadRequestSummariesResult> OA;

        public RequestSummariesLoadedBinderCallbacks(a.d<Requests.LoadRequestSummariesResult> resultHolder) {
            this.OA = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void H(DataHolder dataHolder) {
            this.OA.a(new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.LoadRequestsResult> OB;

        public RequestsLoadedBinderCallbacks(a.d<Requests.LoadRequestsResult> resultHolder) {
            this.OB = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void c(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.OB.a(new LoadRequestsResultImpl(status, bundle));
        }
    }

    private final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.SendRequestResult> Oz;

        public RequestSentBinderCallbacks(a.d<Requests.SendRequestResult> resultHolder) {
            this.Oz = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void G(DataHolder dataHolder) {
            this.Oz.a(new SendRequestResultImpl(dataHolder));
        }
    }

    private final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.UpdateRequestsResult> OC;

        public RequestsUpdatedBinderCallbacks(a.d<Requests.UpdateRequestsResult> resultHolder) {
            this.OC = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void F(DataHolder dataHolder) {
            this.OC.a(new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Status> yO;

        public SignOutCompleteBinderCallbacks(a.d<Status> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void dO() {
            Status status = new Status(0);
            this.yO.a(status);
        }
    }

    private final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Notifications.InboxCountResult> yO;

        InboxCountsLoadedBinderCallback(a.d<Notifications.InboxCountResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void f(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.yO.a(new InboxCountResultImpl(status, bundle));
        }
    }

    private final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Status> yO;

        ContactSettingsUpdatedBinderCallback(a.d<Status> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void ce(int n2) {
            this.yO.a(new Status(n2));
        }
    }

    private final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Notifications.ContactSettingLoadResult> yO;

        ContactSettingsLoadedBinderCallback(a.d<Notifications.ContactSettingLoadResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void D(DataHolder dataHolder) {
            this.yO.a(new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Notifications.GameMuteStatusLoadResult> yO;

        GameMuteStatusLoadedBinderCallback(a.d<Notifications.GameMuteStatusLoadResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void B(DataHolder dataHolder) {
            this.yO.a(new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Notifications.GameMuteStatusChangeResult> yO;

        GameMuteStatusChangedBinderCallback(a.d<Notifications.GameMuteStatusChangeResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void a(int n2, String string2, boolean bl2) {
            this.yO.a(new GameMuteStatusChangeResultImpl(n2, string2, bl2));
        }
    }

    private final class NotifyAclUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Status> yO;

        NotifyAclUpdatedBinderCallback(a.d<Status> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void cd(int n2) {
            this.yO.a(new Status(n2));
        }
    }

    private final class NotifyAclLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Acls.LoadAclResult> yO;

        NotifyAclLoadedBinderCallback(a.d<Acls.LoadAclResult> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void C(DataHolder dataHolder) {
            this.yO.a(new LoadAclResultImpl(dataHolder));
        }
    }

    private final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final RealTimeMultiplayer.ReliableMessageSentCallback Ov;

        public RealTimeReliableMessageBinderCallbacks(RealTimeMultiplayer.ReliableMessageSentCallback messageSentCallbacks) {
            this.Ov = messageSentCallbacks;
        }

        @Override
        public void b(int n2, int n3, String string2) {
            GamesClientImpl.this.a(new RealTimeMessageSentCallback(this.Ov, n2, n3, string2));
        }
    }

    private final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final RoomUpdateListener OD;
        private final RoomStatusUpdateListener OE;
        private final RealTimeMessageReceivedListener OF;

        public RoomBinderCallbacks(RoomUpdateListener roomCallbacks) {
            this.OD = hn.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.OE = null;
            this.OF = null;
        }

        public RoomBinderCallbacks(RoomUpdateListener roomCallbacks, RoomStatusUpdateListener roomStatusCallbacks, RealTimeMessageReceivedListener realTimeMessageReceivedCallbacks) {
            this.OD = hn.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.OE = roomStatusCallbacks;
            this.OF = realTimeMessageReceivedCallbacks;
        }

        @Override
        public void u(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomCreatedCallback(this.OD, dataHolder));
        }

        @Override
        public void v(DataHolder dataHolder) {
            GamesClientImpl.this.a(new JoinedRoomCallback(this.OD, dataHolder));
        }

        @Override
        public void onLeftRoom(int statusCode, String externalRoomId) {
            GamesClientImpl.this.a(new LeftRoomCallback(this.OD, statusCode, externalRoomId));
        }

        @Override
        public void y(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomConnectedCallback(this.OD, dataHolder));
        }

        @Override
        public void w(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomConnectingCallback(this.OE, dataHolder));
        }

        @Override
        public void x(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomAutoMatchingCallback(this.OE, dataHolder));
        }

        @Override
        public void z(DataHolder dataHolder) {
            GamesClientImpl.this.a(new ConnectedToRoomCallback(this.OE, dataHolder));
        }

        @Override
        public void A(DataHolder dataHolder) {
            GamesClientImpl.this.a(new DisconnectedFromRoomCallback(this.OE, dataHolder));
        }

        @Override
        public void e(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerConnectedCallback(this.OE, dataHolder, stringArray));
        }

        @Override
        public void f(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerDisconnectedCallback(this.OE, dataHolder, stringArray));
        }

        @Override
        public void a(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerInvitedToRoomCallback(this.OE, dataHolder, stringArray));
        }

        @Override
        public void b(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerJoinedRoomCallback(this.OE, dataHolder, stringArray));
        }

        @Override
        public void c(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerLeftRoomCallback(this.OE, dataHolder, stringArray));
        }

        @Override
        public void d(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerDeclinedCallback(this.OE, dataHolder, stringArray));
        }

        @Override
        public void onP2PConnected(String participantId) {
            GamesClientImpl.this.a(new P2PConnectedCallback(this.OE, participantId));
        }

        @Override
        public void onP2PDisconnected(String participantId) {
            GamesClientImpl.this.a(new P2PDisconnectedCallback(this.OE, participantId));
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage message) {
            GamesClientImpl.this.a(new MessageReceivedCallback(this.OF, message));
        }
    }

    private final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.CancelMatchResult> OK;

        public TurnBasedMatchCanceledBinderCallbacks(a.d<TurnBasedMultiplayer.CancelMatchResult> resultHolder) {
            this.OK = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void f(int n2, String string2) {
            Status status = new Status(n2);
            this.OK.a(new CancelMatchResultImpl(status, string2));
        }
    }

    private final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.LeaveMatchResult> OM;

        public TurnBasedMatchLeftBinderCallbacks(a.d<TurnBasedMultiplayer.LeaveMatchResult> resultHolder) {
            this.OM = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void s(DataHolder dataHolder) {
            this.OM.a(new LeaveMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.UpdateMatchResult> OO;

        public TurnBasedMatchUpdatedBinderCallbacks(a.d<TurnBasedMultiplayer.UpdateMatchResult> resultHolder) {
            this.OO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void r(DataHolder dataHolder) {
            this.OO.a(new UpdateMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.InitiateMatchResult> OL;

        public TurnBasedMatchInitiatedBinderCallbacks(a.d<TurnBasedMultiplayer.InitiateMatchResult> resultHolder) {
            this.OL = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void q(DataHolder dataHolder) {
            this.OL.a(new InitiateMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.LoadMatchResult> ON;

        public TurnBasedMatchLoadedBinderCallbacks(a.d<TurnBasedMultiplayer.LoadMatchResult> resultHolder) {
            this.ON = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void p(DataHolder dataHolder) {
            this.ON.a(new LoadMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.LoadMatchesResult> OP;

        public TurnBasedMatchesLoadedBinderCallbacks(a.d<TurnBasedMultiplayer.LoadMatchesResult> resultHolder) {
            this.OP = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void b(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.OP.a(new LoadMatchesResultImpl(status, bundle));
        }
    }

    private final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.SubmitScoreResult> yO;

        public SubmitScoreBinderCallbacks(a.d<Leaderboards.SubmitScoreResult> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void f(DataHolder dataHolder) {
            this.yO.a(new SubmitScoreResultImpl(dataHolder));
        }
    }

    private final class OwnerCoverPhotoUrisLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Players.LoadOwnerCoverPhotoUrisResult> yO;

        OwnerCoverPhotoUrisLoadedBinderCallback(a.d<Players.LoadOwnerCoverPhotoUrisResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void d(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            this.yO.a(new LoadOwnerCoverPhotoUrisResultImpl(n2, bundle));
        }
    }

    final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Players.LoadXpStreamResult> yO;

        PlayerXpStreamLoadedBinderCallback(a.d<Players.LoadXpStreamResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void P(DataHolder dataHolder) {
            this.yO.a(new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Players.LoadXpForGameCategoriesResult> yO;

        PlayerXpForGameCategoriesLoadedBinderCallback(a.d<Players.LoadXpForGameCategoriesResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void e(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.yO.a(new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Players.LoadPlayersResult> yO;

        PlayersLoadedBinderCallback(a.d<Players.LoadPlayersResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void g(DataHolder dataHolder) {
            this.yO.a(new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void h(DataHolder dataHolder) {
            this.yO.a(new LoadPlayersResultImpl(dataHolder));
        }
    }

    private final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnRequestReceivedListener Ow;

        RequestReceivedBinderCallback(OnRequestReceivedListener listener) {
            this.Ow = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void o(DataHolder dataHolder) {
            GameRequest gameRequest = null;
            try (GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);){
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            if (gameRequest != null) {
                GamesClientImpl.this.a(new RequestReceivedCallback(this.Ow, gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String requestId) {
            GamesClientImpl.this.a(new RequestRemovedCallback(this.Ow, requestId));
        }
    }

    private final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final QuestUpdateListener Or;

        QuestUpdateBinderCallback(QuestUpdateListener listener) {
            this.Or = listener;
        }

        @Override
        public void M(DataHolder dataHolder) {
            Quest quest = this.R(dataHolder);
            if (quest != null) {
                GamesClientImpl.this.a(new QuestCompletedCallback(this.Or, quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest R(DataHolder dataHolder) {
            Quest quest = null;
            try (QuestBuffer questBuffer = new QuestBuffer(dataHolder);){
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            return quest;
        }
    }

    private final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnTurnBasedMatchUpdateReceivedListener Og;

        MatchUpdateReceivedBinderCallback(OnTurnBasedMatchUpdateReceivedListener listener) {
            this.Og = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void t(DataHolder dataHolder) {
            TurnBasedMatch turnBasedMatch = null;
            try (TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);){
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            if (turnBasedMatch != null) {
                GamesClientImpl.this.a(new MatchUpdateReceivedCallback(this.Og, turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String matchId) {
            GamesClientImpl.this.a(new MatchRemovedCallback(this.Og, matchId));
        }
    }

    private final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnInvitationReceivedListener NL;

        InvitationReceivedBinderCallback(OnInvitationReceivedListener listener) {
            this.NL = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void n(DataHolder dataHolder) {
            Invitation invitation = null;
            try (InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);){
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            if (invitation != null) {
                GamesClientImpl.this.a(new InvitationReceivedCallback(this.NL, invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String invitationId) {
            GamesClientImpl.this.a(new InvitationRemovedCallback(this.NL, invitationId));
        }
    }

    private final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Invitations.LoadInvitationsResult> yO;

        InvitationsLoadedBinderCallback(a.d<Invitations.LoadInvitationsResult> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void m(DataHolder dataHolder) {
            this.yO.a(new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.LoadPlayerScoreResult> yO;

        PlayerLeaderboardScoreLoadedBinderCallback(a.d<Leaderboards.LoadPlayerScoreResult> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void E(DataHolder dataHolder) {
            this.yO.a(new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.LoadScoresResult> yO;

        LeaderboardScoresLoadedBinderCallback(a.d<Leaderboards.LoadScoresResult> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, DataHolder dataHolder2) {
            this.yO.a(new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.LeaderboardMetadataResult> yO;

        LeaderboardsLoadedBinderCallback(a.d<Leaderboards.LeaderboardMetadataResult> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void e(DataHolder dataHolder) {
            this.yO.a(new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadGameSearchSuggestionsResult> yO;

        GameSearchSuggestionsLoadedBinderCallback(a.d<GamesMetadata.LoadGameSearchSuggestionsResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void l(DataHolder dataHolder) {
            this.yO.a(new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadGameInstancesResult> yO;

        GameInstancesLoadedBinderCallback(a.d<GamesMetadata.LoadGameInstancesResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void k(DataHolder dataHolder) {
            this.yO.a(new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private final class ExtendedGamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadExtendedGamesResult> yO;

        ExtendedGamesLoadedBinderCallback(a.d<GamesMetadata.LoadExtendedGamesResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void j(DataHolder dataHolder) {
            this.yO.a(new LoadExtendedGamesResultImpl(dataHolder));
        }
    }

    private final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Events.LoadEventsResult> yO;

        EventsLoadedBinderCallback(a.d<Events.LoadEventsResult> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void d(DataHolder dataHolder) {
            this.yO.a(new LoadEventResultImpl(dataHolder));
        }
    }

    private final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadGamesResult> yO;

        GamesLoadedBinderCallback(a.d<GamesMetadata.LoadGamesResult> holder) {
            this.yO = hn.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void i(DataHolder dataHolder) {
            this.yO.a(new LoadGamesResultImpl(dataHolder));
        }
    }

    private final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Achievements.UpdateAchievementResult> yO;

        AchievementUpdatedBinderCallback(a.d<Achievements.UpdateAchievementResult> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void e(int n2, String string2) {
            this.yO.a(new UpdateAchievementResultImpl(n2, string2));
        }
    }

    private final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Achievements.LoadAchievementsResult> yO;

        AchievementsLoadedBinderCallback(a.d<Achievements.LoadAchievementsResult> resultHolder) {
            this.yO = hn.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void c(DataHolder dataHolder) {
            this.yO.a(new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void o(String string2, int n2) {
            try {
                ((IGamesService)GamesClientImpl.this.fo()).l(string2, n2);
            }
            catch (RemoteException remoteException) {
                GamesLog.j("GamesClientImpl", "service died");
            }
        }
    }
}

