/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.il;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String Sm;
    private final String Lk;
    private final Uri Mo;
    private final int Sn;
    private final ArrayList<LeaderboardVariantEntity> So;
    private final Game Sp;
    private final String Mz;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.Sm = leaderboard.getLeaderboardId();
        this.Lk = leaderboard.getDisplayName();
        this.Mo = leaderboard.getIconImageUri();
        this.Mz = leaderboard.getIconImageUrl();
        this.Sn = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.Sp = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n2 = arrayList.size();
        this.So = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.So.add((LeaderboardVariantEntity)arrayList.get(i2).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.Sm;
    }

    @Override
    public String getDisplayName() {
        return this.Lk;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        il.b(this.Lk, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.Mo;
    }

    @Override
    public String getIconImageUrl() {
        return this.Mz;
    }

    @Override
    public int getScoreOrder() {
        return this.Sn;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.So);
    }

    @Override
    public Game getGame() {
        return this.Sp;
    }

    public Leaderboard iu() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.a(this);
    }

    static int a(Leaderboard leaderboard) {
        return hl.hashCode(leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants());
    }

    public boolean equals(Object obj) {
        return LeaderboardEntity.a(this, obj);
    }

    static boolean a(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return hl.equal(leaderboard2.getLeaderboardId(), leaderboard.getLeaderboardId()) && hl.equal(leaderboard2.getDisplayName(), leaderboard.getDisplayName()) && hl.equal(leaderboard2.getIconImageUri(), leaderboard.getIconImageUri()) && hl.equal(leaderboard2.getScoreOrder(), leaderboard.getScoreOrder()) && hl.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.b(this);
    }

    static String b(Leaderboard leaderboard) {
        return hl.e(leaderboard).a("LeaderboardId", leaderboard.getLeaderboardId()).a("DisplayName", leaderboard.getDisplayName()).a("IconImageUri", leaderboard.getIconImageUri()).a("IconImageUrl", leaderboard.getIconImageUrl()).a("ScoreOrder", leaderboard.getScoreOrder()).a("Variants", leaderboard.getVariants()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.iu();
    }
}

