/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.internal.hn;
import java.util.ArrayList;

public final class TurnBasedMatchConfig {
    private final int SV;
    private final String[] Tk;
    private final Bundle Tl;
    private final int Tw;

    private TurnBasedMatchConfig(Builder builder) {
        this.SV = builder.SV;
        this.Tw = builder.Tw;
        this.Tl = builder.Tl;
        int n2 = builder.To.size();
        this.Tk = builder.To.toArray(new String[n2]);
    }

    public int getVariant() {
        return this.SV;
    }

    public int iC() {
        return this.Tw;
    }

    public String[] getInvitedPlayerIds() {
        return this.Tk;
    }

    public Bundle getAutoMatchCriteria() {
        return this.Tl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        int SV = -1;
        ArrayList<String> To = new ArrayList();
        Bundle Tl = null;
        int Tw = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            hn.f(playerId);
            this.To.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            hn.f(playerIds);
            this.To.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            hn.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.SV = variant;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.Tl = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfig(this);
        }
    }
}

