/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.il;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final SnapshotMetadataEntityCreator CREATOR = new SnapshotMetadataEntityCreator();
    private final int xJ;
    private final GameEntity Rq;
    private final PlayerEntity Ui;
    private final String NH;
    private final Uri Ue;
    private final String Uj;
    private final String HV;
    private final String Mm;
    private final long Uk;
    private final long Ul;
    private final float Um;
    private final String Un;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.xJ = 3;
        this.Rq = new GameEntity(snapshotMetadata.getGame());
        this.Ui = new PlayerEntity(snapshotMetadata.getOwner());
        this.NH = snapshotMetadata.getSnapshotId();
        this.Ue = snapshotMetadata.getCoverImageUri();
        this.Uj = snapshotMetadata.getCoverImageUrl();
        this.Um = snapshotMetadata.getCoverImageAspectRatio();
        this.HV = snapshotMetadata.getTitle();
        this.Mm = snapshotMetadata.getDescription();
        this.Uk = snapshotMetadata.getLastModifiedTimestamp();
        this.Ul = snapshotMetadata.getPlayedTime();
        this.Un = snapshotMetadata.getUniqueName();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName) {
        this.xJ = versionCode;
        this.Rq = game;
        this.Ui = owner;
        this.NH = snapshotId;
        this.Ue = coverImageUri;
        this.Uj = coverImageUrl;
        this.Um = coverImageAspectRatio;
        this.HV = title;
        this.Mm = description;
        this.Uk = lastModifiedTimestamp;
        this.Ul = playedTime;
        this.Un = uniqueName;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public Game getGame() {
        return this.Rq;
    }

    @Override
    public Player getOwner() {
        return this.Ui;
    }

    @Override
    public String getSnapshotId() {
        return this.NH;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.Ue;
    }

    @Override
    public String getCoverImageUrl() {
        return this.Uj;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.Um;
    }

    @Override
    public String getUniqueName() {
        return this.Un;
    }

    @Override
    public String getTitle() {
        return this.HV;
    }

    @Override
    public String getDescription() {
        return this.Mm;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        il.b(this.Mm, dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.Uk;
    }

    @Override
    public long getPlayedTime() {
        return this.Ul;
    }

    @Override
    public SnapshotMetadata freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.a(this);
    }

    static int a(SnapshotMetadata snapshotMetadata) {
        return hl.hashCode(snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName());
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.a(this, obj);
    }

    static boolean a(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return hl.equal(snapshotMetadata2.getGame(), snapshotMetadata.getGame()) && hl.equal(snapshotMetadata2.getOwner(), snapshotMetadata.getOwner()) && hl.equal(snapshotMetadata2.getSnapshotId(), snapshotMetadata.getSnapshotId()) && hl.equal(snapshotMetadata2.getCoverImageUri(), snapshotMetadata.getCoverImageUri()) && hl.equal(Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && hl.equal(snapshotMetadata2.getTitle(), snapshotMetadata.getTitle()) && hl.equal(snapshotMetadata2.getDescription(), snapshotMetadata.getDescription()) && hl.equal(snapshotMetadata2.getLastModifiedTimestamp(), snapshotMetadata.getLastModifiedTimestamp()) && hl.equal(snapshotMetadata2.getPlayedTime(), snapshotMetadata.getPlayedTime()) && hl.equal(snapshotMetadata2.getUniqueName(), snapshotMetadata.getUniqueName());
    }

    public String toString() {
        return SnapshotMetadataEntity.b(this);
    }

    static String b(SnapshotMetadata snapshotMetadata) {
        return hl.e(snapshotMetadata).a("Game", snapshotMetadata.getGame()).a("Owner", snapshotMetadata.getOwner()).a("SnapshotId", snapshotMetadata.getSnapshotId()).a("CoverImageUri", snapshotMetadata.getCoverImageUri()).a("CoverImageUrl", snapshotMetadata.getCoverImageUrl()).a("CoverImageAspectRatio", Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).a("Description", snapshotMetadata.getDescription()).a("LastModifiedTimestamp", snapshotMetadata.getLastModifiedTimestamp()).a("PlayedTime", snapshotMetadata.getPlayedTime()).a("UniqueName", snapshotMetadata.getUniqueName()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.a(this, out, flags);
    }
}

