/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.hd;
import com.google.android.gms.internal.he;
import com.google.android.gms.internal.hi;
import com.google.android.gms.internal.hj;
import com.google.android.gms.internal.hn;
import java.util.ArrayList;

public abstract class hc<T extends IInterface>
implements Api.a,
hd.b {
    private final Context mContext;
    private final Looper DC;
    final Handler mHandler;
    private T FY;
    private final ArrayList<b<?>> FZ = new ArrayList();
    private f Ga;
    private volatile int Gb = 1;
    private final String[] Gc;
    boolean Gd = false;
    private final hd DP;
    public static final String[] Ge = new String[]{"service_esmobile", "service_googleme"};

    protected hc(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = hn.f(context);
        this.DC = hn.b(looper, (Object)"Looper must not be null");
        this.DP = new hd(context, looper, this);
        this.mHandler = new a(looper);
        this.b(stringArray);
        this.Gc = stringArray;
        this.registerConnectionCallbacks(hn.f(connectionCallbacks));
        this.registerConnectionFailedListener(hn.f(onConnectionFailedListener));
    }

    @Deprecated
    protected hc(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this(context, context.getMainLooper(), new c(connectionCallbacks), new g(onConnectionFailedListener), stringArray);
    }

    protected void b(String ... stringArray) {
    }

    protected abstract String bp();

    protected abstract String bq();

    protected abstract T x(IBinder var1);

    private void am(int n2) {
        int n3 = this.Gb;
        this.Gb = n2;
        if (n3 != n2) {
            if (n2 == 3) {
                this.onConnected();
            } else if (n3 == 3 && n2 == 1) {
                this.onDisconnected();
            }
        }
    }

    protected void onConnected() {
    }

    protected void onDisconnected() {
    }

    @Override
    public void connect() {
        this.Gd = true;
        this.am(2);
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.am(1);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.Ga != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.FY = null;
            he.B(this.mContext).b(this.bp(), this.Ga);
        }
        this.Ga = new f();
        boolean bl2 = he.B(this.mContext).a(this.bp(), this.Ga);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.bp()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.Gb == 3;
    }

    public boolean isConnecting() {
        return this.Gb == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.Gd = false;
        ArrayList<b<?>> arrayList = this.FZ;
        synchronized (arrayList) {
            int n2 = this.FZ.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.FZ.get(i2).fr();
            }
            this.FZ.clear();
        }
        this.am(1);
        this.FY = null;
        if (this.Ga != null) {
            he.B(this.mContext).b(this.bp(), this.Ga);
            this.Ga = null;
        }
    }

    public void an(int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)n2));
    }

    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.DC;
    }

    public final String[] fn() {
        return this.Gc;
    }

    protected final void I(IBinder iBinder) {
        try {
            hj hj2 = hj.a.L(iBinder);
            this.a(hj2, new e(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(hj var1, e var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new h(n2, iBinder, bundle)));
    }

    protected final void ci() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle ea() {
        return null;
    }

    public final T fo() {
        this.ci();
        return this.FY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.FZ;
        synchronized (arrayList) {
            this.FZ.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean eJ() {
        return this.Gd;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.DP.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.DP.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.DP.registerConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.DP.isConnectionCallbacksRegistered(new c(listener));
    }

    @Deprecated
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.DP.unregisterConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.DP.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.DP.isConnectionFailedListenerRegistered(listener);
    }

    @Deprecated
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.DP.unregisterConnectionFailedListener(listener);
    }

    public static final class e
    extends hi.a {
        private hc Gi;

        public e(hc hc2) {
            this.Gi = hc2;
        }

        @Override
        public void b(int n2, IBinder iBinder, Bundle bundle) {
            hn.b("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.Gi);
            this.Gi.a(n2, iBinder, bundle);
            this.Gi = null;
        }
    }

    protected final class h
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle Gk;
        public final IBinder Gl;

        public h(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.Gl = iBinder;
            this.Gk = bundle;
        }

        protected void b(Boolean bl2) {
            if (bl2 == null) {
                hc.this.am(1);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.Gl.getInterfaceDescriptor();
                        if (hc.this.bq().equals(string2)) {
                            hc.this.FY = hc.this.x(this.Gl);
                            if (hc.this.FY != null) {
                                hc.this.am(3);
                                hc.this.DP.ck();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    he.B(hc.this.mContext).b(hc.this.bp(), hc.this.Ga);
                    hc.this.Ga = null;
                    hc.this.am(1);
                    hc.this.FY = null;
                    hc.this.DP.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    hc.this.am(1);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.Gk != null) {
                        pendingIntent = (PendingIntent)this.Gk.getParcelable("pendingIntent");
                    }
                    if (hc.this.Ga != null) {
                        he.B(hc.this.mContext).b(hc.this.bp(), hc.this.Ga);
                        hc.this.Ga = null;
                    }
                    hc.this.am(1);
                    hc.this.FY = null;
                    hc.this.DP.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void fp() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((Boolean)object);
        }
    }

    public static final class g
    implements GoogleApiClient.OnConnectionFailedListener {
        private final GooglePlayServicesClient.OnConnectionFailedListener Gj;

        public g(GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.Gj = onConnectionFailedListener;
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.Gj.onConnectionFailed(result);
        }

        public boolean equals(Object other) {
            if (other instanceof g) {
                return this.Gj.equals(((g)other).Gj);
            }
            return this.Gj.equals(other);
        }
    }

    public static final class c
    implements GoogleApiClient.ConnectionCallbacks {
        private final GooglePlayServicesClient.ConnectionCallbacks Gh;

        public c(GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks) {
            this.Gh = connectionCallbacks;
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.Gh.onConnected(connectionHint);
        }

        @Override
        public void onConnectionSuspended(int cause) {
            this.Gh.onDisconnected();
        }

        public boolean equals(Object other) {
            if (other instanceof c) {
                return this.Gh.equals(((c)other).Gh);
            }
            return this.Gh.equals(other);
        }
    }

    public abstract class d<TListener>
    extends b<TListener> {
        private final DataHolder DD;

        public d(TListener TListener, DataHolder dataHolder) {
            super(TListener);
            this.DD = dataHolder;
        }

        @Override
        protected final void d(TListener TListener) {
            this.a(TListener, this.DD);
        }

        protected abstract void a(TListener var1, DataHolder var2);

        @Override
        protected void fp() {
            if (this.DD != null) {
                this.DD.close();
            }
        }
    }

    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean Gg;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.Gg = false;
        }

        protected abstract void d(TListener var1);

        protected abstract void fp();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fq() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.Gg) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.d(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.fp();
                    throw runtimeException;
                }
            } else {
                this.fp();
            }
            b2 = this;
            synchronized (b2) {
                this.Gg = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.fr();
            ArrayList arrayList = hc.this.FZ;
            synchronized (arrayList) {
                hc.this.FZ.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fr() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1 && !hc.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.fp();
                b2.unregister();
                return;
            }
            if (msg.what == 3) {
                hc.this.DP.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                hc.this.am(1);
                hc.this.FY = null;
                hc.this.DP.ao((Integer)msg.obj);
                return;
            }
            if (msg.what == 2 && !hc.this.isConnected()) {
                b b3 = (b)msg.obj;
                b3.fp();
                b3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                b b4 = (b)msg.obj;
                b4.fq();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class f
    implements ServiceConnection {
        f() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            hc.this.I(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            hc.this.mHandler.sendMessage(hc.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

