/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzbpo;
import com.google.android.gms.internal.ads.zzbrf;
import com.google.android.gms.internal.ads.zzbrk;
import com.google.android.gms.internal.ads.zzbsx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbqn
extends zzbpo<Double>
implements zzbrk<Double>,
zzbsx,
RandomAccess {
    private static final zzbqn zzfmn = new zzbqn();
    private double[] zzfmo;
    private int size;

    zzbqn() {
        this(new double[10], 0);
    }

    private zzbqn(double[] dArray, int n) {
        this.zzfmo = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzakk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzfmo, n2, this.zzfmo, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbqn)) {
            return super.equals(object);
        }
        zzbqn zzbqn2 = (zzbqn)object;
        if (this.size != zzbqn2.size) {
            return false;
        }
        double[] dArray = zzbqn2.zzfmo;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzfmo[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzfmo[i]);
            n = n * 31 + zzbrf.zzbi(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzd(this.size, d);
    }

    private final void zzd(int n, double d) {
        this.zzakk();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzek(n));
        }
        if (this.size < this.zzfmo.length) {
            System.arraycopy(this.zzfmo, n, this.zzfmo, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzfmo, 0, dArray, 0, n);
            System.arraycopy(this.zzfmo, n, dArray, n + 1, this.size - n);
            this.zzfmo = dArray;
        }
        this.zzfmo[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzakk();
        zzbrf.checkNotNull(collection);
        if (!(collection instanceof zzbqn)) {
            return super.addAll(collection);
        }
        zzbqn zzbqn2 = (zzbqn)collection;
        if (zzbqn2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbqn2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbqn2.size;
        if (n > this.zzfmo.length) {
            this.zzfmo = Arrays.copyOf(this.zzfmo, n);
        }
        System.arraycopy(zzbqn2.zzfmo, 0, this.zzfmo, this.size, zzbqn2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzakk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzfmo[i])) continue;
            System.arraycopy(this.zzfmo, i + 1, this.zzfmo, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzej(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzek(n));
        }
    }

    private final String zzek(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzbqn zzbqn2 = this;
        zzbqn2.zzakk();
        zzbqn2.zzej(n);
        double d3 = zzbqn2.zzfmo[n];
        zzbqn2.zzfmo[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbqn zzbqn2 = this;
        zzbqn2.zzakk();
        zzbqn2.zzej(n);
        double d = zzbqn2.zzfmo[n];
        if (n < zzbqn2.size - 1) {
            System.arraycopy(zzbqn2.zzfmo, n + 1, zzbqn2.zzfmo, n, zzbqn2.size - n);
        }
        --zzbqn2.size;
        ++zzbqn2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzd(n, d);
    }

    @Override
    public final /* synthetic */ zzbrk zzel(int n) {
        int n2 = n;
        zzbqn zzbqn2 = this;
        if (n2 < zzbqn2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbqn(Arrays.copyOf(zzbqn2.zzfmo, n2), zzbqn2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbqn zzbqn2 = this;
        zzbqn2.zzej(n);
        return zzbqn2.zzfmo[n];
    }

    static {
        zzfmn.zzakj();
    }
}

