/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.internal.zzff;
import com.google.android.gms.internal.zzqf;

public final class PublisherAdView
extends ViewGroup {
    private final zzff zzrF;

    public PublisherAdView(Context context) {
        super(context);
        this.zzrF = new zzff(this);
    }

    public PublisherAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzrF = new zzff(this, attributeSet, true);
    }

    public PublisherAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzrF = new zzff(this, attributeSet, true);
    }

    public VideoController getVideoController() {
        return this.zzrF.getVideoController();
    }

    public void setVideoOptions(VideoOptions videoOptions) {
        this.zzrF.setVideoOptions(videoOptions);
    }

    public VideoOptions getVideoOptions() {
        return this.zzrF.getVideoOptions();
    }

    public void destroy() {
        this.zzrF.destroy();
    }

    public AdListener getAdListener() {
        return this.zzrF.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zzrF.getAdSize();
    }

    public AdSize[] getAdSizes() {
        return this.zzrF.getAdSizes();
    }

    public String getAdUnitId() {
        return this.zzrF.getAdUnitId();
    }

    public AppEventListener getAppEventListener() {
        return this.zzrF.getAppEventListener();
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzrF.getOnCustomRenderedAdLoadedListener();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zzrF.zza(publisherAdRequest.zzbp());
    }

    public void pause() {
        this.zzrF.pause();
    }

    public void setManualImpressionsEnabled(boolean bl) {
        this.zzrF.setManualImpressionsEnabled(bl);
    }

    public void recordManualImpression() {
        this.zzrF.recordManualImpression();
    }

    public void resume() {
        this.zzrF.resume();
    }

    public void setAdListener(AdListener adListener) {
        this.zzrF.setAdListener(adListener);
    }

    public void setAdSizes(AdSize ... adSizeArray) {
        if (adSizeArray == null || adSizeArray.length < 1) {
            throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
        }
        this.zzrF.zza(adSizeArray);
    }

    public void setAdUnitId(String string) {
        this.zzrF.setAdUnitId(string);
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        this.zzrF.setAppEventListener(appEventListener);
    }

    public void setCorrelator(Correlator correlator) {
        this.zzrF.setCorrelator(correlator);
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzrF.setOnCustomRenderedAdLoadedListener(onCustomRenderedAdLoadedListener);
    }

    public String getMediationAdapterClassName() {
        return this.zzrF.getMediationAdapterClassName();
    }

    public boolean isLoading() {
        return this.zzrF.isLoading();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzqf.zzb("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }
}

