/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.internal.zzdx;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzei;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzlj;
import com.google.android.gms.internal.zzln;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zznz;
import com.google.android.gms.internal.zzqf;

@zzme
public class zzfg {
    private final zzjz zzAj = new zzjz();
    private final Context mContext;
    private final zzef zzrw;
    private AdListener zzyS;
    private zzdx zzyR;
    private zzet zzAo;
    private String zzts;
    private String zzAs;
    private AppEventListener zzzE;
    private PlayStorePurchaseListener zzAr;
    private InAppPurchaseListener zzAp;
    private PublisherInterstitialAd zzAw;
    private OnCustomRenderedAdLoadedListener zzAq;
    private Correlator zzAn;
    private RewardedVideoAdListener zzcJ;
    private boolean zzAx;

    public zzfg(Context context) {
        this(context, zzef.zzeD(), null);
    }

    public zzfg(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzef.zzeD(), publisherInterstitialAd);
    }

    public zzfg(Context context, zzef zzef2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzrw = zzef2;
        this.zzAw = publisherInterstitialAd;
    }

    public AdListener getAdListener() {
        return this.zzyS;
    }

    public String getAdUnitId() {
        return this.zzts;
    }

    public AppEventListener getAppEventListener() {
        return this.zzzE;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzAp;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzAq;
    }

    public boolean isLoaded() {
        try {
            if (this.zzAo == null) {
                return false;
            }
            return this.zzAo.isReady();
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public boolean isLoading() {
        try {
            if (this.zzAo == null) {
                return false;
            }
            return this.zzAo.isLoading();
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public void zza(zzfe zzfe2) {
        try {
            if (this.zzAo == null) {
                this.zzS("loadAd");
            }
            if (this.zzAo.zzb(this.zzrw.zza(this.mContext, zzfe2))) {
                this.zzAj.zzi(zzfe2.zzfd());
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to load ad.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzyS = adListener;
            if (this.zzAo != null) {
                this.zzAo.zza(adListener != null ? new zzdz(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zzdx zzdx2) {
        try {
            this.zzyR = zzdx2;
            if (this.zzAo != null) {
                this.zzAo.zza(zzdx2 != null ? new zzdy(zzdx2) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdUnitId(String string) {
        if (this.zzts != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzts = string;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzzE = appEventListener;
            if (this.zzAo != null) {
                this.zzAo.zza(appEventListener != null ? new zzei(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzAr != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzAp = inAppPurchaseListener;
            if (this.zzAo != null) {
                this.zzAo.zza(inAppPurchaseListener != null ? new zzlj(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzAq = onCustomRenderedAdLoadedListener;
            if (this.zzAo != null) {
                this.zzAo.zza(onCustomRenderedAdLoadedListener != null ? new zzgq(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String string) {
        if (this.zzAp != null) {
            throw new IllegalStateException("In app purchase parameter has already been set.");
        }
        try {
            this.zzAr = playStorePurchaseListener;
            this.zzAs = string;
            if (this.zzAo != null) {
                this.zzAo.zza(playStorePurchaseListener != null ? new zzln(playStorePurchaseListener) : null, string);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setCorrelator(Correlator correlator) {
        this.zzAn = correlator;
        try {
            if (this.zzAo != null) {
                this.zzAo.zza(this.zzAn == null ? null : this.zzAn.zzbq());
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set correlator.", remoteException);
        }
    }

    public void setRewardedVideoAdListener(RewardedVideoAdListener rewardedVideoAdListener) {
        try {
            this.zzcJ = rewardedVideoAdListener;
            if (this.zzAo != null) {
                this.zzAo.zza(rewardedVideoAdListener != null ? new zznz(rewardedVideoAdListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the AdListener.", remoteException);
        }
    }

    public void zzd(boolean bl) {
        this.zzAx = bl;
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzAo != null) {
                return this.zzAo.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public void show() {
        try {
            this.zzT("show");
            this.zzAo.showInterstitial();
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to show interstitial.", remoteException);
        }
    }

    private void zzS(String string) throws RemoteException {
        if (this.zzts == null) {
            this.zzT(string);
        }
        zzeg zzeg2 = this.zzAx ? zzeg.zzeE() : new zzeg();
        this.zzAo = zzel.zzeU().zzb(this.mContext, zzeg2, this.zzts, this.zzAj);
        if (this.zzyS != null) {
            this.zzAo.zza(new zzdz(this.zzyS));
        }
        if (this.zzyR != null) {
            this.zzAo.zza(new zzdy(this.zzyR));
        }
        if (this.zzzE != null) {
            this.zzAo.zza(new zzei(this.zzzE));
        }
        if (this.zzAp != null) {
            this.zzAo.zza(new zzlj(this.zzAp));
        }
        if (this.zzAr != null) {
            this.zzAo.zza(new zzln(this.zzAr), this.zzAs);
        }
        if (this.zzAq != null) {
            this.zzAo.zza(new zzgq(this.zzAq));
        }
        if (this.zzAn != null) {
            this.zzAo.zza(this.zzAn.zzbq());
        }
        if (this.zzcJ != null) {
            this.zzAo.zza(new zznz(this.zzcJ));
        }
    }

    private void zzT(String string) {
        if (this.zzAo == null) {
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length()).append("The ad unit ID must be set on InterstitialAd before ").append(string).append(" is called.").toString());
        }
    }
}

