/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.formats.AdChoicesView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzqf;

public abstract class NativeAdView
extends FrameLayout {
    private final FrameLayout zzrY;
    private final zzhh zzrZ;

    public NativeAdView(Context context) {
        super(context);
        this.zzrY = this.zzd(context);
        this.zzrZ = this.zzbv();
    }

    public NativeAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzrY = this.zzd(context);
        this.zzrZ = this.zzbv();
    }

    public NativeAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzrY = this.zzd(context);
        this.zzrZ = this.zzbv();
    }

    @TargetApi(value=21)
    public NativeAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.zzrY = this.zzd(context);
        this.zzrZ = this.zzbv();
    }

    public void setAdChoicesView(AdChoicesView adChoicesView) {
        this.zza("1098", (View)adChoicesView);
    }

    public AdChoicesView getAdChoicesView() {
        View view = this.zzt("1098");
        if (view instanceof AdChoicesView) {
            return (AdChoicesView)view;
        }
        return null;
    }

    protected void zza(String string, View view) {
        try {
            this.zzrZ.zzd(string, zzd.zzA((Object)view));
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Unable to call setAssetView on delegate", remoteException);
        }
    }

    protected View zzt(String string) {
        try {
            IObjectWrapper iObjectWrapper = this.zzrZ.zzU(string);
            if (iObjectWrapper != null) {
                return (View)zzd.zzF((IObjectWrapper)iObjectWrapper);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Unable to call getAssetView on delegate", remoteException);
        }
        return null;
    }

    public void setNativeAd(NativeAd nativeAd) {
        try {
            this.zzrZ.zze((IObjectWrapper)nativeAd.zzbu());
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Unable to call setNativeAd on delegate", remoteException);
        }
    }

    public void destroy() {
        try {
            this.zzrZ.destroy();
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Unable to destroy native ad view", remoteException);
        }
    }

    private FrameLayout zzd(Context context) {
        FrameLayout frameLayout = this.zze(context);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    FrameLayout zze(Context context) {
        return new FrameLayout(context);
    }

    private zzhh zzbv() {
        zzac.zzb((Object)this.zzrY, (Object)"createDelegate must be called after mOverlayFrame has been created");
        return zzel.zzeU().zza(this.zzrY.getContext(), this, this.zzrY);
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zzrY);
    }

    public void removeView(View view) {
        if (this.zzrY == view) {
            return;
        }
        super.removeView(view);
    }

    public void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zzrY);
    }

    public void bringChildToFront(View view) {
        super.bringChildToFront(view);
        if (this.zzrY != view) {
            super.bringChildToFront((View)this.zzrY);
        }
    }

    public void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (this.zzrZ != null) {
            try {
                this.zzrZ.zzb(zzd.zzA((Object)view), n);
            }
            catch (RemoteException remoteException) {
                zzqf.zzb("Unable to call onVisibilityChanged on delegate", remoteException);
            }
        }
    }
}

