/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzme;

@zzme
public class zzeg
extends zza {
    public static final Parcelable.Creator<zzeg> CREATOR = new zzeh();
    public final String zzzy;
    public final int height;
    public final int heightPixels;
    public final boolean zzzz;
    public final int width;
    public final int widthPixels;
    public final zzeg[] zzzA;
    public final boolean zzzB;
    public final boolean zzzC;
    public boolean zzzD;

    public static int zza(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzb(DisplayMetrics displayMetrics) {
        return (int)((float)zzeg.zzc(displayMetrics) * displayMetrics.density);
    }

    private static int zzc(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static zzeg zzk(Context context) {
        return new zzeg("320x50_mb", 0, 0, false, 0, 0, null, true, false, false);
    }

    public static zzeg zzeE() {
        return new zzeg("reward_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public zzeg() {
        this("interstitial_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public zzeg(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    public zzeg(Context context, AdSize[] adSizeArray) {
        int n;
        AdSize adSize = adSizeArray[0];
        this.zzzz = false;
        this.zzzC = adSize.isFluid();
        if (this.zzzC) {
            this.width = AdSize.BANNER.getWidth();
            this.height = AdSize.BANNER.getHeight();
        } else {
            this.width = adSize.getWidth();
            this.height = adSize.getHeight();
        }
        boolean bl = this.width == -1;
        boolean bl2 = this.height == -2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (bl) {
            this.widthPixels = zzel.zzeT().zzah(context) && zzel.zzeT().zzai(context) ? zzeg.zza(displayMetrics) - zzel.zzeT().zzaj(context) : zzeg.zza(displayMetrics);
            double d = (float)this.widthPixels / displayMetrics.density;
            n = (int)d;
            if (d - (double)((int)d) >= 0.01) {
                ++n;
            }
        } else {
            n = this.width;
            this.widthPixels = zzel.zzeT().zza(displayMetrics, this.width);
        }
        int n2 = bl2 ? zzeg.zzc(displayMetrics) : this.height;
        this.heightPixels = zzel.zzeT().zza(displayMetrics, n2);
        if (bl || bl2) {
            int n3 = n;
            this.zzzy = new StringBuilder(26).append(n3).append("x").append(n2).append("_as").toString();
        } else {
            this.zzzy = this.zzzC ? "320x50_mb" : adSize.toString();
        }
        if (adSizeArray.length > 1) {
            this.zzzA = new zzeg[adSizeArray.length];
            for (int i = 0; i < adSizeArray.length; ++i) {
                this.zzzA[i] = new zzeg(context, adSizeArray[i]);
            }
        } else {
            this.zzzA = null;
        }
        this.zzzB = false;
        this.zzzD = false;
    }

    public zzeg(zzeg zzeg2, zzeg[] zzegArray) {
        this(zzeg2.zzzy, zzeg2.height, zzeg2.heightPixels, zzeg2.zzzz, zzeg2.width, zzeg2.widthPixels, zzegArray, zzeg2.zzzB, zzeg2.zzzC, zzeg2.zzzD);
    }

    zzeg(String string, int n, int n2, boolean bl, int n3, int n4, zzeg[] zzegArray, boolean bl2, boolean bl3, boolean bl4) {
        this.zzzy = string;
        this.height = n;
        this.heightPixels = n2;
        this.zzzz = bl;
        this.width = n3;
        this.widthPixels = n4;
        this.zzzA = zzegArray;
        this.zzzB = bl2;
        this.zzzC = bl3;
        this.zzzD = bl4;
    }

    public AdSize zzeF() {
        return com.google.android.gms.ads.zza.zza(this.width, this.height, this.zzzy);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzeh.zza(this, parcel, n);
    }

    public void zzk(boolean bl) {
        this.zzzD = bl;
    }
}

