/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzdx;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzei;
import com.google.android.gms.internal.zzej;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzen;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzlj;
import com.google.android.gms.internal.zzln;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzqf;
import java.util.concurrent.atomic.AtomicBoolean;

@zzme
public class zzff {
    private final zzjz zzAj = new zzjz();
    private final zzef zzrw;
    private final AtomicBoolean zzAk;
    private final VideoController zzAl = new VideoController();
    final zzen zzAm = new zzen(){

        @Override
        public void onAdLoaded() {
            zzff.this.zzAl.zza(zzff.this.zzbs());
            super.onAdLoaded();
        }

        @Override
        public void onAdFailedToLoad(int n) {
            zzff.this.zzAl.zza(zzff.this.zzbs());
            super.onAdFailedToLoad(n);
        }
    };
    private zzdx zzyR;
    private AdListener zzyS;
    private AdSize[] zzzF;
    private AppEventListener zzzE;
    private Correlator zzAn;
    private zzet zzAo;
    private InAppPurchaseListener zzAp;
    private OnCustomRenderedAdLoadedListener zzAq;
    private PlayStorePurchaseListener zzAr;
    private VideoOptions zzrX;
    private String zzts;
    private String zzAs;
    private ViewGroup zzAt;
    private int zzAu;
    private boolean zzsS;

    public zzff(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzef.zzeD(), 0);
    }

    public zzff(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzef.zzeD(), n);
    }

    public zzff(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzef.zzeD(), 0);
    }

    public zzff(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, bl, zzef.zzeD(), n);
    }

    zzff(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzef zzef2, zzet zzet2, int n) {
        this.zzAt = viewGroup;
        this.zzrw = zzef2;
        this.zzAo = zzet2;
        this.zzAk = new AtomicBoolean(false);
        this.zzAu = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzej zzej2 = new zzej(context, attributeSet);
                this.zzzF = zzej2.zzl(bl);
                this.zzts = zzej2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzel.zzeT().zza(viewGroup, new zzeg(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzel.zzeT().zza(viewGroup, zzff.zza(context, this.zzzF[0], this.zzAu), "Ads by Google");
            }
        }
    }

    zzff(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzef zzef2, int n) {
        this(viewGroup, attributeSet, bl, zzef2, null, n);
    }

    public void destroy() {
        try {
            if (this.zzAo != null) {
                this.zzAo.destroy();
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to destroy AdView.", remoteException);
        }
    }

    public AdListener getAdListener() {
        return this.zzyS;
    }

    public AdSize getAdSize() {
        try {
            zzeg zzeg2;
            if (this.zzAo != null && (zzeg2 = this.zzAo.zzbC()) != null) {
                return zzeg2.zzeF();
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to get the current AdSize.", remoteException);
        }
        return this.zzzF != null ? this.zzzF[0] : null;
    }

    public AdSize[] getAdSizes() {
        return this.zzzF;
    }

    public String getAdUnitId() {
        return this.zzts;
    }

    public AppEventListener getAppEventListener() {
        return this.zzzE;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzAp;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzAq;
    }

    public void zza(zzfe zzfe2) {
        try {
            if (this.zzAo == null) {
                this.zzfi();
            }
            if (this.zzAo.zzb(this.zzrw.zza(this.zzAt.getContext(), zzfe2))) {
                this.zzAj.zzi(zzfe2.zzfd());
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to load ad.", remoteException);
        }
    }

    public void pause() {
        try {
            if (this.zzAo != null) {
                this.zzAo.pause();
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to call pause.", remoteException);
        }
    }

    public void recordManualImpression() {
        if (this.zzAk.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzAo != null) {
                this.zzAo.zzbE();
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to record impression.", remoteException);
        }
    }

    public void resume() {
        try {
            if (this.zzAo != null) {
                this.zzAo.resume();
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to call resume.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        this.zzyS = adListener;
        this.zzAm.zza(adListener);
    }

    public void zza(zzdx zzdx2) {
        try {
            this.zzyR = zzdx2;
            if (this.zzAo != null) {
                this.zzAo.zza(zzdx2 != null ? new zzdy(zzdx2) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzzF != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public void zza(AdSize ... adSizeArray) {
        this.zzzF = adSizeArray;
        try {
            if (this.zzAo != null) {
                this.zzAo.zza(zzff.zza(this.zzAt.getContext(), this.zzzF, this.zzAu));
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the ad size.", remoteException);
        }
        this.zzAt.requestLayout();
    }

    public void setAdUnitId(String string) {
        if (this.zzts != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzts = string;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzzE = appEventListener;
            if (this.zzAo != null) {
                this.zzAo.zza(appEventListener != null ? new zzei(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzAr != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzAp = inAppPurchaseListener;
            if (this.zzAo != null) {
                this.zzAo.zza(inAppPurchaseListener != null ? new zzlj(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzAq = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzAo != null) {
                this.zzAo.zza(onCustomRenderedAdLoadedListener != null ? new zzgq(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String string) {
        if (this.zzAp != null) {
            throw new IllegalStateException("InAppPurchaseListener has already been set.");
        }
        try {
            this.zzAr = playStorePurchaseListener;
            this.zzAs = string;
            if (this.zzAo != null) {
                this.zzAo.zza(playStorePurchaseListener != null ? new zzln(playStorePurchaseListener) : null, string);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setManualImpressionsEnabled(boolean bl) {
        this.zzsS = bl;
        try {
            if (this.zzAo != null) {
                this.zzAo.setManualImpressionsEnabled(this.zzsS);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set manual impressions.", remoteException);
        }
    }

    public void setCorrelator(Correlator correlator) {
        this.zzAn = correlator;
        try {
            if (this.zzAo != null) {
                this.zzAo.zza(this.zzAn == null ? null : this.zzAn.zzbq());
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set correlator.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzAo != null) {
                return this.zzAo.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public boolean isLoading() {
        try {
            if (this.zzAo != null) {
                return this.zzAo.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    public VideoController getVideoController() {
        return this.zzAl;
    }

    public zzfa zzbs() {
        if (this.zzAo == null) {
            return null;
        }
        try {
            return this.zzAo.zzbF();
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to retrieve VideoController.", remoteException);
            return null;
        }
    }

    public void setVideoOptions(VideoOptions videoOptions) {
        this.zzrX = videoOptions;
        try {
            if (this.zzAo != null) {
                this.zzAo.zza(videoOptions == null ? null : new zzft(videoOptions));
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to set video options.", remoteException);
        }
    }

    public VideoOptions getVideoOptions() {
        return this.zzrX;
    }

    private void zzfh() {
        try {
            IObjectWrapper iObjectWrapper = this.zzAo.zzbB();
            if (iObjectWrapper == null) {
                return;
            }
            this.zzAt.addView((View)zzd.zzF((IObjectWrapper)iObjectWrapper));
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to get an ad frame.", remoteException);
        }
    }

    void zzfi() throws RemoteException {
        if ((this.zzzF == null || this.zzts == null) && this.zzAo == null) {
            throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
        }
        this.zzAo = this.zzfj();
        this.zzAo.zza(new zzdz(this.zzAm));
        if (this.zzyR != null) {
            this.zzAo.zza(new zzdy(this.zzyR));
        }
        if (this.zzzE != null) {
            this.zzAo.zza(new zzei(this.zzzE));
        }
        if (this.zzAp != null) {
            this.zzAo.zza(new zzlj(this.zzAp));
        }
        if (this.zzAr != null) {
            this.zzAo.zza(new zzln(this.zzAr), this.zzAs);
        }
        if (this.zzAq != null) {
            this.zzAo.zza(new zzgq(this.zzAq));
        }
        if (this.zzAn != null) {
            this.zzAo.zza(this.zzAn.zzbq());
        }
        if (this.zzrX != null) {
            this.zzAo.zza(new zzft(this.zzrX));
        }
        this.zzAo.setManualImpressionsEnabled(this.zzsS);
        this.zzfh();
    }

    protected zzet zzfj() throws RemoteException {
        Context context = this.zzAt.getContext();
        zzeg zzeg2 = zzff.zza(context, this.zzzF, this.zzAu);
        if (this.zzb(zzeg2)) {
            return zzel.zzeU().zza(context, zzeg2, this.zzts);
        }
        return zzel.zzeU().zza(context, zzeg2, this.zzts, this.zzAj);
    }

    private static zzeg zza(Context context, AdSize[] adSizeArray, int n) {
        zzeg zzeg2 = new zzeg(context, adSizeArray);
        zzeg2.zzk(zzff.zzz(n));
        return zzeg2;
    }

    private static zzeg zza(Context context, AdSize adSize, int n) {
        zzeg zzeg2 = new zzeg(context, adSize);
        zzeg2.zzk(zzff.zzz(n));
        return zzeg2;
    }

    public boolean zzb(zzeg zzeg2) {
        return "search_v2".equals(zzeg2.zzzy);
    }

    private static boolean zzz(int n) {
        return n == 1;
    }
}

