/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzjx;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zzot;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzuz;

public class AdLoader {
    private final zzja zzakp;
    private final Context mContext;
    private final zzjx zzakq;

    AdLoader(Context context, zzjx zzjx2) {
        this(context, zzjx2, zzja.zzbcp);
    }

    private AdLoader(Context context, zzjx zzjx2, zzja zzja2) {
        this.mContext = context;
        this.zzakq = zzjx2;
        this.zzakp = zzja2;
    }

    private final void zza(zzlg zzlg2) {
        try {
            this.zzakq.zzd(zzja.zza(this.mContext, zzlg2));
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzb("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzaz());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzlg zzlg2 = adRequest.zzaz();
        AdLoader adLoader = this;
        try {
            adLoader.zzakq.zza(zzja.zza(adLoader.mContext, zzlg2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzb("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzaz());
    }

    public String getMediationAdapterClassName() {
        try {
            return this.zzakq.zzch();
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzakq.isLoading();
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzka zzakr;

        public Builder(Context context, String string) {
            this((Context)zzbp.zzb((Object)context, (Object)"context cannot be null"), zzjo.zzhv().zzb(context, string, new zzuz()));
        }

        private Builder(Context context, zzka zzka2) {
            this.mContext = context;
            this.zzakr = zzka2;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzakr.zza(new zzqo(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzaji.zzc("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzakr.zza(new zzqn(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzaji.zzc("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzakr.zza(string, new zzqq(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzqp(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzaji.zzc("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zzjb zzjb2 = new zzjb(this.mContext, adSizeArray);
                this.zzakr.zza(new zzqr(onPublisherAdViewLoadedListener), zzjb2);
            }
            catch (RemoteException remoteException) {
                zzaji.zzc("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzakr.zzb(new zziu(adListener));
            }
            catch (RemoteException remoteException) {
                zzaji.zzc("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzakr.zza(new zzot(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzaji.zzc("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzakr.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzaji.zzc("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            zzbp.zzu((Object)correlator);
            try {
                this.zzakr.zzb(correlator.zzba());
            }
            catch (RemoteException remoteException) {
                zzaji.zzc("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zzakr.zzcy());
            }
            catch (RemoteException remoteException) {
                zzaji.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

