/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zzit;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjd;
import com.google.android.gms.internal.zzje;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzjg;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzjq;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zzlj;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zznq;
import com.google.android.gms.internal.zzuz;
import com.google.android.gms.internal.zzzt;
import java.util.concurrent.atomic.AtomicBoolean;

@zzzt
public final class zzli {
    private final zzuz zzbdz = new zzuz();
    private final zzja zzakp;
    private final AtomicBoolean zzbea;
    private final VideoController zzbeb = new VideoController();
    private zzjq zzbec = new zzlj(this);
    private zzis zzbbj;
    private AdListener zzbbk;
    private AdSize[] zzbcw;
    private AppEventListener zzalv;
    private Correlator zzbed;
    private zzkf zzbee;
    private OnCustomRenderedAdLoadedListener zzbef;
    private VideoOptions zzalq;
    private String zzapb;
    private ViewGroup zzbeg;
    private int zzbeh;
    private boolean zzalt;

    public zzli(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzja.zzbcp, 0);
    }

    public zzli(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzja.zzbcp, n);
    }

    public zzli(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzja.zzbcp, 0);
    }

    public zzli(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zzja.zzbcp, n);
    }

    private zzli(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzja zzja2, zzkf zzkf2, int n) {
        this.zzbeg = viewGroup;
        this.zzakp = zzja2;
        this.zzbee = null;
        this.zzbea = new AtomicBoolean(false);
        this.zzbeh = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzje zzje2 = new zzje(context, attributeSet);
                this.zzbcw = zzje2.zzh(bl);
                this.zzapb = zzje2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzjo.zzhu().zza(viewGroup, new zzjb(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                boolean bl2;
                int n2 = this.zzbeh;
                AdSize adSize = this.zzbcw[0];
                Context context2 = context;
                zzjb zzjb2 = new zzjb(context2, adSize);
                new zzjb(context2, adSize).zzbcv = bl2 = zzli.zzq(n2);
                zzjo.zzhu().zza(viewGroup, zzjb2, "Ads by Google");
            }
        }
    }

    private zzli(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzja zzja2, int n) {
        this(viewGroup, attributeSet, bl, zzja2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzbee != null) {
                this.zzbee.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to destroy AdView.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzbbk;
    }

    public final AdSize getAdSize() {
        try {
            zzjb zzjb2;
            if (this.zzbee != null && (zzjb2 = this.zzbee.zzbl()) != null) {
                return zzjb2.zzhn();
            }
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to get the current AdSize.", remoteException);
        }
        if (this.zzbcw != null) {
            return this.zzbcw[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzbcw;
    }

    public final String getAdUnitId() {
        if (this.zzapb == null && this.zzbee != null) {
            try {
                this.zzapb = this.zzbee.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzaji.zzc("Failed to get ad unit id.", remoteException);
            }
        }
        return this.zzapb;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzalv;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzbef;
    }

    public final void zza(zzlg zzlg2) {
        try {
            if (this.zzbee == null) {
                zzkf zzkf2;
                zzjb zzjb2;
                zzli zzli2 = this;
                if ((zzli2.zzbcw == null || zzli2.zzapb == null) && zzli2.zzbee == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzli zzli3 = zzli2;
                Context context = zzli3.zzbeg.getContext();
                Object object = zzjb2 = zzli.zza(context, zzli3.zzbcw, zzli3.zzbeh);
                if ("search_v2".equals(object.zzbcq)) {
                    String string = zzli3.zzapb;
                    zzjb zzjb3 = zzjb2;
                    Context context2 = context;
                    object = zzjo.zzhv();
                    zzkf2 = zzjf.zza(context2, false, new zzjh((zzjf)object, context2, zzjb3, string));
                } else {
                    zzuz zzuz2 = zzli3.zzbdz;
                    String string = zzli3.zzapb;
                    zzjb zzjb4 = zzjb2;
                    Context context3 = context;
                    object = zzjo.zzhv();
                    zzkf2 = zzjf.zza(context3, false, new zzjg((zzjf)object, context3, zzjb4, string, zzuz2));
                }
                zzli2.zzbee = zzkf2;
                zzli2.zzbee.zza(new zziu(zzli2.zzbec));
                if (zzli2.zzbbj != null) {
                    zzli2.zzbee.zza(new zzit(zzli2.zzbbj));
                }
                if (zzli2.zzalv != null) {
                    zzli2.zzbee.zza(new zzjd(zzli2.zzalv));
                }
                if (zzli2.zzbef != null) {
                    zzli2.zzbee.zza(new zznq(zzli2.zzbef));
                }
                if (zzli2.zzbed != null) {
                    zzli2.zzbee.zza(zzli2.zzbed.zzba());
                }
                if (zzli2.zzalq != null) {
                    zzli2.zzbee.zza(new zzmd(zzli2.zzalq));
                }
                zzli2.zzbee.setManualImpressionsEnabled(zzli2.zzalt);
                zzli zzli4 = zzli2;
                try {
                    IObjectWrapper iObjectWrapper = zzli4.zzbee.zzbk();
                    if (iObjectWrapper != null) {
                        zzli4.zzbeg.addView((View)zzn.zzab((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzaji.zzc("Failed to get an ad frame.", remoteException);
                }
            }
            if (this.zzbee.zzb(zzja.zza(this.zzbeg.getContext(), zzlg2))) {
                this.zzbdz.zzh(zzlg2.zzib());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzbee != null) {
                this.zzbee.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to call pause.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzbea.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzbee != null) {
                this.zzbee.zzbn();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to record impression.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzbee != null) {
                this.zzbee.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to call resume.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzbbk = adListener;
        this.zzbec.zza(adListener);
    }

    public final void zza(zzis zzis2) {
        try {
            this.zzbbj = zzis2;
            if (this.zzbee != null) {
                this.zzbee.zza(zzis2 != null ? new zzit(zzis2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzbcw != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzbcw = adSizeArray;
        try {
            if (this.zzbee != null) {
                this.zzbee.zza(zzli.zza(this.zzbeg.getContext(), this.zzbcw, this.zzbeh));
            }
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set the ad size.", remoteException);
        }
        this.zzbeg.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zzapb != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzapb = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzalv = appEventListener;
            if (this.zzbee != null) {
                this.zzbee.zza(appEventListener != null ? new zzjd(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzbef = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzbee != null) {
                this.zzbee.zza(onCustomRenderedAdLoadedListener != null ? new zznq(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzalt = bl;
        try {
            if (this.zzbee != null) {
                this.zzbee.setManualImpressionsEnabled(this.zzalt);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set manual impressions.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzbed = correlator;
        try {
            if (this.zzbee != null) {
                this.zzbee.zza(this.zzbed == null ? null : this.zzbed.zzba());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbee != null) {
                return this.zzbee.zzch();
            }
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzbee != null) {
                return this.zzbee.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzbeb;
    }

    public final zzky zzbc() {
        if (this.zzbee == null) {
            return null;
        }
        try {
            return this.zzbee.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to retrieve VideoController.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzalq = videoOptions;
        try {
            if (this.zzbee != null) {
                this.zzbee.zza(videoOptions == null ? null : new zzmd(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set video options.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzalq;
    }

    public final boolean zza(zzkf zzkf2) {
        IObjectWrapper iObjectWrapper;
        if (zzkf2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzkf2.zzbk();
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to get an ad frame.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)zzn.zzab((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzbeg.addView((View)zzn.zzab((IObjectWrapper)iObjectWrapper));
        this.zzbee = zzkf2;
        return true;
    }

    private static zzjb zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        zzjb zzjb2 = new zzjb(context, adSizeArray);
        new zzjb(context, adSizeArray).zzbcv = bl = zzli.zzq(n);
        return zzjb2;
    }

    private static boolean zzq(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzli zzli2) {
        return zzli2.zzbeb;
    }
}

