/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzzv;

@zzzv
public final class VideoController {
    @KeepForSdk
    public static final int PLAYBACK_STATE_UNKNOWN = 0;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PLAYING = 1;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PAUSED = 2;
    @KeepForSdk
    public static final int PLAYBACK_STATE_ENDED = 3;
    @KeepForSdk
    public static final int PLAYBACK_STATE_READY = 5;
    private final Object mLock = new Object();
    @Nullable
    private zzll zzamc;
    @Nullable
    private VideoLifecycleCallbacks zzamd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzll zzll2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzamc = zzll2;
            if (this.zzamd != null) {
                this.setVideoLifecycleCallbacks(this.zzamd);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzll zzbj() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzamc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void play() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzamc == null) {
                return;
            }
            try {
                this.zzamc.play();
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call play on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzamc == null) {
                return;
            }
            try {
                this.zzamc.pause();
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call pause on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void mute(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzamc == null) {
                return;
            }
            try {
                this.zzamc.mute(bl);
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call mute on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final boolean isMuted() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzamc == null) {
                return true;
            }
            try {
                return this.zzamc.isMuted();
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call isMuted on video controller.", remoteException);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final int getPlaybackState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzamc == null) {
                return 0;
            }
            try {
                return this.zzamc.getPlaybackState();
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call getPlaybackState on video controller.", remoteException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final boolean isCustomControlsEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzamc == null) {
                return false;
            }
            try {
                return this.zzamc.isCustomControlsEnabled();
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call isUsingCustomPlayerControls.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final boolean isClickToExpandEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzamc == null) {
                return false;
            }
            try {
                return this.zzamc.isClickToExpandEnabled();
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call isClickToExpandEnabled.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVideoLifecycleCallbacks(VideoLifecycleCallbacks videoLifecycleCallbacks) {
        zzbq.checkNotNull((Object)videoLifecycleCallbacks, (Object)"VideoLifecycleCallbacks may not be null.");
        Object object = this.mLock;
        synchronized (object) {
            this.zzamd = videoLifecycleCallbacks;
            if (this.zzamc == null) {
                return;
            }
            try {
                this.zzamc.zza(new zzmq(videoLifecycleCallbacks));
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call setVideoLifecycleCallbacks on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VideoLifecycleCallbacks getVideoLifecycleCallbacks() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzamd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasVideoContent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzamc != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getAspectRatio() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzamc == null) {
                return 0.0f;
            }
            try {
                return this.zzamc.getAspectRatio();
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call getAspectRatio on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    public static abstract class VideoLifecycleCallbacks {
        public VideoLifecycleCallbacks() {
        }

        public void onVideoStart() {
        }

        public void onVideoPlay() {
        }

        public void onVideoPause() {
        }

        public void onVideoEnd() {
        }

        public void onVideoMute(boolean bl) {
        }
    }
}

