/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.doubleclick.zza;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzlu;
import java.util.Date;
import java.util.List;
import java.util.Set;

public final class PublisherAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzlt zzals;

    private PublisherAdRequest(Builder builder) {
        this.zzals = new zzlt(builder.zzalt);
    }

    public final Date getBirthday() {
        return this.zzals.getBirthday();
    }

    public final String getContentUrl() {
        return this.zzals.getContentUrl();
    }

    public final int getGender() {
        return this.zzals.getGender();
    }

    public final Set<String> getKeywords() {
        return this.zzals.getKeywords();
    }

    public final Location getLocation() {
        return this.zzals.getLocation();
    }

    public final boolean getManualImpressionsEnabled() {
        return this.zzals.getManualImpressionsEnabled();
    }

    @Deprecated
    public final <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzals.getNetworkExtras(clazz);
    }

    public final <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzals.getNetworkExtrasBundle(clazz);
    }

    public final <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzals.getCustomEventExtrasBundle(clazz);
    }

    public final String getPublisherProvidedId() {
        return this.zzals.getPublisherProvidedId();
    }

    public final boolean isTestDevice(Context context) {
        return this.zzals.isTestDevice(context);
    }

    public final Bundle getCustomTargeting() {
        return this.zzals.getCustomTargeting();
    }

    public static void updateCorrelator() {
    }

    public final zzlt zzbg() {
        return this.zzals;
    }

    /* synthetic */ PublisherAdRequest(Builder builder, zza zza2) {
        this(builder);
    }

    public static final class Builder {
        private final zzlu zzalt = new zzlu();

        public Builder() {
        }

        public final Builder addKeyword(String string) {
            this.zzalt.zzad(string);
            return this;
        }

        public final Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzalt.zza(networkExtras);
            return this;
        }

        public final Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzalt.zza(clazz, bundle);
            return this;
        }

        public final Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzalt.zzb(clazz, bundle);
            return this;
        }

        public final Builder addTestDevice(String string) {
            this.zzalt.zzae(string);
            return this;
        }

        public final PublisherAdRequest build() {
            return new PublisherAdRequest(this, null);
        }

        public final Builder setBirthday(Date date) {
            this.zzalt.zza(date);
            return this;
        }

        public final Builder setContentUrl(String string) {
            zzbq.checkNotNull((Object)string, (Object)"Content URL must be non-null.");
            zzbq.zzh((String)string, (Object)"Content URL must be non-empty.");
            zzbq.zzb((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzalt.zzag(string);
            return this;
        }

        public final Builder setGender(int n) {
            this.zzalt.zzr(n);
            return this;
        }

        public final Builder setLocation(Location location) {
            this.zzalt.zzb(location);
            return this;
        }

        @Deprecated
        public final Builder setManualImpressionsEnabled(boolean bl) {
            this.zzalt.setManualImpressionsEnabled(bl);
            return this;
        }

        public final Builder setPublisherProvidedId(String string) {
            this.zzalt.zzah(string);
            return this;
        }

        public final Builder setRequestAgent(String string) {
            this.zzalt.zzai(string);
            return this;
        }

        public final Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzalt.zzi(bl);
            return this;
        }

        public final Builder addCustomTargeting(String string, String string2) {
            this.zzalt.zzd(string, string2);
            return this;
        }

        public final Builder addCustomTargeting(String string, List<String> list) {
            if (list != null) {
                this.zzalt.zzd(string, TextUtils.join((CharSequence)",", list));
            }
            return this;
        }

        public final Builder addCategoryExclusion(String string) {
            this.zzalt.zzaj(string);
            return this;
        }

        public final Builder setIsDesignedForFamilies(boolean bl) {
            this.zzalt.zzj(bl);
            return this;
        }
    }
}

