/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.GuardedBy;
import android.support.annotation.Nullable;
import android.util.JsonWriter;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzajr;
import com.google.android.gms.internal.zzajw;
import com.google.android.gms.internal.zzajx;
import com.google.android.gms.internal.zzajy;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzzv;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@zzzv
public final class zzajv {
    private static Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static boolean zzddx = false;
    @GuardedBy(value="sLock")
    private static boolean zzddy = false;
    private static zzd zzddz = zzh.zzamg();
    private static final Set<String> zzdea = new HashSet<String>(Arrays.asList(new String[0]));
    private final List<String> zzdeb;

    public zzajv() {
        this(null);
    }

    public zzajv(@Nullable String string) {
        List<String> list;
        String string2 = string;
        if (!zzajv.isEnabled()) {
            list = new ArrayList<String>();
        } else {
            String string3 = UUID.randomUUID().toString();
            if (string2 == null) {
                String[] stringArray = new String[1];
                String string4 = String.valueOf(string3);
                stringArray[0] = string4.length() != 0 ? "network_request_".concat(string4) : new String("network_request_");
                list = Arrays.asList(stringArray);
            } else {
                String[] stringArray = new String[2];
                String string5 = String.valueOf(string2);
                stringArray[0] = string5.length() != 0 ? "ad_request_".concat(string5) : new String("ad_request_");
                String string6 = String.valueOf(string3);
                stringArray[1] = string6.length() != 0 ? "network_request_".concat(string6) : new String("network_request_");
                list = Arrays.asList(stringArray);
            }
        }
        this.zzdeb = list;
    }

    public final void zza(HttpURLConnection httpURLConnection, @Nullable byte[] byArray) {
        if (!zzajv.isEnabled()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getRequestProperties() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getRequestProperties());
        String string = new String(httpURLConnection.getURL().toString());
        String string2 = new String(httpURLConnection.getRequestMethod());
        this.zzb(string, string2, hashMap, byArray);
    }

    public final void zza(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        if (!zzajv.isEnabled()) {
            return;
        }
        this.zzb(string, string2, map, byArray);
    }

    private final void zzb(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        this.zza("onNetworkRequest", new zzajw(string, string2, map, byArray));
    }

    public final void zza(HttpURLConnection httpURLConnection, int n) {
        if (!zzajv.isEnabled()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getHeaderFields() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getHeaderFields());
        this.zzb(hashMap, n);
        if (n < 200 || n >= 300) {
            String string = null;
            try {
                string = httpURLConnection.getResponseMessage();
            }
            catch (IOException iOException) {
                String string2 = String.valueOf(iOException.getMessage());
                zzakb.zzcu(string2.length() != 0 ? "Can not get error message from error HttpURLConnection\n".concat(string2) : new String("Can not get error message from error HttpURLConnection\n"));
            }
            this.zzcs(string);
        }
    }

    public final void zza(@Nullable Map<String, ?> map, int n) {
        if (!zzajv.isEnabled()) {
            return;
        }
        this.zzb(map, n);
        if (n < 200 || n >= 300) {
            this.zzcs(null);
        }
    }

    private final void zzb(@Nullable Map<String, ?> map, int n) {
        this.zza("onNetworkResponse", new zzajx(n, map));
    }

    public final void zzcr(@Nullable String string) {
        if (!zzajv.isEnabled()) {
            return;
        }
        if (string == null) {
            return;
        }
        byte[] byArray = string.getBytes();
        this.zzf(byArray);
    }

    public final void zzf(byte[] byArray) {
        this.zza("onNetworkResponseBody", new zzajy(byArray));
    }

    private final void zzcs(@Nullable String string) {
        this.zza("onNetworkRequestError", new zzajz(string));
    }

    private static void zza(JsonWriter jsonWriter, @Nullable Map<String, ?> map) throws IOException {
        if (map == null) {
            return;
        }
        jsonWriter.name("headers").beginArray();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String string = entry.getKey();
            if (zzdea.contains(string)) continue;
            if (entry.getValue() instanceof List) {
                for (String string2 : (List)entry.getValue()) {
                    jsonWriter.beginObject();
                    jsonWriter.name("name").value(string);
                    jsonWriter.name("value").value(string2);
                    jsonWriter.endObject();
                }
                continue;
            }
            if (entry.getValue() instanceof String) {
                jsonWriter.beginObject();
                jsonWriter.name("name").value(string);
                jsonWriter.name("value").value((String)entry.getValue());
                jsonWriter.endObject();
                continue;
            }
            zzakb.e("Connection headers should be either Map<String, String> or Map<String, List<String>>");
            break;
        }
        jsonWriter.endArray();
    }

    private final void zza(String string, zzaka zzaka2) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            jsonWriter.beginObject();
            jsonWriter.name("timestamp").value(zzddz.currentTimeMillis());
            jsonWriter.name("event").value(string);
            jsonWriter.name("components").beginArray();
            for (String string2 : this.zzdeb) {
                jsonWriter.value(string2);
            }
            jsonWriter.endArray();
            zzaka2.zza(jsonWriter);
            jsonWriter.endObject();
            jsonWriter.flush();
            jsonWriter.close();
        }
        catch (IOException iOException) {
            zzakb.zzb("unable to log", iOException);
        }
        zzajv.log(stringWriter.toString());
    }

    private static synchronized void log(String string) {
        zzakb.zzct("GMA Debug BEGIN");
        for (int i = 0; i < string.length(); i += 4000) {
            int n = Math.min(i + 4000, string.length());
            String string2 = String.valueOf(string.substring(i, n));
            zzakb.zzct(string2.length() != 0 ? "GMA Debug CONTENT ".concat(string2) : new String("GMA Debug CONTENT "));
        }
        zzakb.zzct("GMA Debug FINISH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzrb() {
        Object object = sLock;
        synchronized (object) {
            zzddx = false;
            zzddy = false;
            zzakb.zzcu("Ad debug logging enablement is out of date.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzaa(boolean bl) {
        Object object = sLock;
        synchronized (object) {
            zzddx = true;
            zzddy = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzrc() {
        Object object = sLock;
        synchronized (object) {
            return zzddx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled() {
        Object object = sLock;
        synchronized (object) {
            return zzddx && zzddy;
        }
    }

    public static boolean zzbj(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        zzmx<Boolean> zzmx2 = zznh.zzbmi;
        return zzkb.zzif().zzd(zzmx2) != false && Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"development_settings_enabled", (int)0) != 0;
    }

    static final /* synthetic */ void zza(String string, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        if (string != null) {
            jsonWriter.name("error_description").value(string);
        }
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        int n = byArray.length;
        String string = zzb.zzk((byte[])byArray);
        if (n < 10000) {
            jsonWriter.name("body").value(string);
        } else {
            String string2 = zzajr.zzcp(string);
            if (string2 != null) {
                jsonWriter.name("bodydigest").value(string2);
            }
        }
        jsonWriter.name("bodylength").value((long)n);
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(int n, Map map, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("code").value((long)n);
        jsonWriter.endObject();
        zzajv.zza(jsonWriter, map);
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(String string, String string2, Map map, byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("uri").value(string);
        jsonWriter.name("verb").value(string2);
        jsonWriter.endObject();
        zzajv.zza(jsonWriter, map);
        if (byArray != null) {
            jsonWriter.name("body").value(zzb.zzk((byte[])byArray));
        }
        jsonWriter.endObject();
    }
}

