/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAdViewHolder;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzaqk;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzmm;
import java.util.Date;
import java.util.Map;
import java.util.Set;

@zzabh
@Hide
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
com.google.android.gms.ads.mediation.zzb,
MediationRewardedVideoAdAdapter,
zzaqk {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zzgs;
    private InterstitialAd zzgt;
    private AdLoader zzgu;
    private Context zzgv;
    private InterstitialAd zzgw;
    private MediationRewardedVideoAdListener zzgx;
    private RewardedVideoAdListener zzgy = new com.google.ads.mediation.zza(this);

    public AbstractAdViewAdapter() {
    }

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    private final AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            zzlc.zzij();
            builder.addTestDevice(zzako.zzaz(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzgs != null) {
            this.zzgs.destroy();
            this.zzgs = null;
        }
        if (this.zzgt != null) {
            this.zzgt = null;
        }
        if (this.zzgu != null) {
            this.zzgu = null;
        }
        if (this.zzgw != null) {
            this.zzgw = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzgs != null) {
            this.zzgs.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzgs != null) {
            this.zzgs.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzgs = new AdView(context);
        this.zzgs.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzgs.setAdUnitId(this.getAdUnitId(bundle));
        this.zzgs.setAdListener(new zzd(this, mediationBannerListener));
        this.zzgs.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzgs;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzgt = new InterstitialAd(context);
        this.zzgt.setAdUnitId(this.getAdUnitId(bundle));
        this.zzgt.setAdListener(new zze(this, mediationInterstitialListener));
        this.zzgt.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void onImmersiveModeUpdated(boolean bl) {
        if (this.zzgt != null) {
            this.zzgt.setImmersiveMode(bl);
        }
        if (this.zzgw != null) {
            this.zzgw.setImmersiveMode(bl);
        }
    }

    @Override
    public zzmm getVideoController() {
        VideoController videoController;
        if (this.zzgs != null && (videoController = this.zzgs.getVideoController()) != null) {
            return videoController.zzbh();
        }
        return null;
    }

    @Override
    public void showInterstitial() {
        this.zzgt.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzah(1).zzvp();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zzf zzf2 = new zzf(this, mediationNativeListener);
        String string = bundle.getString(AD_UNIT_ID_PARAMETER);
        Context context2 = context;
        AdLoader.Builder builder = new AdLoader.Builder(context2, string).withAdListener(zzf2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.zznb()) {
            builder.zza(zzf2);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zzf2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zzf2);
        }
        if (nativeMediationAdRequest.zznc()) {
            for (String string2 : nativeMediationAdRequest.zznd().keySet()) {
                builder.forCustomTemplateAd(string2, zzf2, nativeMediationAdRequest.zznd().get(string2) != false ? zzf2 : null);
            }
        }
        this.zzgu = builder.build();
        this.zzgu.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzgv = context.getApplicationContext();
        this.zzgx = mediationRewardedVideoAdListener;
        this.zzgx.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzgv == null || this.zzgx == null) {
            zzaky.e("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzgw = new InterstitialAd(this.zzgv);
        this.zzgw.zza(true);
        this.zzgw.setAdUnitId(this.getAdUnitId(bundle));
        this.zzgw.setRewardedVideoAdListener(this.zzgy);
        this.zzgw.loadAd(this.zza(this.zzgv, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzgw.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzgx != null;
    }

    static /* synthetic */ MediationRewardedVideoAdListener zza(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzgx;
    }

    static /* synthetic */ InterstitialAd zza(AbstractAdViewAdapter abstractAdViewAdapter, InterstitialAd interstitialAd) {
        abstractAdViewAdapter.zzgw = null;
        return null;
    }

    static final class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzhb;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzhb = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzhb);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzamn.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzhb);
            }
        }
    }

    static final class zzc
    extends com.google.android.gms.ads.mediation.zza {
        private final UnifiedNativeAd zzhc;

        public zzc(UnifiedNativeAd unifiedNativeAd) {
            this.zzhc = unifiedNativeAd;
            this.setHeadline(unifiedNativeAd.getHeadline());
            this.setImages(unifiedNativeAd.getImages());
            this.setBody(unifiedNativeAd.getBody());
            this.setIcon(unifiedNativeAd.getIcon());
            this.setCallToAction(unifiedNativeAd.getCallToAction());
            this.setAdvertiser(unifiedNativeAd.getAdvertiser());
            this.zza(unifiedNativeAd.getStarRating());
            this.setStore(unifiedNativeAd.getStore());
            this.setPrice(unifiedNativeAd.getPrice());
            this.zzk(unifiedNativeAd.zzbl());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(unifiedNativeAd.getVideoController());
        }

        @Override
        public final void trackViews(View view, Map<String, View> map, Map<String, View> map2) {
            if (view instanceof com.google.android.gms.ads.formats.zzd) {
                com.google.android.gms.ads.formats.zzd.zzb(this.zzhc);
                return;
            }
        }
    }

    static final class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzha;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzha = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzha);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzamn.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzha);
            }
        }
    }

    static final class zzf
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    NativeCustomTemplateAd.OnCustomClickListener,
    NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener,
    UnifiedNativeAd.zza {
        private AbstractAdViewAdapter zzhd;
        private MediationNativeListener zzhg;

        public zzf(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzhd = abstractAdViewAdapter;
            this.zzhg = mediationNativeListener;
        }

        @Override
        public final void onAdLoaded() {
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzhg.onAdFailedToLoad(this.zzhd, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzhg.onAdOpened(this.zzhd);
        }

        @Override
        public final void onAdClosed() {
            this.zzhg.onAdClosed(this.zzhd);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzhg.onAdLeftApplication(this.zzhd);
        }

        @Override
        public final void onAdClicked() {
            this.zzhg.onAdClicked(this.zzhd);
        }

        @Override
        public final void onAdImpression() {
            this.zzhg.onAdImpression(this.zzhd);
        }

        @Override
        public final void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzhg.onAdLoaded(this.zzhd, new zza(nativeAppInstallAd));
        }

        @Override
        public final void zza(UnifiedNativeAd unifiedNativeAd) {
            this.zzhg.zza((MediationNativeAdapter)this.zzhd, new zzc(unifiedNativeAd));
        }

        @Override
        public final void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzhg.onAdLoaded(this.zzhd, new zzb(nativeContentAd));
        }

        @Override
        public final void onCustomTemplateAdLoaded(NativeCustomTemplateAd nativeCustomTemplateAd) {
            this.zzhg.zza((MediationNativeAdapter)this.zzhd, nativeCustomTemplateAd);
        }

        @Override
        public final void onCustomClick(NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
            this.zzhg.zza(this.zzhd, nativeCustomTemplateAd, string);
        }
    }

    static final class zze
    extends AdListener
    implements zzkf {
        private AbstractAdViewAdapter zzhd;
        private MediationInterstitialListener zzhf;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzhd = abstractAdViewAdapter;
            this.zzhf = mediationInterstitialListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzhf.onAdLoaded(this.zzhd);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzhf.onAdFailedToLoad(this.zzhd, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzhf.onAdOpened(this.zzhd);
        }

        @Override
        public final void onAdClosed() {
            this.zzhf.onAdClosed(this.zzhd);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzhf.onAdLeftApplication(this.zzhd);
        }

        @Override
        public final void onAdClicked() {
            this.zzhf.onAdClicked(this.zzhd);
        }
    }

    static final class zzd
    extends AdListener
    implements AppEventListener,
    zzkf {
        private AbstractAdViewAdapter zzhd;
        private MediationBannerListener zzhe;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzhd = abstractAdViewAdapter;
            this.zzhe = mediationBannerListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzhe.onAdLoaded(this.zzhd);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzhe.onAdFailedToLoad(this.zzhd, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzhe.onAdOpened(this.zzhd);
        }

        @Override
        public final void onAdClosed() {
            this.zzhe.onAdClosed(this.zzhd);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzhe.onAdLeftApplication(this.zzhd);
        }

        @Override
        public final void onAdClicked() {
            this.zzhe.onAdClicked(this.zzhd);
        }

        @Override
        public final void onAppEvent(String string, String string2) {
            this.zzhe.zza(this.zzhd, string, string2);
        }
    }
}

