/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.mediation.MediationExtrasReceiver;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.query.AdInfo;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzbha;
import com.google.android.gms.internal.ads.zzbhb;
import com.google.android.gms.internal.ads.zzcgg;
import java.util.Date;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public class AdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int ERROR_CODE_APP_ID_MISSING = 8;
    public static final int ERROR_CODE_REQUEST_ID_MISMATCH = 10;
    public static final int ERROR_CODE_INVALID_AD_STRING = 11;
    public static final int ERROR_CODE_MEDIATION_NO_FILL = 9;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final int MAX_CONTENT_URL_LENGTH = 512;
    @RecentlyNonNull
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    protected final zzbhb zza;

    protected AdRequest(@RecentlyNonNull Builder builder) {
        zzbhb zzbhb2;
        this.zza = zzbhb2 = new zzbhb(builder.zza, null);
    }

    @RecentlyNonNull
    public String getContentUrl() {
        return this.zza.zzb();
    }

    @RecentlyNonNull
    public List<String> getNeighboringContentUrls() {
        return this.zza.zzc();
    }

    @RecentlyNonNull
    public Set<String> getKeywords() {
        return this.zza.zze();
    }

    @RecentlyNonNull
    public Location getLocation() {
        return this.zza.zzf();
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public <T extends MediationExtrasReceiver> Bundle getNetworkExtrasBundle(@RecentlyNonNull Class<T> adapterClass) {
        void var1_1;
        return this.zza.zzh((Class<? extends MediationExtrasReceiver>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(@RecentlyNonNull Class<T> adapterClass) {
        void var1_1;
        return this.zza.zzi((Class<? extends CustomEvent>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isTestDevice(@RecentlyNonNull Context context) {
        void var1_1;
        return this.zza.zzm((Context)var1_1);
    }

    @RecentlyNonNull
    public Bundle getCustomTargeting() {
        return this.zza.zzq();
    }

    public zzbhb zza() {
        return this.zza;
    }

    @VisibleForTesting
    public static class Builder {
        protected final zzbha zza;

        public Builder() {
            zzbha zzbha2;
            this.zza = zzbha2 = new zzbha();
            this.zza.zze(AdRequest.DEVICE_ID_EMULATOR);
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addKeyword(@RecentlyNonNull String keyword) {
            void var1_1;
            this.zza.zza((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @RecentlyNonNull
        public Builder addNetworkExtras(@RecentlyNonNull NetworkExtras networkExtras) {
            void var1_1;
            this.zza.zzb((NetworkExtras)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addNetworkExtrasBundle(@RecentlyNonNull Class<? extends MediationExtrasReceiver> adapterClass, @RecentlyNonNull Bundle networkExtras) {
            void var2_2;
            void var1_1;
            this.zza.zzc((Class<? extends MediationExtrasReceiver>)var1_1, (Bundle)var2_2);
            if (var1_1.equals(AdMobAdapter.class) && var2_2.getBoolean("_emulatorLiveAds")) {
                this.zza.zzf(AdRequest.DEVICE_ID_EMULATOR);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addCustomEventExtrasBundle(@RecentlyNonNull Class<? extends CustomEvent> adapterClass, @RecentlyNonNull Bundle customEventExtras) {
            void var2_2;
            void var1_1;
            this.zza.zzd((Class<? extends CustomEvent>)var1_1, (Bundle)var2_2);
            return this;
        }

        @RecentlyNonNull
        public AdRequest build() {
            AdRequest adRequest = new AdRequest(this);
            return adRequest;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @RecentlyNonNull
        public Builder setContentUrl(@RecentlyNonNull String contentUrl) {
            void var1_1;
            Preconditions.checkNotNull((Object)contentUrl, (Object)"Content URL must be non-null.");
            Preconditions.checkNotEmpty((String)var1_1, (Object)"Content URL must be non-empty.");
            boolean bl = var1_1.length() <= 512;
            Object[] objectArray = new Object[]{512, var1_1.length()};
            Preconditions.checkArgument((boolean)bl, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])objectArray);
            this.zza.zzh((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setNeighboringContentUrls(@RecentlyNonNull List<String> neighboringContentUrls) {
            void var1_1;
            if (neighboringContentUrls == null) {
                zzcgg.zzi("neighboring content URLs list should not be null");
                return this;
            }
            this.zza.zzi((List<String>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setLocation(@RecentlyNonNull Location location) {
            void var1_1;
            this.zza.zzk((Location)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setRequestAgent(@RecentlyNonNull String requestAgent) {
            void var1_1;
            this.zza.zzm((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @KeepForSdk
        @RecentlyNonNull
        public Builder setAdInfo(@RecentlyNonNull AdInfo adInfo) {
            void var1_1;
            this.zza.zzr((AdInfo)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @RecentlyNonNull
        public Builder setAdString(@RecentlyNonNull String adString) {
            void var1_1;
            this.zza.zzs((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setHttpTimeoutMillis(int httpTimeoutMillis) {
            void var1_1;
            this.zza.zzt((int)var1_1);
            return this;
        }

        @Deprecated
        @RecentlyNonNull
        public final Builder zza(@RecentlyNonNull String string) {
            this.zza.zze(string);
            return this;
        }

        @Deprecated
        @RecentlyNonNull
        public final Builder zzb(@RecentlyNonNull Date date) {
            this.zza.zzg(date);
            return this;
        }

        @Deprecated
        @RecentlyNonNull
        public final Builder zzc(int n) {
            this.zza.zzj(n);
            return this;
        }

        @Deprecated
        @RecentlyNonNull
        public final Builder zzd(boolean bl) {
            this.zza.zzn(bl);
            return this;
        }

        @Deprecated
        @RecentlyNonNull
        public final Builder zze(boolean bl) {
            this.zza.zzq(bl);
            return this;
        }
    }
}

