/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AppEventListener;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.client.zzea;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.ads.zzc;
import com.google.android.gms.ads.zzd;
import com.google.android.gms.ads.zze;
import com.google.android.gms.ads.zzf;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbeg;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzbgi;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public abstract class BaseAdView
extends ViewGroup {
    @NotOnlyInitialized
    protected final zzea zza;

    @NonNull
    public AdListener getAdListener() {
        return this.zza.zza();
    }

    @Nullable
    public AdSize getAdSize() {
        return this.zza.zzb();
    }

    @Nullable
    public OnPaidEventListener getOnPaidEventListener() {
        return this.zza.zzc();
    }

    @Nullable
    public ResponseInfo getResponseInfo() {
        return this.zza.zzd();
    }

    @NonNull
    public String getAdUnitId() {
        return this.zza.zzj();
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, int adViewType) {
        super((Context)var1_1);
        void var2_2;
        void var1_1;
        this.zza = new zzea(this, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, int adViewType) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = new zzea(this, (AttributeSet)var2_2, false, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, boolean allowMultipleAdSizes) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = new zzea(this, (AttributeSet)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyle, int adViewType) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = new zzea(this, (AttributeSet)var2_2, false, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyle, int adViewType, boolean allowMultipleAdSizes) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        void var4_4;
        void var5_5;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = new zzea(this, (AttributeSet)var2_2, (boolean)var5_5, (int)var4_4);
    }

    public void destroy() {
        zzbep.zza(this.getContext());
        if (((Boolean)zzbgi.zze.zze()).booleanValue()) {
            zzbeg zzbeg2 = zzbep.zzld;
            if (((Boolean)zzba.zzc().zza(zzbeg2)).booleanValue()) {
                zzb.zzb.execute(new zzd(this));
                return;
            }
        }
        this.zza.zzk();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull AdRequest adRequest) {
        void var1_1;
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbep.zza(this.getContext());
        if (((Boolean)zzbgi.zzf.zze()).booleanValue()) {
            zzbeg zzbeg2 = zzbep.zzlg;
            if (((Boolean)zzba.zzc().zza(zzbeg2)).booleanValue()) {
                zzb.zzb.execute(new zzf(this, (AdRequest)var1_1));
                return;
            }
        }
        this.zza.zzm(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int left, int top, int right, int bottom) {
        if ((this = this.getChildAt(0)) != null && this.getVisibility() != 8) {
            void var3_4;
            void var5_6;
            void var2_3;
            void var4_5;
            int n = this.getMeasuredWidth();
            int n2 = this.getMeasuredHeight();
            void v0 = var4_5 - var2_3 - n;
            var2_3 = var5_6 - var3_4 - n2;
            void v1 = v0 / 2;
            void v2 = var2_3 /= 2;
            this.layout((int)v1, (int)v2, (int)(v1 + n), (int)(v2 + n2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        void var2_3;
        void var1_2;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, (int)var1_2, (int)var2_3);
            n2 = view.getMeasuredWidth();
            n = view.getMeasuredHeight();
        } else {
            AdSize adSize;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzm.zzh("Unable to retrieve ad size.", nullPointerException);
                adSize = null;
            }
            if (adSize != null) {
                AdSize adSize2 = adSize;
                Context context = this.getContext();
                n2 = adSize2.getWidthInPixels(context);
                n = adSize2.getHeightInPixels(context);
            } else {
                n2 = 0;
                n = 0;
            }
        }
        BaseAdView baseAdView = this;
        int n3 = Math.max(n, baseAdView.getSuggestedMinimumHeight());
        baseAdView.setMeasuredDimension(View.resolveSize((int)Math.max(n2, this.getSuggestedMinimumWidth()), (int)var1_2), View.resolveSize((int)n3, (int)var2_3));
    }

    public void pause() {
        zzbep.zza(this.getContext());
        if (((Boolean)zzbgi.zzg.zze()).booleanValue()) {
            zzbeg zzbeg2 = zzbep.zzle;
            if (((Boolean)zzba.zzc().zza(zzbeg2)).booleanValue()) {
                zzb.zzb.execute(new zze(this));
                return;
            }
        }
        this.zza.zzn();
    }

    public void resume() {
        zzbep.zza(this.getContext());
        if (((Boolean)zzbgi.zzh.zze()).booleanValue()) {
            zzbeg zzbeg2 = zzbep.zzlc;
            if (((Boolean)zzba.zzc().zza(zzbeg2)).booleanValue()) {
                zzb.zzb.execute(new zzc(this));
                return;
            }
        }
        this.zza.zzp();
    }

    /*
     * WARNING - void declaration
     */
    public void setAdListener(@NonNull AdListener adListener) {
        void var1_1;
        this.zza.zzr((AdListener)var1_1);
        if (var1_1 == null) {
            this.zza.zzq(null);
            return;
        }
        if (var1_1 instanceof zza) {
            this.zza.zzq((zza)var1_1);
        }
        if (var1_1 instanceof AppEventListener) {
            this.zza.zzv((AppEventListener)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAdSize(@NonNull AdSize adSize) {
        void var1_1;
        AdSize[] adSizeArray = new AdSize[]{var1_1};
        this.zza.zzs(adSizeArray);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdUnitId(@NonNull String adUnitId) {
        void var1_1;
        this.zza.zzu((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setOnPaidEventListener(@Nullable OnPaidEventListener listener) {
        void var1_1;
        this.zza.zzx((OnPaidEventListener)var1_1);
    }

    public boolean isCollapsible() {
        return this.zza.zzA();
    }

    public boolean isLoading() {
        return this.zza.zzB();
    }
}

