/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzbqx;

public final class zzek
extends ContentProvider {
    public final int delete(@NonNull Uri uri, String string, String[] stringArray) {
        return 0;
    }

    public final int update(@NonNull Uri uri, ContentValues contentValues, String string, String[] stringArray) {
        return 0;
    }

    @Nullable
    public final Cursor query(@NonNull Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        return null;
    }

    @Nullable
    public final Uri insert(@NonNull Uri uri, ContentValues contentValues) {
        return null;
    }

    @Nullable
    public final String getType(@NonNull Uri uri) {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void attachInfo(Context context, ProviderInfo providerInfo) {
        Bundle bundle;
        block18: {
            String string;
            Object object;
            block17: {
                try {
                    bundle = Wrappers.packageManager((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
                }
                catch (NullPointerException nullPointerException) {
                    zzm.zzh("Failed to load metadata: Null pointer exception.", nullPointerException);
                    bundle = null;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    zzm.zzh("Failed to load metadata: Package name not found.", nameNotFoundException);
                    bundle = null;
                }
                object = zzbqx.zza();
                if (bundle == null) {
                    zzm.zzg("Metadata was null.");
                } else {
                    String string2 = (String)bundle.get("com.google.android.gms.ads.APPLICATION_ID");
                    Boolean bl = (Boolean)bundle.get("com.google.android.gms.ads.DELAY_APP_MEASUREMENT_INIT");
                    string = (String)bundle.get("com.google.android.gms.ads.INTEGRATION_MANAGER");
                    if (string2 == null) break block17;
                    if (!string2.matches("^ca-app-pub-[0-9]{16}~[0-9]{10}$")) {
                        throw new IllegalStateException("\n\n******************************************************************************\n* Invalid application ID. Follow instructions here:                          *\n* https://googlemobileadssdk.page.link/admob-android-update-manifest         *\n* to find your app ID.                                                       *\n* Google Ad Manager publishers should follow instructions here:              *\n* https://googlemobileadssdk.page.link/ad-manager-android-update-manifest.   *\n******************************************************************************\n\n");
                    }
                    zzm.zze("Publisher provided Google AdMob App ID in manifest: ".concat(string2));
                    if (bl == null || !bl.booleanValue()) {
                        ((zzbqx)object).zzb(context, string2);
                    }
                }
                break block18;
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new IllegalStateException("\n\n******************************************************************************\n* Missing application ID. AdMob publishers should follow the instructions    *\n* here:                                                                      *\n* https://googlemobileadssdk.page.link/admob-android-update-manifest         *\n* to add a valid App ID inside the AndroidManifest.                          *\n* Google Ad Manager publishers should follow instructions here:              *\n* https://googlemobileadssdk.page.link/ad-manager-android-update-manifest.   *\n******************************************************************************\n\n");
            }
            object = String.valueOf(string);
            zzm.zze("The Google Mobile Ads SDK is integrated by ".concat((String)object));
        }
        if (bundle != null) {
            boolean bl = bundle.getBoolean("com.google.android.gms.ads.flag.OPTIMIZE_AD_LOADING", false);
            if (bundle.getBoolean("com.google.android.gms.ads.flag.OPTIMIZE_INITIALIZATION", false)) {
                zzm.zze("com.google.android.gms.ads.flag.OPTIMIZE_INITIALIZATION is enabled");
            }
            if (bl) {
                zzm.zze("com.google.android.gms.ads.flag.OPTIMIZE_AD_LOADING is enabled");
            }
        }
        super.attachInfo(context, providerInfo);
        return;
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("The com.google.android.gms.ads.APPLICATION_ID metadata must have a String value.", classCastException);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("The com.google.android.gms.ads.DELAY_APP_MEASUREMENT_INIT metadata must have a boolean value.", classCastException);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("The com.google.android.gms.ads.INTEGRATION_MANAGER metadata must have a String value.", classCastException);
        }
    }

    public final boolean onCreate() {
        return false;
    }
}

