/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Bundle;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;

public final class SearchAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final String DEVICE_ID_EMULATOR = zzad.DEVICE_ID_EMULATOR;
    public static final int BORDER_TYPE_NONE = 0;
    public static final int BORDER_TYPE_DASHED = 1;
    public static final int BORDER_TYPE_DOTTED = 2;
    public static final int BORDER_TYPE_SOLID = 3;
    public static final int CALL_BUTTON_COLOR_LIGHT = 0;
    public static final int CALL_BUTTON_COLOR_MEDIUM = 1;
    public static final int CALL_BUTTON_COLOR_DARK = 2;
    private final zzad zzpg;
    private final int zzTs;
    private final int mBackgroundColor;
    private final int zzTt;
    private final int zzTu;
    private final int zzTv;
    private final int zzTw;
    private final int zzTx;
    private final int zzTy;
    private final String zzTz;
    private final int zzTA;
    private final String zzTB;
    private final int zzTC;
    private final int zzTD;
    private final String zzrS;

    private SearchAdRequest(Builder builder) {
        this.zzTs = builder.zzTs;
        this.mBackgroundColor = builder.mBackgroundColor;
        this.zzTt = builder.zzTt;
        this.zzTu = builder.zzTu;
        this.zzTv = builder.zzTv;
        this.zzTw = builder.zzTw;
        this.zzTx = builder.zzTx;
        this.zzTy = builder.zzTy;
        this.zzTz = builder.zzTz;
        this.zzTA = builder.zzTA;
        this.zzTB = builder.zzTB;
        this.zzTC = builder.zzTC;
        this.zzTD = builder.zzTD;
        this.zzrS = builder.zzrS;
        this.zzpg = new zzad(builder.zzph, this);
    }

    public int getAnchorTextColor() {
        return this.zzTs;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getBackgroundGradientBottom() {
        return this.zzTt;
    }

    public int getBackgroundGradientTop() {
        return this.zzTu;
    }

    public int getBorderColor() {
        return this.zzTv;
    }

    public int getBorderThickness() {
        return this.zzTw;
    }

    public int getBorderType() {
        return this.zzTx;
    }

    public int getCallButtonColor() {
        return this.zzTy;
    }

    public String getCustomChannels() {
        return this.zzTz;
    }

    public int getDescriptionTextColor() {
        return this.zzTA;
    }

    public String getFontFace() {
        return this.zzTB;
    }

    public int getHeaderTextColor() {
        return this.zzTC;
    }

    public int getHeaderTextSize() {
        return this.zzTD;
    }

    public Location getLocation() {
        return this.zzpg.getLocation();
    }

    @Deprecated
    public <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzpg.getNetworkExtras(clazz);
    }

    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzpg.getNetworkExtrasBundle(clazz);
    }

    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzpg.getCustomEventExtrasBundle(clazz);
    }

    public String getQuery() {
        return this.zzrS;
    }

    public boolean isTestDevice(Context context) {
        return this.zzpg.isTestDevice(context);
    }

    zzad zzaX() {
        return this.zzpg;
    }

    public static final class Builder {
        private final zzad.zza zzph = new zzad.zza();
        private int zzTs;
        private int mBackgroundColor;
        private int zzTt;
        private int zzTu;
        private int zzTv;
        private int zzTw;
        private int zzTx = 0;
        private int zzTy;
        private String zzTz;
        private int zzTA;
        private String zzTB;
        private int zzTC;
        private int zzTD;
        private String zzrS;

        public Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzph.zza(networkExtras);
            return this;
        }

        public Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzph.zza(clazz, bundle);
            return this;
        }

        public Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzph.zzb(clazz, bundle);
            return this;
        }

        public Builder addTestDevice(String string) {
            this.zzph.zzG(string);
            return this;
        }

        public SearchAdRequest build() {
            return new SearchAdRequest(this);
        }

        public Builder setAnchorTextColor(int n) {
            this.zzTs = n;
            return this;
        }

        public Builder setBackgroundColor(int n) {
            this.mBackgroundColor = n;
            this.zzTt = Color.argb((int)0, (int)0, (int)0, (int)0);
            this.zzTu = Color.argb((int)0, (int)0, (int)0, (int)0);
            return this;
        }

        public Builder setBackgroundGradient(int n, int n2) {
            this.mBackgroundColor = Color.argb((int)0, (int)0, (int)0, (int)0);
            this.zzTt = n2;
            this.zzTu = n;
            return this;
        }

        public Builder setBorderColor(int n) {
            this.zzTv = n;
            return this;
        }

        public Builder setBorderThickness(int n) {
            this.zzTw = n;
            return this;
        }

        public Builder setBorderType(int n) {
            this.zzTx = n;
            return this;
        }

        public Builder setCallButtonColor(int n) {
            this.zzTy = n;
            return this;
        }

        public Builder setCustomChannels(String string) {
            this.zzTz = string;
            return this;
        }

        public Builder setDescriptionTextColor(int n) {
            this.zzTA = n;
            return this;
        }

        public Builder setFontFace(String string) {
            this.zzTB = string;
            return this;
        }

        public Builder setHeaderTextColor(int n) {
            this.zzTC = n;
            return this;
        }

        public Builder setHeaderTextSize(int n) {
            this.zzTD = n;
            return this;
        }

        public Builder setLocation(Location location) {
            this.zzph.zzb(location);
            return this;
        }

        public Builder setQuery(String string) {
            this.zzrS = string;
            return this;
        }

        public Builder setRequestAgent(String string) {
            this.zzph.zzK(string);
            return this;
        }

        public Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzph.zzm(bl);
            return this;
        }
    }
}

