/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpx;
import com.google.android.gms.internal.zzqp;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

@zzmb
public abstract class zzil
implements Releasable {
    protected Context mContext;
    protected String zzHY;
    protected WeakReference<zzqp> zzHZ;

    public zzil(zzqp zzqp2) {
        this.mContext = zzqp2.getContext();
        this.zzHY = zzv.zzcJ().zzh(this.mContext, zzqp2.zzkY().zzaZ);
        this.zzHZ = new WeakReference<zzqp>(zzqp2);
    }

    public abstract boolean zzad(String var1);

    public abstract void abort();

    public void release() {
    }

    protected void zza(final String string2, final String string3, final int n, final int n2, final boolean bl) {
        zzpx.zzXU.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheProgress");
                hashMap.put("src", string2);
                hashMap.put("cachedSrc", string3);
                hashMap.put("bytesLoaded", Integer.toString(n));
                hashMap.put("totalBytes", Integer.toString(n2));
                hashMap.put("cacheReady", bl ? "1" : "0");
                zzil.this.zza("onPrecacheEvent", hashMap);
            }
        });
    }

    protected void zza(final String string2, final String string3, final int n) {
        zzpx.zzXU.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheComplete");
                hashMap.put("src", string2);
                hashMap.put("cachedSrc", string3);
                hashMap.put("totalBytes", Integer.toString(n));
                zzil.this.zza("onPrecacheEvent", hashMap);
            }
        });
    }

    public void zza(final String string2, final String string3, final String string4, final @Nullable String string5) {
        zzpx.zzXU.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheCanceled");
                hashMap.put("src", string2);
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    hashMap.put("cachedSrc", string3);
                }
                hashMap.put("type", zzil.this.zzaf(string4));
                hashMap.put("reason", string4);
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    hashMap.put("message", string5);
                }
                zzil.this.zza("onPrecacheEvent", hashMap);
            }
        });
    }

    protected String zzae(String string2) {
        return zzeh.zzeO().zzbb(string2);
    }

    private String zzaf(String string2) {
        String string3 = "internal";
        switch (string2) {
            case "error": 
            case "playerFailed": 
            case "inProgress": 
            case "contentLengthMissing": {
                string3 = "internal";
                break;
            }
            case "noCacheDir": 
            case "expireFailed": {
                string3 = "io";
                break;
            }
            case "badUrl": 
            case "downloadTimeout": {
                string3 = "network";
                break;
            }
            case "sizeExceeded": 
            case "externalAbort": {
                string3 = "policy";
            }
        }
        return string3;
    }

    private void zza(String string2, Map<String, String> map) {
        zzqp zzqp2 = (zzqp)this.zzHZ.get();
        if (zzqp2 != null) {
            zzqp2.zza(string2, map);
        }
    }
}

