/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzgz;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqq;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
public class zzgv
implements zzgu {
    private final Object zzrN = new Object();
    private final zzr zzGl;
    private final Context mContext;
    @Nullable
    private final JSONObject zzGo;
    @Nullable
    private final zzlt zzGp;
    @Nullable
    private final zzgu.zza zzGq;
    private final zzav zzGr;
    @Nullable
    private final zzqa zztr;
    boolean zzGs;
    private zzqp zzGt;
    private String zzGu;
    @Nullable
    private String zzGv;
    private WeakReference<View> zzGw = null;

    public zzgv(Context context, zzr zzr2, @Nullable zzlt zzlt2, zzav zzav2, @Nullable JSONObject jSONObject, @Nullable zzgu.zza zza2, @Nullable zzqa zzqa2, @Nullable String string2) {
        this.mContext = context;
        this.zzGl = zzr2;
        this.zzGp = zzlt2;
        this.zzGr = zzav2;
        this.zzGo = jSONObject;
        this.zzGq = zza2;
        this.zztr = zzqa2;
        this.zzGv = string2;
    }

    public zzgn zza(View.OnClickListener onClickListener) {
        zzgm zzgm2 = this.zzGq.zzfO();
        if (zzgm2 == null) {
            return null;
        }
        zzgn zzgn2 = new zzgn(this.mContext, zzgm2);
        zzgn2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzgn2.zzfJ().setOnClickListener(onClickListener);
        zzgn2.zzfJ().setContentDescription((CharSequence)zzfx.zzEa.get());
        return zzgn2;
    }

    public void zza(View view, String string2, @Nullable JSONObject jSONObject, Map<String, WeakReference<View>> map, View view2) {
        zzac.zzdn((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("asset", (Object)string2);
            jSONObject2.put("template", (Object)this.zzGq.zzfN());
            final JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("ad", (Object)this.zzGo);
            jSONObject3.put("click", (Object)jSONObject2);
            jSONObject3.put("has_custom_click_handler", this.zzGl.zzz(this.zzGq.getCustomTemplateId()) != null);
            if (zzfx.zzEc.get().booleanValue()) {
                if (zzfx.zzEd.get().booleanValue()) {
                    jSONObject3.put("asset_view_signal", (Object)this.zzb(map, view2));
                    jSONObject3.put("ad_view_signal", (Object)this.zzo(view2));
                } else {
                    jSONObject3.put("view_rectangles", (Object)this.zza(map, view2));
                    jSONObject3.put("native_view_rectangle", (Object)this.zzn(view2));
                }
            }
            if (jSONObject != null) {
                jSONObject3.put("click_point", (Object)jSONObject);
            }
            try {
                JSONObject jSONObject4 = this.zzGo.optJSONObject("tracking_urls_and_actions");
                if (jSONObject4 == null) {
                    jSONObject4 = new JSONObject();
                }
                String string3 = jSONObject4.optString("click_string");
                jSONObject2.put("click_signals", (Object)this.zzGr.zzW().zza(this.mContext, string3, view));
            }
            catch (Exception exception) {
                zzpe.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject3.put("ads_id", (Object)this.zzGv);
            this.zzGp.zza(new zzlt.zza(this){

                @Override
                public void zze(zzjb zzjb2) {
                    zzjb2.zza("google.afma.nativeAds.handleClickGmsg", jSONObject3);
                }
            });
        }
        catch (JSONException jSONException) {
            zzpe.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
        }
    }

    public void zza(View view, Map<String, WeakReference<View>> map, JSONObject jSONObject, View view2) {
        zzac.zzdn((String)"performClick must be called on the main UI thread.");
        if (map != null) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view3 = (View)entry.getValue().get();
                if (!view.equals(view3)) continue;
                this.zza(view, entry.getKey(), jSONObject, map, view2);
                return;
            }
        }
        if ("2".equals(this.zzGq.zzfN())) {
            this.zza(view, "2099", jSONObject, map, view2);
        } else if ("1".equals(this.zzGq.zzfN())) {
            this.zza(view, "1099", jSONObject, map, view2);
        }
    }

    public void zzd(MotionEvent motionEvent) {
        this.zzGr.zza(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzd(View view, Map<String, WeakReference<View>> map) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzGs) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.zzb(view, map);
        }
    }

    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzac.zzdn((String)"recordImpression must be called on the main UI thread.");
        this.zzq(true);
        try {
            final JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzGo);
            jSONObject.put("ads_id", (Object)this.zzGv);
            if (zzfx.zzEc.get().booleanValue()) {
                if (zzfx.zzEd.get().booleanValue()) {
                    jSONObject.put("asset_view_signal", (Object)this.zzb(map, view));
                    jSONObject.put("ad_view_signal", (Object)this.zzo(view));
                } else {
                    jSONObject.put("view_rectangles", (Object)this.zza(map, view));
                    jSONObject.put("native_view_rectangle", (Object)this.zzn(view));
                }
            }
            this.zzGp.zza(new zzlt.zza(this){

                @Override
                public void zze(zzjb zzjb2) {
                    zzjb2.zza("google.afma.nativeAds.handleImpressionPing", jSONObject);
                }
            });
        }
        catch (JSONException jSONException) {
            zzpe.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
        }
        this.zzGl.zza(this);
    }

    public View zzfV() {
        return this.zzGw != null ? (View)this.zzGw.get() : null;
    }

    public void zzj(View view) {
        this.zzGw = new WeakReference<View>(view);
    }

    public void zza(View view, Map<String, WeakReference<View>> map, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        if (!zzfx.zzDX.get().booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(onTouchListener);
            view2.setClickable(true);
            view2.setOnClickListener(onClickListener);
        }
    }

    public void zzc(View view, Map<String, WeakReference<View>> map) {
        if (zzfx.zzDW.get().booleanValue()) {
            return;
        }
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(null);
            view2.setClickable(false);
            view2.setOnClickListener(null);
        }
    }

    public zzqp zzfU() {
        this.zzGt = this.zzfX();
        this.zzGt.getView().setVisibility(8);
        zzlt.zza zza2 = new zzlt.zza(){

            @Override
            public void zze(final zzjb zzjb2) {
                zzjb2.zza("/loadHtml", new zzhx(){

                    @Override
                    public void zza(zzqp zzqp2, final Map<String, String> map) {
                        zzgv.this.zzGt.zzkV().zza(new zzqq.zza(){

                            @Override
                            public void zza(zzqp zzqp2, boolean bl) {
                                zzgv.this.zzGu = (String)map.get("id");
                                JSONObject jSONObject = new JSONObject();
                                try {
                                    jSONObject.put("messageType", (Object)"htmlLoaded");
                                    jSONObject.put("id", (Object)zzgv.this.zzGu);
                                    zzjb2.zzb("sendMessageToNativeJs", jSONObject);
                                }
                                catch (JSONException jSONException) {
                                    zzpe.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                                }
                            }
                        });
                        String string2 = map.get("overlayHtml");
                        String string3 = map.get("baseUrl");
                        if (TextUtils.isEmpty((CharSequence)string3)) {
                            zzgv.this.zzGt.loadData(string2, "text/html", "UTF-8");
                        } else {
                            zzgv.this.zzGt.loadDataWithBaseURL(string3, string2, "text/html", "UTF-8", null);
                        }
                    }
                });
                zzjb2.zza("/showOverlay", new zzhx(){

                    @Override
                    public void zza(zzqp zzqp2, Map<String, String> map) {
                        zzgv.this.zzGt.getView().setVisibility(0);
                    }
                });
                zzjb2.zza("/hideOverlay", new zzhx(){

                    @Override
                    public void zza(zzqp zzqp2, Map<String, String> map) {
                        zzgv.this.zzGt.getView().setVisibility(8);
                    }
                });
                zzgv.this.zzGt.zzkV().zza("/hideOverlay", new zzhx(){

                    @Override
                    public void zza(zzqp zzqp2, Map<String, String> map) {
                        zzgv.this.zzGt.getView().setVisibility(8);
                    }
                });
                zzgv.this.zzGt.zzkV().zza("/sendMessageToSdk", new zzhx(){

                    @Override
                    public void zza(zzqp zzqp2, Map<String, String> map) {
                        JSONObject jSONObject = new JSONObject();
                        try {
                            for (String string2 : map.keySet()) {
                                jSONObject.put(string2, (Object)map.get(string2));
                            }
                            jSONObject.put("id", (Object)zzgv.this.zzGu);
                            zzjb2.zzb("sendMessageToNativeJs", jSONObject);
                        }
                        catch (JSONException jSONException) {
                            zzpe.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                        }
                    }
                });
            }
        };
        this.zzGp.zza(zza2);
        return this.zzGt;
    }

    public void zza(View view, zzgs zzgs2) {
        zzgz zzgz2;
        if (!(this.zzGq instanceof zzgp)) {
            return;
        }
        zzgp zzgp2 = (zzgp)this.zzGq;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        if (zzgp2.zzfP() != null) {
            ((FrameLayout)view).addView(zzgp2.zzfP(), (ViewGroup.LayoutParams)layoutParams);
            this.zzGl.zza(zzgs2);
            return;
        }
        if (zzgp2.getImages() != null && zzgp2.getImages().size() > 0 && (zzgz2 = this.zze(zzgp2.getImages().get(0))) != null) {
            try {
                zzd zzd2 = zzgz2.zzfK();
                if (zzd2 != null) {
                    Drawable drawable2 = (Drawable)zze.zzE((zzd)zzd2);
                    ImageView imageView = this.zzfY();
                    imageView.setImageDrawable(drawable2);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
            }
            catch (RemoteException remoteException) {
                zzpe.zzbe((String)"Could not get drawable from image");
            }
        }
    }

    public void zzfW() {
        if (!(this.zzGq instanceof zzgp)) {
            return;
        }
        this.zzGl.zzct();
    }

    protected void zzq(boolean bl) {
        this.zzGs = bl;
    }

    zzqp zzfX() {
        return zzv.zzcK().zza(this.mContext, zzec.zzj((Context)this.mContext), false, false, this.zzGr, this.zztr);
    }

    public Context getContext() {
        return this.mContext;
    }

    @Nullable
    zzgz zze(Object object) {
        if (object instanceof IBinder) {
            return zzgz.zza.zzB((IBinder)((IBinder)object));
        }
        return null;
    }

    ImageView zzfY() {
        return new ImageView(this.mContext);
    }

    int[] zzk(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    int zzB(int n) {
        return zzeh.zzeO().zzc(this.mContext, n);
    }

    int zzl(View view) {
        return view.getMeasuredWidth();
    }

    int zzm(View view) {
        return view.getMeasuredHeight();
    }

    private JSONObject zzn(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            jSONObject.put("width", this.zzB(this.zzl(view)));
            jSONObject.put("height", this.zzB(this.zzm(view)));
        }
        catch (Exception exception) {
            zzpe.zzbe((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        try {
            int[] nArray = this.zzk(view);
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view2 = (View)entry.getValue().get();
                if (view2 == null) continue;
                int[] nArray2 = this.zzk(view2);
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("width", this.zzB(this.zzl(view2)));
                jSONObject2.put("height", this.zzB(this.zzm(view2)));
                jSONObject2.put("x", this.zzB(nArray2[0] - nArray[0]));
                jSONObject2.put("y", this.zzB(nArray2[1] - nArray[1]));
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
        }
        catch (JSONException jSONException) {
            zzpe.zzbe((String)"Unable to get all view rectangles");
        }
        return jSONObject;
    }

    private JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("x", this.zzB(rect.left));
        jSONObject.put("y", this.zzB(rect.top));
        jSONObject.put("width", this.zzB(rect.right - rect.left));
        jSONObject.put("height", this.zzB(rect.bottom - rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private JSONObject zzo(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = this.zzk(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zzB(this.zzl(view)));
            jSONObject3.put("height", this.zzB(this.zzm(view)));
            jSONObject3.put("x", this.zzB(nArray[0]));
            jSONObject3.put("y", this.zzB(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zzb(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("x", this.zzB(nArray[0]));
                jSONObject2.put("y", this.zzB(nArray[1]));
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzpe.zzbe((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private JSONObject zzb(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = this.zzk(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = this.zzk(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", this.zzB(this.zzl(view2)));
                jSONObject3.put("height", this.zzB(this.zzm(view2)));
                jSONObject3.put("x", this.zzB(nArray2[0] - nArray[0]));
                jSONObject3.put("y", this.zzB(nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = this.zzb(rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("x", this.zzB(nArray2[0] - nArray[0]));
                    jSONObject4.put("y", this.zzB(nArray2[1] - nArray[1]));
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzpe.zzbe((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }
}

