/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzmt;
import com.google.android.gms.internal.zzpe;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzmb
public final class zzms
extends zza {
    public static final Parcelable.Creator<zzms> CREATOR = new zzmt();
    final int mVersionCode;
    ParcelFileDescriptor zzSn;
    private Parcelable zzSo;
    private boolean zzSp;

    zzms(int n, ParcelFileDescriptor parcelFileDescriptor) {
        this.mVersionCode = n;
        this.zzSn = parcelFileDescriptor;
        this.zzSo = null;
        this.zzSp = true;
    }

    public zzms(SafeParcelable safeParcelable) {
        this.mVersionCode = 1;
        this.zzSn = null;
        this.zzSo = safeParcelable;
        this.zzSp = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzSp) {
            byte[] byArray;
            if (this.zzSn == null) {
                zzpe.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzSn));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzo.zzb((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzSo = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzSp = false;
        }
        return (T)((SafeParcelable)this.zzSo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzSn == null) {
            byte[] byArray;
            Parcel parcel2 = Parcel.obtain();
            try {
                this.zzSo.writeToParcel(parcel2, 0);
                byArray = parcel2.marshall();
            }
            finally {
                parcel2.recycle();
            }
            this.zzSn = this.zzj(byArray);
        }
        zzmt.zza(this, parcel, n);
    }

    protected <T> ParcelFileDescriptor zzj(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            Runnable runnable = new Runnable(this, (OutputStream)autoCloseOutputStream2, byArray){
                final /* synthetic */ OutputStream zzSq;
                final /* synthetic */ byte[] zzSr;
                {
                    this.zzSq = outputStream;
                    this.zzSr = byArray;
                }

                @Override
                public void run() {
                    DataOutputStream dataOutputStream = null;
                    try {
                        dataOutputStream = new DataOutputStream(this.zzSq);
                        dataOutputStream.writeInt(this.zzSr.length);
                        dataOutputStream.write(this.zzSr);
                        zzo.zzb((Closeable)dataOutputStream);
                    }
                    catch (IOException iOException) {
                        zzpe.zzb((String)"Error transporting the ad response", (Throwable)iOException);
                        zzv.zzcN().zza(iOException, "LargeParcelTeleporter.pipeData.1");
                    }
                    finally {
                        if (dataOutputStream == null) {
                            zzo.zzb((Closeable)this.zzSq);
                        } else {
                            zzo.zzb((Closeable)dataOutputStream);
                        }
                    }
                }
            };
            new Thread(runnable).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzpe.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzv.zzcN().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzo.zzb(autoCloseOutputStream);
            return null;
        }
    }
}

