/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzcr;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzcx;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpz;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqw;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
public class zzct
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    protected final Object zzrJ = new Object();
    private final WeakReference<zzpb> zzwk;
    private WeakReference<ViewTreeObserver> zzwl;
    private final zzda zzwm;
    protected final zzcr zzwn;
    private final Context zzwi;
    private final WindowManager zzwo;
    private final PowerManager zzwp;
    private final KeyguardManager zzwq;
    @Nullable
    private zzcu zzwr;
    private boolean zzws;
    private boolean zzuo = false;
    private boolean zzwt = false;
    private boolean zzwu;
    private boolean zzwv;
    private boolean zzww;
    @Nullable
    BroadcastReceiver zzwx;
    private final HashSet<Object> zzwy = new HashSet();
    private zzpz zzvT;
    private final HashSet<zzcx> zzwz = new HashSet();

    public zzct(Context context, zzeg zzeg2, zzpb zzpb2, zzqh zzqh2, zzda zzda2) {
        this.zzwk = new WeakReference<zzpb>(zzpb2);
        this.zzwm = zzda2;
        this.zzwl = new WeakReference<Object>(null);
        this.zzwu = true;
        this.zzww = false;
        this.zzvT = new zzpz(200L);
        this.zzwn = new zzcr(UUID.randomUUID().toString(), zzqh2, zzeg2.zzzy, zzpb2.zzWa, zzpb2.zzdD(), zzeg2.zzzB);
        this.zzwo = (WindowManager)context.getSystemService("window");
        this.zzwp = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzwq = (KeyguardManager)context.getSystemService("keyguard");
        this.zzwi = context;
    }

    protected void zzj(boolean bl) {
        Iterator<Object> iterator = this.zzwy.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzdF() {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzwx != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzwx = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzct.this.zzk(3);
                }
            };
            this.zzwi.registerReceiver(this.zzwx, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzdG() {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzwx != null) {
                try {
                    this.zzwi.unregisterReceiver(this.zzwx);
                }
                catch (IllegalStateException illegalStateException) {
                    zzpk.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                }
                catch (Exception exception) {
                    zzw.zzcQ().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                }
                this.zzwx = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzdL();
            this.zzdG();
            this.zzwu = false;
            this.zzdI();
            this.zzdN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzdH() {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzwu) {
                this.zzwv = true;
                try {
                    JSONObject jSONObject = this.zzdQ();
                    this.zza(jSONObject, true);
                }
                catch (JSONException jSONException) {
                    zzpk.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzpk.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzwn.zzdC());
                zzpk.zzbf((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzk(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzk(int n) {
        Object object = this.zzrJ;
        synchronized (object) {
            boolean bl;
            if (!this.zzdO() || !this.zzwu) {
                return;
            }
            View view = this.zzwm.zzdS();
            boolean bl2 = view != null && zzw.zzcM().zza(view, this.zzwp, this.zzwq) && view.getGlobalVisibleRect(new Rect(), null);
            boolean bl3 = this.zzwm.zzdT();
            if (bl3) {
                this.zzdH();
                return;
            }
            boolean bl4 = bl = n == 1;
            if (bl && !this.zzvT.tryAcquire() && bl2 == this.zzww) {
                return;
            }
            if (!bl2 && !this.zzww && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject, false);
                this.zzww = bl2;
            }
            catch (RuntimeException | JSONException throwable) {
                zzpk.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            this.zzdK();
            this.zzdI();
        }
    }

    protected void zzdI() {
        if (this.zzwr != null) {
            this.zzwr.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzdJ() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzwu;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzdK() {
        zzda zzda2 = this.zzwm.zzdU();
        View view = zzda2.zzdS();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzwl.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzdL();
        if (!this.zzws || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzws = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzwl = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    boolean zzb(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzwn.zzdC());
    }

    void zzb(zzqw zzqw2, Map<String, String> map) {
        this.zza(zzqw2.getView(), map);
    }

    void zza(zzcx zzcx2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzwn.zzdC());
        zzpk.zzbf((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzcx2);
    }

    void zzc(Map<String, String> map) {
        if (!map.containsKey("isVisible")) {
            return;
        }
        boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
        this.zzj(bl);
    }

    protected void zzdL() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzwl.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzdM() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzwn.zzdA()).put("activeViewJSON", (Object)this.zzwn.zzdB()).put("timestamp", zzw.zzcS().elapsedRealtime()).put("adFormat", (Object)this.zzwn.zzdz()).put("hashCode", (Object)this.zzwn.zzdC()).put("isMraid", this.zzwn.zzdD()).put("isStopped", this.zzwt).put("isPaused", this.zzuo).put("isScreenOn", this.isScreenOn()).put("isNative", this.zzwn.zzdE()).put("appMuted", zzw.zzcM().zzcs()).put("appVolume", (double)zzw.zzcM().zzcq()).put("deviceVolume", (double)zzw.zzcM().zzS(this.zzwi));
        return jSONObject;
    }

    JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    protected void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = this.zza(jSONObject);
            this.zzb(jSONObject2, bl);
        }
        catch (Throwable throwable) {
            zzpk.zzb((String)"Skipping active view message.", (Throwable)throwable);
        }
    }

    public void zza(zzcx zzcx2) {
        if (this.zzwz.isEmpty()) {
            this.zzdF();
            this.zzk(3);
        }
        this.zzwz.add(zzcx2);
        try {
            JSONObject jSONObject = this.zzd(this.zzwm.zzdS());
            JSONObject jSONObject2 = this.zza(jSONObject);
            zzcx2.zzc(jSONObject2, false);
        }
        catch (JSONException jSONException) {
            zzpk.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
        }
    }

    public void zzb(zzcx zzcx2) {
        this.zzwz.remove(zzcx2);
        zzcx2.zzdW();
        if (this.zzwz.isEmpty()) {
            this.destroy();
        }
    }

    protected void zzdN() {
        ArrayList<zzcx> arrayList = new ArrayList<zzcx>(this.zzwz);
        for (zzcx zzcx2 : arrayList) {
            this.zzb(zzcx2);
        }
    }

    protected void zzb(JSONObject jSONObject, boolean bl) {
        ArrayList<zzcx> arrayList = new ArrayList<zzcx>(this.zzwz);
        for (zzcx zzcx2 : arrayList) {
            zzcx2.zzc(jSONObject, bl);
        }
    }

    protected boolean zzdO() {
        for (zzcx zzcx2 : this.zzwz) {
            if (!zzcx2.zzdV()) continue;
            return true;
        }
        return false;
    }

    protected JSONObject zzdP() throws JSONException {
        return this.zzdM().put("isAttachedToWindow", false).put("isScreenOn", this.isScreenOn()).put("isVisible", false);
    }

    protected JSONObject zzd(@Nullable View view) throws JSONException {
        if (view == null) {
            return this.zzdP();
        }
        boolean bl = zzw.zzcO().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzpk.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzwo.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzwo.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzdM();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", zzw.zzcM().zza(view, this.zzwp, this.zzwq));
        return jSONObject;
    }

    boolean isScreenOn() {
        return this.zzwp.isScreenOn();
    }

    protected JSONObject zzdQ() throws JSONException {
        JSONObject jSONObject = this.zzdM();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzk(1);
    }

    public void onGlobalLayout() {
        this.zzk(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzcu zzcu2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzwr = zzcu2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzwt = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzuo = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzuo = false;
            this.zzk(3);
        }
    }

    public zzcr zzdR() {
        return this.zzwn;
    }

    public static class zzb
    implements zzda {
        private zzha zzwC;

        public zzb(zzha zzha2) {
            this.zzwC = zzha2;
        }

        @Override
        public View zzdS() {
            return this.zzwC != null ? this.zzwC.zzgc() : null;
        }

        @Override
        public boolean zzdT() {
            return this.zzwC == null;
        }

        @Override
        public zzda zzdU() {
            return this;
        }
    }

    public static class zza
    implements zzda {
        private WeakReference<zzha> zzwB;

        public zza(zzha zzha2) {
            this.zzwB = new WeakReference<zzha>(zzha2);
        }

        @Override
        @Nullable
        public View zzdS() {
            zzha zzha2 = (zzha)this.zzwB.get();
            return zzha2 != null ? zzha2.zzgc() : null;
        }

        @Override
        public boolean zzdT() {
            return this.zzwB.get() == null;
        }

        @Override
        public zzda zzdU() {
            return new zzb((zzha)this.zzwB.get());
        }
    }

    public static class zzc
    implements zzda {
        @Nullable
        private final View mView;
        @Nullable
        private final zzpb zzwD;

        public zzc(View view, zzpb zzpb2) {
            this.mView = view;
            this.zzwD = zzpb2;
        }

        @Override
        public View zzdS() {
            return this.mView;
        }

        @Override
        public boolean zzdT() {
            return this.zzwD == null || this.mView == null;
        }

        @Override
        public zzda zzdU() {
            return this;
        }
    }

    public static class zzd
    implements zzda {
        private final WeakReference<View> zzwE;
        private final WeakReference<zzpb> zzwF;

        public zzd(View view, zzpb zzpb2) {
            this.zzwE = new WeakReference<View>(view);
            this.zzwF = new WeakReference<zzpb>(zzpb2);
        }

        @Override
        public View zzdS() {
            return (View)this.zzwE.get();
        }

        @Override
        public boolean zzdT() {
            return this.zzwE.get() == null || this.zzwF.get() == null;
        }

        @Override
        public zzda zzdU() {
            return new zzc((View)this.zzwE.get(), (zzpb)this.zzwF.get());
        }
    }
}

