/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.customtabs.CustomTabsIntent;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqh;

@zzme
public class zzkp
implements MediationInterstitialAdapter {
    private Activity zzLO;
    private zzgr zzLP;
    private MediationInterstitialListener zzLQ;
    private Uri mUri;

    public static boolean zzr(Context context) {
        return zzgr.zzo(context);
    }

    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzLQ = mediationInterstitialListener;
        if (this.zzLQ == null) {
            zzqf.zzbh((String)"Listener not set for mediation. Returning.");
            return;
        }
        if (!(context instanceof Activity)) {
            zzqf.zzbh((String)"AdMobCustomTabs can only work with Activity context. Bailing out.");
            this.zzLQ.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        if (!zzkp.zzr(context)) {
            zzqf.zzbh((String)"Default browser does not support custom tabs. Bailing out.");
            this.zzLQ.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        String string2 = bundle.getString("tab_url");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzqf.zzbh((String)"The tab_url retrieved from mediation metadata is empty. Bailing out.");
            this.zzLQ.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        this.zzLO = (Activity)context;
        this.mUri = Uri.parse((String)string2);
        this.zzLP = new zzgr();
        zzgr.zza zza2 = new zzgr.zza(this){

            @Override
            public void zzfJ() {
                zzqf.zzbf((String)"Hinting CustomTabsService for the load of the new url.");
            }

            @Override
            public void zzfK() {
                zzqf.zzbf((String)"Disconnecting from CustomTabs service.");
            }
        };
        this.zzLP.zza(zza2);
        this.zzLP.zze(this.zzLO);
        this.zzLQ.onAdLoaded((MediationInterstitialAdapter)this);
    }

    public void showInterstitial() {
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder(this.zzLP.zzfH()).build();
        customTabsIntent.intent.setData(this.mUri);
        zzc zzc2 = new zzc(customTabsIntent.intent);
        final AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(zzc2, null, new zzh(){

            @Override
            public void zzbN() {
                zzqf.zzbf((String)"AdMobCustomTabsAdapter overlay is closed.");
                zzkp.this.zzLQ.onAdClosed((MediationInterstitialAdapter)zzkp.this);
                try {
                    zzkp.this.zzLP.zzd(zzkp.this.zzLO);
                }
                catch (Exception exception) {
                    zzqf.zzb((String)"Exception while unbinding from CustomTabsService.", (Throwable)exception);
                }
            }

            @Override
            public void onPause() {
                zzqf.zzbf((String)"AdMobCustomTabsAdapter overlay is paused.");
            }

            @Override
            public void onResume() {
                zzqf.zzbf((String)"AdMobCustomTabsAdapter overlay is resumed.");
            }

            @Override
            public void zzbO() {
                zzqf.zzbf((String)"Opening AdMobCustomTabsAdapter overlay.");
                zzkp.this.zzLQ.onAdOpened((MediationInterstitialAdapter)zzkp.this);
            }
        }, null, new zzqh(0, 0, false));
        zzpo.zzXC.post(new Runnable(){

            @Override
            public void run() {
                zzw.zzcK().zza((Context)zzkp.this.zzLO, adOverlayInfoParcel);
            }
        });
        zzw.zzcQ().zzH(false);
    }

    public void onDestroy() {
        zzqf.zzbf((String)"Destroying AdMobCustomTabsAdapter adapter.");
        try {
            this.zzLP.zzd(this.zzLO);
        }
        catch (Exception exception) {
            zzqf.zzb((String)"Exception while unbinding from CustomTabsService.", (Throwable)exception);
        }
    }

    public void onPause() {
        zzqf.zzbf((String)"Pausing AdMobCustomTabsAdapter adapter.");
    }

    public void onResume() {
        zzqf.zzbf((String)"Resuming AdMobCustomTabsAdapter adapter.");
    }
}

