/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzpv;
import com.google.android.gms.internal.zzqm;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
public class zzps {
    private final Object zzrJ = new Object();
    private String zzXT = "";
    private String zzXU = "";
    private boolean zzXV = false;
    protected String zzXW = "";

    public void zzh(Context context, String string2, String string3) {
        if (!this.zzj(context, string2, string3)) {
            this.zza(context, "In-app preview failed to load because of a system error. Please try again later.", true, true);
            return;
        }
        if ("2".equals(this.zzXW)) {
            zzpk.zzbf((String)"Creative is not pushed for this device.");
            this.zza(context, "There was no creative pushed from DFP to the device.", false, false);
        } else if ("1".equals(this.zzXW)) {
            zzpk.zzbf((String)"The app is not linked for creative preview.");
            this.zzm(context, string2, string3);
        } else if ("0".equals(this.zzXW)) {
            zzpk.zzbf((String)"Device is linked for in app preview.");
            this.zza(context, "The device is successfully linked for creative preview.", false, true);
        }
    }

    public void zzi(Context context, String string2, String string3) {
        if (this.zzk(context, string2, string3)) {
            zzpk.zzbf((String)"Device is linked for debug signals.");
            this.zza(context, "The device is successfully linked for troubleshooting.", false, true);
            return;
        }
        this.zzm(context, string2, string3);
    }

    boolean zzj(Context context, String string2, String string3) {
        String string4;
        String string5 = this.zzl(context, this.zzb(context, zzgd.zzFo.get(), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzpk.zzbf((String)"Not linked for in app preview.");
            return false;
        }
        string5 = string5.trim();
        try {
            JSONObject jSONObject = new JSONObject(string5);
            string4 = jSONObject.optString("gct");
            this.zzXW = jSONObject.optString("status");
        }
        catch (JSONException jSONException) {
            zzpk.zzc((String)"Fail to get in app preview response json.", (Throwable)jSONException);
            return false;
        }
        this.zzbd(string4);
        return true;
    }

    boolean zzk(Context context, String string2, String string3) {
        String string4;
        String string5 = this.zzl(context, this.zzb(context, zzgd.zzFp.get(), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzpk.zzbf((String)"Not linked for debug signals.");
            return false;
        }
        string5 = string5.trim();
        try {
            JSONObject jSONObject = new JSONObject(string5);
            string4 = jSONObject.optString("debug_mode");
        }
        catch (JSONException jSONException) {
            zzpk.zzc((String)"Fail to get debug mode response json.", (Throwable)jSONException);
            return false;
        }
        boolean bl = "1".equals(string4);
        this.zzJ(bl);
        return bl;
    }

    protected String zzl(Context context, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", zzw.zzcM().zzu(context, string3));
        zzpv zzpv2 = new zzpv(context);
        zzqm<String> zzqm2 = zzpv2.zzc(string2, hashMap);
        try {
            return (String)zzqm2.get(zzgd.zzFr.get().intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            String string4 = String.valueOf(string2);
            zzpk.zzb((String)(string4.length() != 0 ? "Timeout while retriving a response from: ".concat(string4) : new String("Timeout while retriving a response from: ")), (Throwable)timeoutException);
            zzqm2.cancel(true);
        }
        catch (InterruptedException interruptedException) {
            String string5 = String.valueOf(string2);
            zzpk.zzb((String)(string5.length() != 0 ? "Interrupted while retriving a response from: ".concat(string5) : new String("Interrupted while retriving a response from: ")), (Throwable)interruptedException);
            zzqm2.cancel(true);
        }
        catch (Exception exception) {
            String string6 = String.valueOf(string2);
            zzpk.zzb((String)(string6.length() != 0 ? "Error retriving a response from: ".concat(string6) : new String("Error retriving a response from: ")), (Throwable)exception);
        }
        return null;
    }

    private void zzm(Context context, String string2, String string3) {
        zzw.zzcM().zza(context, this.zzb(context, zzgd.zzFn.get(), string2, string3));
    }

    public void zza(Context context, String string2, String string3, String string4) {
        Uri.Builder builder = this.zzb(context, zzgd.zzFq.get(), string4, string2).buildUpon();
        builder.appendQueryParameter("debugData", string3);
        zzw.zzcM().zzf(context, string2, builder.build().toString());
    }

    private Uri zzb(Context context, String string2, String string3, String string4) {
        Uri.Builder builder = Uri.parse((String)string2).buildUpon();
        builder.appendQueryParameter("linkedDeviceId", this.zzY(context));
        builder.appendQueryParameter("adSlotPath", string3);
        builder.appendQueryParameter("afmaVersion", string4);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzY(Context context) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)this.zzXT)) {
                this.zzXT = zzw.zzcM().zzv(context, "debug_signals_id.txt");
                if (TextUtils.isEmpty((CharSequence)this.zzXT)) {
                    this.zzXT = zzw.zzcM().zzkL();
                    zzw.zzcM().zzg(context, "debug_signals_id.txt", this.zzXT);
                }
            }
            return this.zzXT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbd(String string2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzXU = string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzkY() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzXU;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzJ(boolean bl) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzXV = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzkZ() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzXV;
        }
    }

    protected void zza(final Context context, final String string2, final boolean bl, final boolean bl2) {
        if (!(context instanceof Activity)) {
            zzpk.zzbg((String)"Can not create dialog without Activity Context");
            return;
        }
        zzpo.zzXC.post(new Runnable(this){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                builder.setMessage((CharSequence)string2);
                if (bl) {
                    builder.setTitle((CharSequence)"Error");
                } else {
                    builder.setTitle((CharSequence)"Info");
                }
                if (bl2) {
                    builder.setNeutralButton((CharSequence)"Dismiss", null);
                } else {
                    builder.setPositiveButton((CharSequence)"Learn More", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int n) {
                            zzw.zzcM().zza(context, Uri.parse((String)"https://support.google.com/dfp_premium/answer/7160685#push"));
                        }
                    });
                    builder.setNegativeButton((CharSequence)"Dismiss", null);
                }
                AlertDialog alertDialog = builder.create();
                alertDialog.show();
            }
        });
    }
}

