/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;

@zzme
public class zza {
    public boolean zza(Context context, zzc zzc2, zzq zzq2) {
        String[] stringArray;
        if (zzc2 == null) {
            zzpk.zzbh((String)"No intent data for launcher overlay.");
            return false;
        }
        zzgd.initialize(context);
        if (zzc2.intent != null) {
            return this.zza(context, zzc2.intent, zzq2);
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)zzc2.url)) {
            zzpk.zzbh((String)"Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.mimeType)) {
            intent.setDataAndType(Uri.parse((String)zzc2.url), zzc2.mimeType);
        } else {
            intent.setData(Uri.parse((String)zzc2.url));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)zzc2.packageName)) {
            intent.setPackage(zzc2.packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.zzMH)) {
            stringArray = zzc2.zzMH.split("/", 2);
            if (stringArray.length < 2) {
                String string = String.valueOf(zzc2.zzMH);
                zzpk.zzbh((String)(string.length() != 0 ? "Could not parse component name from open GMSG: ".concat(string) : new String("Could not parse component name from open GMSG: ")));
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = zzc2.zzMI))) {
            int n = 0;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzpk.zzbh((String)"Could not parse intent flags.");
            }
            intent.addFlags(n);
        }
        if (zzgd.zzFk.get().booleanValue()) {
            intent.addFlags(0x10000000);
            intent.putExtra("android.support.customtabs.extra.user_opt_out", true);
        }
        return this.zza(context, intent, zzq2);
    }

    public boolean zza(Context context, Intent intent, zzq zzq2) {
        try {
            String string = String.valueOf(intent.toURI());
            zzpk.v(string.length() != 0 ? "Launching an intent: ".concat(string) : new String("Launching an intent: "));
            zzw.zzcM().zzb(context, intent);
            if (zzq2 != null) {
                zzq2.zzbD();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzpk.zzbh((String)activityNotFoundException.getMessage());
            return false;
        }
        return true;
    }
}

