/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzag;
import com.google.android.gms.internal.zzao;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzaqg;
import com.google.android.gms.internal.zzay;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbf;
import com.google.android.gms.internal.zzbxt;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzzk;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzbd {
    private static final String TAG = zzbd.class.getSimpleName();
    protected Context zzqn;
    protected Context zzqo;
    private ExecutorService zzqp;
    private DexClassLoader zzqq;
    private zzay zzqr;
    private byte[] zzqs;
    private volatile AdvertisingIdClient zzqt = null;
    private volatile boolean zzpU = false;
    private Future zzqu = null;
    private volatile zzag.zza zzqv = null;
    private Future zzqw = null;
    private volatile boolean zzqx = false;
    protected static final Object zzqy = new Object();
    private zzaq zzqz;
    private GoogleApiClient zzqA = null;
    protected boolean zzqB = false;
    protected static final Object zzqC = new Object();
    protected boolean zzqD = false;
    private static zze zzqE = null;
    protected boolean zzqF = false;
    private Map<Pair<String, String>, zzbz> zzqG;

    public static zzbd zza(Context context, String string2, String string3, boolean bl) {
        zzbd zzbd2 = new zzbd(context);
        try {
            zzbd2.zzb(string2, string3, bl);
            return zzbd2;
        }
        catch (zzba zzba2) {
            return null;
        }
    }

    public Context getContext() {
        return this.zzqn;
    }

    public Context getApplicationContext() {
        return this.zzqo;
    }

    public ExecutorService zzaI() {
        return this.zzqp;
    }

    public DexClassLoader zzaJ() {
        return this.zzqq;
    }

    public zzay zzaK() {
        return this.zzqr;
    }

    public byte[] zzaL() {
        return this.zzqs;
    }

    public GoogleApiClient zzaM() {
        return this.zzqA;
    }

    public boolean zzaN() {
        return this.zzqB;
    }

    public boolean zzaO() {
        return this.zzqF;
    }

    public zzaq zzaP() {
        return this.zzqz;
    }

    public boolean zzaQ() {
        return this.zzqD;
    }

    public zzag.zza zzaR() {
        return this.zzqv;
    }

    public Future zzaS() {
        return this.zzqw;
    }

    private zzbd(Context context) {
        this.zzqn = context;
        this.zzqo = context.getApplicationContext();
        this.zzqG = new HashMap<Pair<String, String>, zzbz>();
    }

    private boolean zzb(String string2, String string3, boolean bl) throws zzba {
        this.zzqp = Executors.newCachedThreadPool();
        this.zzc(bl);
        this.zzaX();
        this.zzaU();
        if (zzbf.zzbc() && zzgd.zzDT.get().booleanValue()) {
            throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
        }
        this.zzo(string2);
        this.zzp(string3);
        this.zzqz = new zzaq(this);
        return true;
    }

    private void zzo(String string2) throws zzba {
        this.zzqr = new zzay(null);
        try {
            this.zzqs = this.zzqr.zzn(string2);
        }
        catch (zzay.zza zza2) {
            throw new zzba(zza2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzp(String string2) throws zzba {
        try {
            File file = this.zzqn.getCacheDir();
            if (file == null && (file = this.zzqn.getDir("dex", 0)) == null) {
                throw new zzba();
            }
            String string3 = zzaz.zzU();
            File file2 = this.zza(string2, file, string3);
            this.zzb(file, string3);
            try {
                this.zzqq = new DexClassLoader(file2.getAbsolutePath(), file.getAbsolutePath(), null, this.zzqn.getClassLoader());
                this.zza(file2);
                this.zza(file, string3);
            }
            catch (Throwable throwable) {
                this.zza(file2);
                this.zza(file, string3);
                this.zzq(String.format("%s/%s.dex", file, string3));
                throw throwable;
            }
            this.zzq(String.format("%s/%s.dex", file, string3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new zzba(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new zzba(iOException);
        }
        catch (zzay.zza zza2) {
            throw new zzba(zza2);
        }
        catch (NullPointerException nullPointerException) {
            throw new zzba(nullPointerException);
        }
        return true;
    }

    @NonNull
    private File zza(String string2, File file, String string3) throws zzay.zza, IOException {
        File file2 = new File(String.format("%s/%s.jar", file, string3));
        if (!file2.exists()) {
            byte[] byArray = this.zzqr.zzc(this.zzqs, string2);
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zza(File file, String string2) {
        block27: {
            byte[] byArray;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            File file3;
            block26: {
                file3 = new File(String.format("%s/%s.tmp", file, string2));
                if (file3.exists()) {
                    return;
                }
                file2 = new File(String.format("%s/%s.dex", file, string2));
                if (!file2.exists()) {
                    return;
                }
                fileInputStream = null;
                fileOutputStream = null;
                long l = file2.length();
                if (l <= 0L) {
                    return;
                }
                byArray = new byte[(int)l];
                fileInputStream = new FileInputStream(file2);
                int n = fileInputStream.read(byArray);
                if (n > 0) break block26;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                this.zza(file2);
                return;
            }
            zzag.zzd zzd2 = new zzag.zzd();
            zzd2.zzcx = Build.VERSION.SDK.getBytes();
            zzd2.zzcw = string2.getBytes();
            byte[] byArray2 = this.zzqr.zzd(this.zzqs, byArray).getBytes();
            zzd2.data = byArray2;
            zzd2.zzcv = zzao.zzh(byArray2);
            file3.createNewFile();
            fileOutputStream = new FileOutputStream(file3);
            byte[] byArray3 = zzbxt.zzf((zzbxt)zzd2);
            fileOutputStream.write(byArray3, 0, byArray3.length);
            fileOutputStream.close();
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            this.zza(file2);
            break block27;
            catch (zzay.zza | IOException | NoSuchAlgorithmException exception) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    this.zza(file2);
                    throw throwable;
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                this.zza(file2);
            }
        }
    }

    private void zzq(String string2) {
        File file = new File(string2);
        this.zza(file);
    }

    private void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean zzb(File file, String string2) {
        block32: {
            zzag.zzd zzd2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block31: {
                byte[] byArray;
                File file3;
                block30: {
                    long l;
                    block29: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block29;
                        this.zza(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    int n = fileInputStream.read(byArray);
                    if (n > 0) break block30;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    this.zza(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                zzd2 = zzag.zzd.zze((byte[])byArray);
                if (string2.equals(new String(zzd2.zzcw)) && Arrays.equals(zzd2.zzcv, zzao.zzh(zzd2.data)) && Arrays.equals(zzd2.zzcx, Build.VERSION.SDK.getBytes())) break block31;
                this.zza(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzqr.zzc(this.zzqs, new String(zzd2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block32;
            catch (zzay.zza | IOException | NoSuchAlgorithmException exception) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
        }
        return true;
    }

    public boolean zza(String string2, String string3, List<Class> list) {
        if (!this.zzqG.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzqG.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzbz(this, string2, string3, list));
            return true;
        }
        return false;
    }

    public Method zzc(String string2, String string3) {
        zzbz zzbz2 = this.zzqG.get(new Pair((Object)string2, (Object)string3));
        if (zzbz2 == null) {
            return null;
        }
        return zzbz2.zzbm();
    }

    private void zzc(boolean bl) {
        this.zzpU = bl;
        if (!bl) {
            return;
        }
        this.zzqu = this.zzqp.submit(new Runnable(){

            @Override
            public void run() {
                zzbd.this.zzaT();
            }
        });
    }

    private void zzaT() {
        try {
            if (this.zzqt == null && this.zzqo != null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzqo);
                advertisingIdClient.start();
                this.zzqt = advertisingIdClient;
            }
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzqt = null;
        }
    }

    private void zzaU() {
        if (!zzgd.zzDV.get().booleanValue()) {
            return;
        }
        this.zzaV();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzaV() {
        Object object = zzqy;
        synchronized (object) {
            if (!this.zzqx) {
                this.zzqw = this.zzqp.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        zzbd.this.zzaW();
                        Object object = zzqy;
                        synchronized (object) {
                            zzbd.this.zzqx = false;
                        }
                    }
                });
                this.zzqx = true;
            }
        }
    }

    private void zzaW() {
        if (this.zzqD) {
            try {
                PackageInfo packageInfo = this.zzqn.getPackageManager().getPackageInfo(this.zzqn.getPackageName(), 0);
                this.zzqv = zzaqg.zzq((Context)this.zzqn, (String)this.zzqn.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
            }
            catch (Throwable throwable) {}
        }
    }

    private void zzaX() {
        this.zzqp.execute(new Runnable(){

            @Override
            public void run() {
                zzgd.initialize(zzbd.this.zzqn);
            }
        });
        try {
            zzqE = zze.zzuY();
            this.zzqB = zzqE.zzaC(this.zzqn) > 0;
            boolean bl = this.zzqD = zzqE.isGooglePlayServicesAvailable(this.zzqn) == 0;
            if (this.zzqn.getApplicationContext() != null) {
                this.zzqA = new GoogleApiClient.Builder(this.zzqn).addApi(zzzk.API).build();
            }
        }
        catch (Throwable throwable) {}
    }

    public AdvertisingIdClient zzaY() {
        if (!this.zzpU) {
            return null;
        }
        if (this.zzqt != null) {
            return this.zzqt;
        }
        if (this.zzqu != null) {
            try {
                this.zzqu.get(2000L, TimeUnit.MILLISECONDS);
                this.zzqu = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzqu.cancel(true);
            }
        }
        return this.zzqt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzaZ() {
        try {
            Object object = zzqC;
            synchronized (object) {
                if (this.zzqF) {
                    return;
                }
                if (this.zzqD && this.zzqA != null) {
                    this.zzqA.connect();
                    this.zzqF = true;
                } else {
                    this.zzqF = false;
                }
            }
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzba() {
        Object object = zzqC;
        synchronized (object) {
            if (this.zzqF && this.zzqA != null) {
                this.zzqA.disconnect();
                this.zzqF = false;
            }
        }
    }

    public int zzQ() {
        int n = Integer.MIN_VALUE;
        zzaq zzaq2 = this.zzaP();
        if (zzaq2 != null) {
            n = zzaq2.zzQ();
        }
        return n;
    }
}

