/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzfv;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzqw;
import java.util.Map;

@zzme
public class zzkq
extends zzkw {
    private final Map<String, String> zzFP;
    private final Context mContext;
    private String zzLS;
    private long zzLT;
    private long zzLU;
    private String zzLV;
    private String zzLW;

    public zzkq(zzqw zzqw2, Map<String, String> map) {
        super(zzqw2, "createCalendarEvent");
        this.zzFP = map;
        this.mContext = zzqw2.zzlr();
        this.zzhj();
    }

    private void zzhj() {
        this.zzLS = this.zzaw("description");
        this.zzLV = this.zzaw("summary");
        this.zzLT = this.zzax("start_ticks");
        this.zzLU = this.zzax("end_ticks");
        this.zzLW = this.zzaw("location");
    }

    private String zzaw(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzFP.get(string2)) ? "" : this.zzFP.get(string2);
    }

    private long zzax(String string2) {
        String string3 = this.zzFP.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzaz("Activity context is not available.");
            return;
        }
        zzfv zzfv2 = zzw.zzcM().zzN(this.mContext);
        if (!zzfv2.zzfp()) {
            this.zzaz("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzw.zzcM().zzM(this.mContext);
        Resources resources = zzw.zzcQ().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_title) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_message) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                Intent intent = zzkq.this.createIntent();
                zzw.zzcM().zzb(zzkq.this.mContext, intent);
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzkq.this.zzaz("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    @TargetApi(value=14)
    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzLS);
        intent.putExtra("eventLocation", this.zzLW);
        intent.putExtra("description", this.zzLV);
        if (this.zzLT > -1L) {
            intent.putExtra("beginTime", this.zzLT);
        }
        if (this.zzLU > -1L) {
            intent.putExtra("endTime", this.zzLU);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

