/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzhc;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzmp;
import com.google.android.gms.internal.zzna;
import com.google.android.gms.internal.zznc;
import com.google.android.gms.internal.zzni;
import com.google.android.gms.internal.zznm;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzor;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzqh;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
public final class zznd {
    private static final SimpleDateFormat zzTJ = new SimpleDateFormat("yyyyMMdd", Locale.US);

    @Nullable
    public static JSONObject zza(Context context, zzna zzna2) {
        zzmk zzmk2 = zzna2.zzTi;
        Location location = zzna2.zzzb;
        zzni zzni2 = zzna2.zzTj;
        Bundle bundle = zzna2.zzRF;
        JSONObject jSONObject = zzna2.zzTk;
        try {
            boolean bl;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("extra_caps", zzgd.zzEe.get());
            if (zzna2.zzRM.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", zzna2.zzRM));
            }
            if (zzmk2.zzRx != null) {
                hashMap.put("ad_pos", zzmk2.zzRx);
            }
            zznd.zza(hashMap, zzmk2.zzRy);
            if (zzmk2.zzvr.zzzA == null) {
                hashMap.put("format", zzmk2.zzvr.zzzy);
                if (zzmk2.zzvr.zzzC) {
                    hashMap.put("fluid", "height");
                }
            } else {
                boolean bl2 = false;
                bl = false;
                for (zzeg zzeg2 : zzmk2.zzvr.zzzA) {
                    if (!zzeg2.zzzC && !bl2) {
                        hashMap.put("format", zzeg2.zzzy);
                        bl2 = true;
                    }
                    if (zzeg2.zzzC && !bl) {
                        hashMap.put("fluid", "height");
                        bl = true;
                    }
                    if (bl2 && bl) break;
                }
            }
            if (zzmk2.zzvr.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (zzmk2.zzvr.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (zzmk2.zzvr.zzzA != null) {
                StringBuilder stringBuilder = new StringBuilder();
                bl = false;
                for (zzeg zzeg2 : zzmk2.zzvr.zzzA) {
                    if (zzeg2.zzzC) {
                        bl = true;
                        continue;
                    }
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(zzeg2.width == -1 ? (int)((float)zzeg2.widthPixels / zzni2.zzxk) : zzeg2.width);
                    stringBuilder.append("x");
                    stringBuilder.append(zzeg2.height == -2 ? (int)((float)zzeg2.heightPixels / zzni2.zzxk) : zzeg2.height);
                }
                if (bl) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.insert(0, "|");
                    }
                    stringBuilder.insert(0, "320x50");
                }
                hashMap.put("sz", stringBuilder);
            }
            if (zzmk2.zzRE != 0) {
                hashMap.put("native_version", zzmk2.zzRE);
                hashMap.put("native_templates", zzmk2.zzvK);
                hashMap.put("native_image_orientation", zznd.zzc(zzmk2.zzvF));
                if (!zzmk2.zzRN.isEmpty()) {
                    hashMap.put("native_custom_templates", zzmk2.zzRN);
                }
            }
            if (zzmk2.zzvr.zzzD) {
                hashMap.put("ene", true);
            }
            if (zzmk2.zzvH != null) {
                hashMap.put("is_icon_ad", true);
                hashMap.put("icon_ad_expansion_behavior", zzmk2.zzvH.zzzZ);
            }
            hashMap.put("slotname", zzmk2.zzvl);
            hashMap.put("pn", zzmk2.applicationInfo.packageName);
            if (zzmk2.zzRz != null) {
                hashMap.put("vc", zzmk2.zzRz.versionCode);
            }
            hashMap.put("ms", zzna2.zzRA);
            hashMap.put("seq_num", zzmk2.zzRB);
            hashMap.put("session_id", zzmk2.zzRC);
            hashMap.put("js", zzmk2.zzvn.zzba);
            zznd.zza(hashMap, zzni2, zzna2.zzTg, zzmk2.zzSa, zzna2.zzTf);
            zznd.zza(hashMap, zzna2, context);
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (location != null) {
                zznd.zza(hashMap, location);
            } else if (zzmk2.zzRy.versionCode >= 2 && zzmk2.zzRy.zzzb != null) {
                zznd.zza(hashMap, zzmk2.zzRy.zzzb);
            }
            if (zzmk2.versionCode >= 2) {
                hashMap.put("quality_signals", zzmk2.zzRD);
            }
            if (zzmk2.versionCode >= 4 && zzmk2.zzRG) {
                hashMap.put("forceHttps", zzmk2.zzRG);
            }
            if (bundle != null) {
                hashMap.put("content_info", bundle);
            }
            if (zzmk2.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(zzmk2.zzxk));
                hashMap.put("sh", zzmk2.zzRI);
                hashMap.put("sw", zzmk2.zzRH);
            } else {
                hashMap.put("u_sd", Float.valueOf(zzni2.zzxk));
                hashMap.put("sh", zzni2.zzRI);
                hashMap.put("sw", zzni2.zzRH);
            }
            if (zzmk2.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)zzmk2.zzRJ)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(zzmk2.zzRJ));
                    }
                    catch (JSONException jSONException) {
                        zzpk.zzc((String)"Problem serializing view hierarchy to JSON", (Throwable)jSONException);
                    }
                }
                hashMap.put("correlation_id", zzmk2.zzRK);
            }
            if (zzmk2.versionCode >= 7) {
                hashMap.put("request_id", zzmk2.zzRL);
            }
            if (zzmk2.versionCode >= 11 && zzmk2.zzRP != null) {
                hashMap.put("capability", zzmk2.zzRP.toBundle());
            }
            if (zzmk2.versionCode >= 12 && !TextUtils.isEmpty((CharSequence)zzmk2.zzRQ)) {
                hashMap.put("anchor", zzmk2.zzRQ);
            }
            if (zzmk2.versionCode >= 13) {
                hashMap.put("android_app_volume", Float.valueOf(zzmk2.zzRR));
            }
            if (zzmk2.versionCode >= 18) {
                hashMap.put("android_app_muted", zzmk2.zzRX);
            }
            if (zzmk2.versionCode >= 14 && zzmk2.zzRS > 0) {
                hashMap.put("target_api", zzmk2.zzRS);
            }
            if (zzmk2.versionCode >= 15) {
                hashMap.put("scroll_index", zzmk2.zzRT == -1 ? -1 : zzmk2.zzRT);
            }
            if (zzmk2.versionCode >= 16) {
                hashMap.put("_activity_context", zzmk2.zzRU);
            }
            if (zzmk2.versionCode >= 18) {
                if (!TextUtils.isEmpty((CharSequence)zzmk2.zzRY)) {
                    try {
                        hashMap.put("app_settings", new JSONObject(zzmk2.zzRY));
                    }
                    catch (JSONException jSONException) {
                        zzpk.zzc((String)"Problem creating json from app settings", (Throwable)jSONException);
                    }
                }
                hashMap.put("render_in_browser", zzmk2.zzKJ);
            }
            if (zzmk2.versionCode >= 18) {
                hashMap.put("android_num_video_cache_tasks", zzmk2.zzRZ);
            }
            zznd.zza(context, hashMap, zzmk2.zzvn);
            hashMap.put("cache_state", jSONObject);
            if (zzmk2.versionCode >= 19) {
                hashMap.put("gct", zzmk2.zzSb);
            }
            if (zzmk2.versionCode >= 21 && zzmk2.zzSc) {
                hashMap.put("de", "1");
            }
            if (zzgd.zzDc.get().booleanValue()) {
                zznd.zza(hashMap, zzmk2);
            }
            if (zzmk2.versionCode >= 22 && zzw.zzdl().zzjQ()) {
                hashMap.put("gmp_app_id", zzmk2.zzSe);
                hashMap.put("fbs_aiid", zzmk2.zzSf);
                hashMap.put("fbs_aeid", zzmk2.zzSg);
            }
            if (zzpk.zzak((int)2)) {
                String string2 = zzw.zzcM().zzQ(hashMap).toString(2);
                String string3 = String.valueOf(string2);
                zzpk.v(string3.length() != 0 ? "Ad Request JSON: ".concat(string3) : new String("Ad Request JSON: "));
            }
            return zzw.zzcM().zzQ(hashMap);
        }
        catch (JSONException jSONException) {
            String string4 = String.valueOf(jSONException.getMessage());
            zzpk.zzbh((String)(string4.length() != 0 ? "Problem serializing ad request to JSON: ".concat(string4) : new String("Problem serializing ad request to JSON: ")));
            return null;
        }
    }

    private static void zza(Context context, HashMap<String, Object> hashMap, zzqh zzqh2) {
        Bundle bundle = new Bundle();
        Bundle bundle2 = new Bundle();
        bundle2.putString("cl", "154081933");
        bundle2.putString("rapid_rc", "dev");
        bundle2.putString("rapid_rollup", "HEAD");
        bundle.putBundle("build_meta", bundle2);
        bundle.putString("mf", Boolean.toString(zzgd.zzEg.get()));
        bundle.putBoolean("instant_app", zzadg.zzbi((Context)context).zzzx());
        bundle.putBoolean("lite", zzqh2.zzYZ);
        hashMap.put("sdk_env", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, zzna zzna2, Context context) {
        Bundle bundle = new Bundle();
        bundle.putString("doritos", zzna2.zzTh);
        if (zzgd.zzCS.get().booleanValue()) {
            String string2 = null;
            boolean bl = false;
            if (zzna2.zzpR != null) {
                string2 = zzna2.zzpR.getId();
                bl = zzna2.zzpR.isLimitAdTrackingEnabled();
            }
            if (!TextUtils.isEmpty(string2)) {
                bundle.putString("rdid", string2);
                bundle.putBoolean("is_lat", bl);
                bundle.putString("idtype", "adid");
            } else {
                String string3 = zzel.zzeT().zzae(context);
                bundle.putString("pdid", string3);
                bundle.putString("pdidtype", "ssaid");
            }
        }
        hashMap.put("pii", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, zzec zzec2) {
        String string2 = zzpi.zzkF();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (zzec2.zzyT != -1L) {
            hashMap.put("cust_age", zzTJ.format(new Date(zzec2.zzyT)));
        }
        if (zzec2.extras != null) {
            hashMap.put("extras", zzec2.extras);
        }
        if (zzec2.zzyU != -1) {
            hashMap.put("cust_gender", zzec2.zzyU);
        }
        if (zzec2.zzyV != null) {
            hashMap.put("kw", zzec2.zzyV);
        }
        if (zzec2.zzyX != -1) {
            hashMap.put("tag_for_child_directed_treatment", zzec2.zzyX);
        }
        if (zzec2.zzyW) {
            hashMap.put("adtest", "on");
        }
        if (zzec2.versionCode >= 2) {
            if (zzec2.zzyY) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)zzec2.zzyZ)) {
                hashMap.put("ppid", zzec2.zzyZ);
            }
            if (zzec2.zzza != null) {
                zznd.zza(hashMap, zzec2.zzza);
            }
        }
        if (zzec2.versionCode >= 3 && zzec2.zzzc != null) {
            hashMap.put("url", zzec2.zzzc);
        }
        if (zzec2.versionCode >= 5) {
            if (zzec2.zzze != null) {
                hashMap.put("custom_targeting", zzec2.zzze);
            }
            if (zzec2.zzzf != null) {
                hashMap.put("category_exclusions", zzec2.zzzf);
            }
            if (zzec2.zzzg != null) {
                hashMap.put("request_agent", zzec2.zzzg);
            }
        }
        if (zzec2.versionCode >= 6 && zzec2.zzzh != null) {
            hashMap.put("request_pkg", zzec2.zzzh);
        }
        if (zzec2.versionCode >= 7) {
            hashMap.put("is_designed_for_families", zzec2.zzzi);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzni zzni2, zznm.zza zza2, Bundle bundle, Bundle bundle2) {
        Bundle bundle3;
        hashMap.put("am", zzni2.zzUE);
        hashMap.put("cog", zznd.zzB(zzni2.zzUF));
        hashMap.put("coh", zznd.zzB(zzni2.zzUG));
        if (!TextUtils.isEmpty((CharSequence)zzni2.zzUH)) {
            hashMap.put("carrier", zzni2.zzUH);
        }
        hashMap.put("gl", zzni2.zzUI);
        if (zzni2.zzUJ) {
            hashMap.put("simulator", 1);
        }
        if (zzni2.zzUK) {
            hashMap.put("is_sidewinder", 1);
        }
        hashMap.put("ma", zznd.zzB(zzni2.zzUL));
        hashMap.put("sp", zznd.zzB(zzni2.zzUM));
        hashMap.put("hl", zzni2.zzUN);
        if (!TextUtils.isEmpty((CharSequence)zzni2.zzUO)) {
            hashMap.put("mv", zzni2.zzUO);
        }
        hashMap.put("muv", zzni2.zzUP);
        if (zzni2.zzUQ != -2) {
            hashMap.put("cnt", zzni2.zzUQ);
        }
        hashMap.put("gnt", zzni2.zzUR);
        hashMap.put("pt", zzni2.zzUS);
        hashMap.put("rm", zzni2.zzUT);
        hashMap.put("riv", zzni2.zzUU);
        Bundle bundle4 = new Bundle();
        bundle4.putString("build", zzni2.zzUZ);
        Bundle bundle5 = new Bundle();
        bundle5.putBoolean("is_charging", zzni2.zzUW);
        bundle5.putDouble("battery_level", zzni2.zzUV);
        bundle4.putBundle("battery", bundle5);
        Bundle bundle6 = new Bundle();
        bundle6.putInt("active_network_state", zzni2.zzUY);
        bundle6.putBoolean("active_network_metered", zzni2.zzUX);
        if (zza2 != null) {
            bundle3 = new Bundle();
            bundle3.putInt("predicted_latency_micros", zza2.zzVf);
            bundle3.putLong("predicted_down_throughput_bps", zza2.zzVg);
            bundle3.putLong("predicted_up_throughput_bps", zza2.zzVh);
            bundle6.putBundle("predictions", bundle3);
        }
        bundle4.putBundle("network", bundle6);
        bundle3 = new Bundle();
        bundle3.putBoolean("is_browser_custom_tabs_capable", zzni2.zzVa);
        bundle4.putBundle("browser", bundle3);
        if (bundle != null) {
            bundle4.putBundle("android_mem_info", zznd.zzg(bundle));
        }
        Bundle bundle7 = new Bundle();
        bundle7.putBundle("parental_controls", bundle2);
        bundle4.putBundle("play_store", bundle7);
        hashMap.put("device", bundle4);
    }

    private static Bundle zzg(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        bundle2.putString("runtime_free", Long.toString(bundle.getLong("runtime_free_memory", -1L)));
        bundle2.putString("runtime_max", Long.toString(bundle.getLong("runtime_max_memory", -1L)));
        bundle2.putString("runtime_total", Long.toString(bundle.getLong("runtime_total_memory", -1L)));
        bundle2.putString("web_view_count", Integer.toString(bundle.getInt("web_view_count", 0)));
        Debug.MemoryInfo memoryInfo = (Debug.MemoryInfo)bundle.getParcelable("debug_memory_info");
        if (memoryInfo != null) {
            bundle2.putString("debug_info_dalvik_private_dirty", Integer.toString(memoryInfo.dalvikPrivateDirty));
            bundle2.putString("debug_info_dalvik_pss", Integer.toString(memoryInfo.dalvikPss));
            bundle2.putString("debug_info_dalvik_shared_dirty", Integer.toString(memoryInfo.dalvikSharedDirty));
            bundle2.putString("debug_info_native_private_dirty", Integer.toString(memoryInfo.nativePrivateDirty));
            bundle2.putString("debug_info_native_pss", Integer.toString(memoryInfo.nativePss));
            bundle2.putString("debug_info_native_shared_dirty", Integer.toString(memoryInfo.nativeSharedDirty));
            bundle2.putString("debug_info_other_private_dirty", Integer.toString(memoryInfo.otherPrivateDirty));
            bundle2.putString("debug_info_other_pss", Integer.toString(memoryInfo.otherPss));
            bundle2.putString("debug_info_other_shared_dirty", Integer.toString(memoryInfo.otherSharedDirty));
        }
        return bundle2;
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, zzfp zzfp2) {
        String string2;
        String string3;
        if (Color.alpha((int)zzfp2.zzAH) != 0) {
            hashMap.put("acolor", zznd.zzab(zzfp2.zzAH));
        }
        if (Color.alpha((int)zzfp2.backgroundColor) != 0) {
            hashMap.put("bgcolor", zznd.zzab(zzfp2.backgroundColor));
        }
        if (Color.alpha((int)zzfp2.zzAI) != 0 && Color.alpha((int)zzfp2.zzAJ) != 0) {
            hashMap.put("gradientto", zznd.zzab(zzfp2.zzAI));
            hashMap.put("gradientfrom", zznd.zzab(zzfp2.zzAJ));
        }
        if (Color.alpha((int)zzfp2.zzAK) != 0) {
            hashMap.put("bcolor", zznd.zzab(zzfp2.zzAK));
        }
        hashMap.put("bthick", Integer.toString(zzfp2.zzAL));
        switch (zzfp2.zzAM) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (zzfp2.zzAN) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (zzfp2.zzAO != null) {
            hashMap.put("channel", zzfp2.zzAO);
        }
        if (Color.alpha((int)zzfp2.zzAP) != 0) {
            hashMap.put("dcolor", zznd.zzab(zzfp2.zzAP));
        }
        if (zzfp2.zzAQ != null) {
            hashMap.put("font", zzfp2.zzAQ);
        }
        if (Color.alpha((int)zzfp2.zzAR) != 0) {
            hashMap.put("hcolor", zznd.zzab(zzfp2.zzAR));
        }
        hashMap.put("headersize", Integer.toString(zzfp2.zzAS));
        if (zzfp2.zzAT != null) {
            hashMap.put("q", zzfp2.zzAT);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzmk zzmk2) {
        boolean bl;
        String string2 = zzmk2.zzvr.zzzy;
        boolean bl2 = string2.equals("interstitial_mb") || string2.equals("reward_mb");
        Bundle bundle = zzmk2.zzSd;
        boolean bl3 = bl = bundle != null;
        if (bl2 && bl) {
            Bundle bundle2 = new Bundle();
            bundle2.putBundle("interstitial_pool", bundle);
            hashMap.put("counters", bundle2);
        }
    }

    private static Integer zzB(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzab(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(zzhc zzhc2) {
        int n = zzhc2 != null ? zzhc2.zzHb : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static zzmn zza(Context context, zzmk zzmk2, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            String string6 = jSONObject.optString("ad_slot_size", string5);
            boolean bl = zzmk2 != null && zzmk2.zzRE != 0;
            String string7 = jSONObject.optString("ad_json", null);
            if (string7 == null) {
                string7 = jSONObject.optString("ad_html", null);
            }
            if (string7 == null) {
                string7 = jSONObject.optString("body", null);
            }
            long l = -1L;
            String string8 = jSONObject.optString("debug_dialog", null);
            String string9 = jSONObject.optString("debug_signals", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string10 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string10)) {
                n = zzw.zzcO().zzkR();
            } else if ("landscape".equals(string10)) {
                n = zzw.zzcO().zzkQ();
            }
            zzmn zzmn2 = null;
            if (TextUtils.isEmpty((CharSequence)string7) && !TextUtils.isEmpty((CharSequence)string4)) {
                zzmn2 = zznc.zza(zzmk2, context, zzmk2.zzvn.zzba, string4, null, null, null, null);
                string3 = zzmn2.zzNJ;
                string7 = zzmn2.body;
                l = zzmn2.zzSr;
            }
            if (string7 == null) {
                return new zzmn(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = zzmn2 == null ? null : zzmn2.zzKF;
            if (jSONArray != null) {
                list3 = zznd.zza(jSONArray, list3);
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = zzmn2 == null ? null : zzmn2.zzKG;
            if (jSONArray2 != null) {
                list2 = zznd.zza(jSONArray2, list2);
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = zzmn2 == null ? null : zzmn2.zzSp;
            if (jSONArray3 != null) {
                list = zznd.zza(jSONArray3, list);
            }
            if (zzmn2 != null) {
                if (zzmn2.orientation != -1) {
                    n = zzmn2.orientation;
                }
                if (zzmn2.zzSm > 0L) {
                    l2 = zzmn2.zzSm;
                }
            }
            String string11 = jSONObject.optString("active_view");
            String string12 = null;
            boolean bl2 = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl2) {
                string12 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl3 = jSONObject.optBoolean("mediation", false);
            boolean bl4 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("content_vertical_opted_out", true);
            boolean bl7 = jSONObject.optBoolean("prefetch", false);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            String string13 = jSONObject.optString("gws_query_id", "");
            boolean bl8 = "height".equals(jSONObject.optString("fluid", ""));
            boolean bl9 = jSONObject.optBoolean("native_express", false);
            List<String> list7 = zznd.zza(jSONObject.optJSONArray("video_start_urls"), null);
            List<String> list8 = zznd.zza(jSONObject.optJSONArray("video_complete_urls"), null);
            zzoo zzoo2 = zzoo.zza((JSONArray)jSONObject.optJSONArray("rewards"));
            boolean bl10 = jSONObject.optBoolean("use_displayed_impression", false);
            zzmp zzmp2 = zzmp.zzf(jSONObject.optJSONObject("auto_protection_configuration"));
            String string14 = jSONObject.optString("set_cookie", "");
            List<String> list9 = zznd.zza(jSONObject.optJSONArray("remote_ping_urls"), null);
            zzor zzor2 = zzor.zzh(jSONObject.optJSONObject("safe_browsing"));
            boolean bl11 = jSONObject.optBoolean("render_in_browser", zzmk2.zzKJ);
            return new zzmn(zzmk2, string3, string7, list3, list2, l2, bl3, l4, list, l3, n, string5, l, string8, bl2, string12, string11, bl4, bl, zzmk2.zzRG, bl5, bl7, string13, bl8, bl9, zzoo2, list7, list8, bl10, zzmp2, zzmk2.zzRV, string14, list9, bl11, string6, zzor2, string9, bl6, zzmk2.zzSh);
        }
        catch (JSONException jSONException) {
            String string15 = String.valueOf(jSONException.getMessage());
            zzpk.zzbh((String)(string15.length() != 0 ? "Could not parse the inline ad response: ".concat(string15) : new String("Could not parse the inline ad response: ")));
            return new zzmn(0);
        }
    }

    @Nullable
    private static List<String> zza(@Nullable JSONArray jSONArray, @Nullable List<String> list) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        if (list == null) {
            list = new LinkedList<String>();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            list.add(jSONArray.getString(i));
        }
        return list;
    }

    public static JSONObject zzb(zzmn zzmn2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (zzmn2.zzNJ != null) {
            jSONObject.put("ad_base_url", (Object)zzmn2.zzNJ);
        }
        if (zzmn2.zzSq != null) {
            jSONObject.put("ad_size", (Object)zzmn2.zzSq);
        }
        jSONObject.put("native", zzmn2.zzzB);
        if (zzmn2.zzzB) {
            jSONObject.put("ad_json", (Object)zzmn2.body);
        } else {
            jSONObject.put("ad_html", (Object)zzmn2.body);
        }
        if (zzmn2.zzSs != null) {
            jSONObject.put("debug_dialog", (Object)zzmn2.zzSs);
        }
        if (zzmn2.zzSJ != null) {
            jSONObject.put("debug_signals", (Object)zzmn2.zzSJ);
        }
        if (zzmn2.zzSm != -1L) {
            jSONObject.put("interstitial_timeout", (double)zzmn2.zzSm / 1000.0);
        }
        if (zzmn2.orientation == zzw.zzcO().zzkR()) {
            jSONObject.put("orientation", (Object)"portrait");
        } else if (zzmn2.orientation == zzw.zzcO().zzkQ()) {
            jSONObject.put("orientation", (Object)"landscape");
        }
        if (zzmn2.zzKF != null) {
            jSONObject.put("click_urls", (Object)zznd.zzl(zzmn2.zzKF));
        }
        if (zzmn2.zzKG != null) {
            jSONObject.put("impression_urls", (Object)zznd.zzl(zzmn2.zzKG));
        }
        if (zzmn2.zzSp != null) {
            jSONObject.put("manual_impression_urls", (Object)zznd.zzl(zzmn2.zzSp));
        }
        if (zzmn2.zzSv != null) {
            jSONObject.put("active_view", (Object)zzmn2.zzSv);
        }
        jSONObject.put("ad_is_javascript", zzmn2.zzSt);
        if (zzmn2.zzSu != null) {
            jSONObject.put("ad_passback_url", (Object)zzmn2.zzSu);
        }
        jSONObject.put("mediation", zzmn2.zzSn);
        jSONObject.put("custom_render_allowed", zzmn2.zzSw);
        jSONObject.put("content_url_opted_out", zzmn2.zzSx);
        jSONObject.put("content_vertical_opted_out", zzmn2.zzSK);
        jSONObject.put("prefetch", zzmn2.zzSy);
        if (zzmn2.zzKL != -1L) {
            jSONObject.put("refresh_interval_milliseconds", zzmn2.zzKL);
        }
        if (zzmn2.zzSo != -1L) {
            jSONObject.put("mediation_config_cache_time_milliseconds", zzmn2.zzSo);
        }
        if (!TextUtils.isEmpty((CharSequence)zzmn2.zzSB)) {
            jSONObject.put("gws_query_id", (Object)zzmn2.zzSB);
        }
        jSONObject.put("fluid", (Object)(zzmn2.zzzC ? "height" : ""));
        jSONObject.put("native_express", zzmn2.zzzD);
        if (zzmn2.zzSD != null) {
            jSONObject.put("video_start_urls", (Object)zznd.zzl(zzmn2.zzSD));
        }
        if (zzmn2.zzSE != null) {
            jSONObject.put("video_complete_urls", (Object)zznd.zzl(zzmn2.zzSE));
        }
        if (zzmn2.zzSC != null) {
            jSONObject.put("rewards", (Object)zzmn2.zzSC.zzjP());
        }
        jSONObject.put("use_displayed_impression", zzmn2.zzSF);
        jSONObject.put("auto_protection_configuration", (Object)zzmn2.zzSG);
        jSONObject.put("render_in_browser", zzmn2.zzKJ);
        return jSONObject;
    }

    @Nullable
    static JSONArray zzl(List<String> list) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (String string2 : list) {
            jSONArray.put((Object)string2);
        }
        return jSONArray;
    }
}

