/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzgy;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzjj;
import com.google.android.gms.internal.zzlw;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
public class zzhb
implements zzha {
    private final Object zzrJ = new Object();
    private final zzs zzGJ;
    private final Context mContext;
    @Nullable
    private final JSONObject zzGM;
    @Nullable
    private final zzlw zzGN;
    @Nullable
    private final zzha.zza zzGO;
    private final zzaw zzGP;
    @Nullable
    private final zzqh zztt;
    boolean zzGQ;
    @Nullable
    private String zzGR;
    @Nullable
    private zzov zztF;
    private WeakReference<View> zzGS = null;

    public zzhb(Context context, zzs zzs2, @Nullable zzlw zzlw2, zzaw zzaw2, @Nullable JSONObject jSONObject, @Nullable zzha.zza zza2, @Nullable zzqh zzqh2, @Nullable String string2) {
        this.mContext = context;
        this.zzGJ = zzs2;
        this.zzGN = zzlw2;
        this.zzGP = zzaw2;
        this.zzGM = jSONObject;
        this.zzGO = zza2;
        this.zztt = zzqh2;
        this.zzGR = string2;
    }

    @Override
    @Nullable
    public View zza(View.OnClickListener onClickListener, boolean bl) {
        zzgs zzgs2 = this.zzGO.zzfT();
        if (zzgs2 == null) {
            return null;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (!bl) {
            switch (zzgs2.zzfN()) {
                case 0: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(9);
                    break;
                }
                case 3: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(9);
                    break;
                }
                case 2: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(11);
                    break;
                }
                default: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(11);
                }
            }
        }
        zzgt zzgt2 = new zzgt(this.mContext, zzgs2, layoutParams);
        zzgt2.setOnClickListener(onClickListener);
        zzgt2.setContentDescription(zzgd.zzEu.get());
        return zzgt2;
    }

    @Override
    public boolean zzfY() {
        zzgs zzgs2 = this.zzGO.zzfT();
        return zzgs2 != null && zzgs2.zzfO();
    }

    @Override
    public void zza(View view, String string2, @Nullable JSONObject jSONObject, Map<String, WeakReference<View>> map, View view2) {
        zzac.zzdj((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("asset", (Object)string2);
            jSONObject2.put("template", (Object)this.zzGO.zzfS());
            final JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("ad", (Object)this.zzGM);
            jSONObject3.put("click", (Object)jSONObject2);
            jSONObject3.put("has_custom_click_handler", this.zzGJ.zzz(this.zzGO.getCustomTemplateId()) != null);
            if (zzgd.zzEw.get().booleanValue()) {
                if (zzgd.zzEx.get().booleanValue()) {
                    jSONObject3.put("asset_view_signal", (Object)this.zzb(map, view2));
                    jSONObject3.put("ad_view_signal", (Object)this.zzo(view2));
                } else {
                    jSONObject3.put("view_rectangles", (Object)this.zza(map, view2));
                    jSONObject3.put("native_view_rectangle", (Object)this.zzn(view2));
                }
            }
            if (jSONObject != null) {
                jSONObject3.put("click_point", (Object)jSONObject);
            }
            try {
                JSONObject jSONObject4 = this.zzGM.optJSONObject("tracking_urls_and_actions");
                if (jSONObject4 == null) {
                    jSONObject4 = new JSONObject();
                }
                String string3 = jSONObject4.optString("click_string");
                jSONObject2.put("click_signals", (Object)this.zzGP.zzT().zza(this.mContext, string3, view));
            }
            catch (Exception exception) {
                zzpk.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject3.put("ads_id", (Object)this.zzGR);
            this.zzGN.zza(new zzlw.zza(this){

                @Override
                public void zze(zzjj zzjj2) {
                    zzjj2.zza("google.afma.nativeAds.handleClickGmsg", jSONObject3);
                }
            });
        }
        catch (JSONException jSONException) {
            zzpk.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
        }
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map, JSONObject jSONObject, View view2) {
        zzac.zzdj((String)"performClick must be called on the main UI thread.");
        if (map != null) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view3 = (View)entry.getValue().get();
                if (!view.equals(view3)) continue;
                this.zza(view, entry.getKey(), jSONObject, map, view2);
                return;
            }
        }
        if ("2".equals(this.zzGO.zzfS())) {
            this.zza(view, "2099", jSONObject, map, view2);
        } else if ("1".equals(this.zzGO.zzfS())) {
            this.zza(view, "1099", jSONObject, map, view2);
        }
    }

    @Override
    public void zzd(MotionEvent motionEvent) {
        this.zzGP.zza(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzd(View view, Map<String, WeakReference<View>> map) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzGQ) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.zzb(view, map);
        }
    }

    @Override
    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzac.zzdj((String)"recordImpression must be called on the main UI thread.");
        this.zzp(true);
        try {
            final JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzGM);
            jSONObject.put("ads_id", (Object)this.zzGR);
            if (zzgd.zzEw.get().booleanValue()) {
                if (zzgd.zzEx.get().booleanValue()) {
                    jSONObject.put("asset_view_signal", (Object)this.zzb(map, view));
                    jSONObject.put("ad_view_signal", (Object)this.zzo(view));
                } else {
                    jSONObject.put("view_rectangles", (Object)this.zza(map, view));
                    jSONObject.put("native_view_rectangle", (Object)this.zzn(view));
                }
            }
            this.zzGN.zza(new zzlw.zza(this){

                @Override
                public void zze(zzjj zzjj2) {
                    zzjj2.zza("google.afma.nativeAds.handleImpressionPing", jSONObject);
                }
            });
        }
        catch (JSONException jSONException) {
            zzpk.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
        }
        this.zzGJ.zza(this);
        this.zzGJ.zzbL();
    }

    @Override
    public View zzgc() {
        return this.zzGS != null ? (View)this.zzGS.get() : null;
    }

    @Override
    public void zzj(View view) {
        this.zzGS = new WeakReference<View>(view);
    }

    public void zza(View view, Map<String, WeakReference<View>> map, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        if (!zzgd.zzEr.get().booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(onTouchListener);
            view2.setClickable(true);
            view2.setOnClickListener(onClickListener);
        }
    }

    @Override
    public void zzc(View view, Map<String, WeakReference<View>> map) {
        if (zzgd.zzEq.get().booleanValue()) {
            return;
        }
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(null);
            view2.setClickable(false);
            view2.setOnClickListener(null);
        }
    }

    public zzqw zzgb() {
        if (this.zzGM == null || this.zzGM.optJSONObject("overlay") == null) {
            return null;
        }
        zzqw zzqw2 = this.zzge();
        zzqw2.getView().setVisibility(8);
        this.zzGN.zza(new zza(zzqw2).zzgh());
        return zzqw2;
    }

    @Override
    public void zza(View view, zzgy zzgy2) {
        zzhf zzhf2;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        View view2 = this.zzGO.zzfU();
        if (view2 != null) {
            ViewParent viewParent = view2.getParent();
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view2);
            }
            ((FrameLayout)view).addView(view2, (ViewGroup.LayoutParams)layoutParams);
            this.zzGJ.zza(zzgy2);
            return;
        }
        if (!(this.zzGO instanceof zzha.zzb)) {
            return;
        }
        zzha.zzb zzb2 = (zzha.zzb)this.zzGO;
        if (zzb2.getImages() != null && zzb2.getImages().size() > 0 && (zzhf2 = this.zze(zzb2.getImages().get(0))) != null) {
            try {
                IObjectWrapper iObjectWrapper = zzhf2.zzfP();
                if (iObjectWrapper != null) {
                    Drawable drawable2 = (Drawable)zzd.zzF((IObjectWrapper)iObjectWrapper);
                    ImageView imageView = this.zzgf();
                    imageView.setImageDrawable(drawable2);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
            }
            catch (RemoteException remoteException) {
                zzpk.zzbh((String)"Could not get drawable from image");
            }
        }
    }

    public void zzgd() {
        this.zzGJ.zzcv();
    }

    protected void zzp(boolean bl) {
        this.zzGQ = bl;
    }

    zzqw zzge() {
        return zzw.zzcN().zza(this.mContext, zzeg.zzk((Context)this.mContext), false, false, this.zzGP, this.zztt);
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Nullable
    zzhf zze(Object object) {
        if (object instanceof IBinder) {
            return zzhf.zza.zzB((IBinder)((IBinder)object));
        }
        return null;
    }

    ImageView zzgf() {
        return new ImageView(this.mContext);
    }

    int[] zzk(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    int zzC(int n) {
        return zzel.zzeT().zzc(this.mContext, n);
    }

    int zzl(View view) {
        return view.getMeasuredWidth();
    }

    int zzm(View view) {
        return view.getMeasuredHeight();
    }

    private JSONObject zzn(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            jSONObject.put("width", this.zzC(this.zzl(view)));
            jSONObject.put("height", this.zzC(this.zzm(view)));
        }
        catch (Exception exception) {
            zzpk.zzbh((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        try {
            int[] nArray = this.zzk(view);
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view2 = (View)entry.getValue().get();
                if (view2 == null) continue;
                int[] nArray2 = this.zzk(view2);
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("width", this.zzC(this.zzl(view2)));
                jSONObject2.put("height", this.zzC(this.zzm(view2)));
                jSONObject2.put("x", this.zzC(nArray2[0] - nArray[0]));
                jSONObject2.put("y", this.zzC(nArray2[1] - nArray[1]));
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
        }
        catch (JSONException jSONException) {
            zzpk.zzbh((String)"Unable to get all view rectangles");
        }
        return jSONObject;
    }

    private JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("x", this.zzC(rect.left));
        jSONObject.put("y", this.zzC(rect.top));
        jSONObject.put("width", this.zzC(rect.right - rect.left));
        jSONObject.put("height", this.zzC(rect.bottom - rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private JSONObject zzo(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = this.zzk(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zzC(this.zzl(view)));
            jSONObject3.put("height", this.zzC(this.zzm(view)));
            jSONObject3.put("x", this.zzC(nArray[0]));
            jSONObject3.put("y", this.zzC(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zzb(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("x", this.zzC(nArray[0]));
                jSONObject2.put("y", this.zzC(nArray[1]));
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzpk.zzbh((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private JSONObject zzb(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = this.zzk(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = this.zzk(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", this.zzC(this.zzl(view2)));
                jSONObject3.put("height", this.zzC(this.zzm(view2)));
                jSONObject3.put("x", this.zzC(nArray2[0] - nArray[0]));
                jSONObject3.put("y", this.zzC(nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = this.zzb(rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("x", this.zzC(nArray2[0] - nArray[0]));
                    jSONObject4.put("y", this.zzC(nArray2[1] - nArray[1]));
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzpk.zzbh((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }

    @Nullable
    public zzov zzgg() {
        if (zzw.zzdl().zzjS()) {
            if (this.zztF == null) {
                this.zztF = new zzov(this.mContext, this.zzGJ.getAdUnitId());
            }
            return this.zztF;
        }
        return null;
    }

    private static class zza {
        private final WeakReference<zzqw> zzGU;
        private String zzGV;

        public zza(zzqw zzqw2) {
            this.zzGU = new WeakReference<zzqw>(zzqw2);
        }

        private zzid zzf(final zzjj zzjj2) {
            return new zzid(){

                @Override
                public void zza(zzqw zzqw2, final Map<String, String> map) {
                    zzqw zzqw3 = (zzqw)zza.this.zzGU.get();
                    if (zzqw3 == null) {
                        zzjj2.zzb("/loadHtml", this);
                        return;
                    }
                    zzqw3.zzlv().zza(new zzqx.zza(){

                        @Override
                        public void zza(zzqw zzqw2, boolean bl) {
                            zza.this.zzGV = (String)map.get("id");
                            JSONObject jSONObject = new JSONObject();
                            try {
                                jSONObject.put("messageType", (Object)"htmlLoaded");
                                jSONObject.put("id", (Object)zza.this.zzGV);
                                zzjj2.zzb("sendMessageToNativeJs", jSONObject);
                            }
                            catch (JSONException jSONException) {
                                zzpk.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                            }
                        }
                    });
                    String string2 = map.get("overlayHtml");
                    String string3 = map.get("baseUrl");
                    if (TextUtils.isEmpty((CharSequence)string3)) {
                        zzqw3.loadData(string2, "text/html", "UTF-8");
                    } else {
                        zzqw3.loadDataWithBaseURL(string3, string2, "text/html", "UTF-8", null);
                    }
                }
            };
        }

        private zzid zzg(final zzjj zzjj2) {
            return new zzid(){

                @Override
                public void zza(zzqw zzqw2, Map<String, String> map) {
                    zzqw zzqw3 = (zzqw)zza.this.zzGU.get();
                    if (zzqw3 == null) {
                        zzjj2.zzb("/showOverlay", this);
                        return;
                    }
                    zzqw3.getView().setVisibility(0);
                }
            };
        }

        private zzid zzh(final zzjj zzjj2) {
            return new zzid(){

                @Override
                public void zza(zzqw zzqw2, Map<String, String> map) {
                    zzqw zzqw3 = (zzqw)zza.this.zzGU.get();
                    if (zzqw3 == null) {
                        zzjj2.zzb("/hideOverlay", this);
                        return;
                    }
                    zzqw3.getView().setVisibility(8);
                }
            };
        }

        private zzid zzi(final zzjj zzjj2) {
            return new zzid(){

                @Override
                public void zza(zzqw zzqw2, Map<String, String> map) {
                    JSONObject jSONObject = new JSONObject();
                    try {
                        for (String string2 : map.keySet()) {
                            jSONObject.put(string2, (Object)map.get(string2));
                        }
                        jSONObject.put("id", (Object)zza.this.zzGV);
                        zzjj2.zzb("sendMessageToNativeJs", jSONObject);
                    }
                    catch (JSONException jSONException) {
                        zzpk.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                    }
                }
            };
        }

        public zzlw.zza zzgh() {
            return new zzlw.zza(){

                @Override
                public void zze(zzjj zzjj2) {
                    zzqw zzqw2 = (zzqw)zza.this.zzGU.get();
                    if (zzqw2 == null) {
                        return;
                    }
                    zzjj2.zza("/loadHtml", zza.this.zzf(zzjj2));
                    zzjj2.zza("/showOverlay", zza.this.zzg(zzjj2));
                    zzjj2.zza("/hideOverlay", zza.this.zzh(zzjj2));
                    zzqw2.zzlv().zza("/sendMessageToSdk", zza.this.zzi(zzjj2));
                }
            };
        }
    }
}

