/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzar;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgy;
import com.google.android.gms.internal.zzib;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzit;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpj;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpy;
import com.google.android.gms.internal.zzqw;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
public final class zzic {
    public static final zzid zzHD = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
        }
    };
    public static final zzid zzHE = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            String string2 = map.get("urls");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                zzpk.zzbh((String)"URLs missing in canOpenURLs GMSG.");
                return;
            }
            String[] stringArray = string2.split(",");
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            PackageManager packageManager = zzqw2.getContext().getPackageManager();
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split(";", 2);
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2.length > 1 ? stringArray2[1].trim() : "android.intent.action.VIEW";
                Uri uri = Uri.parse((String)string4);
                Intent intent = new Intent(string5, uri);
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
                hashMap.put(string3, resolveInfo != null);
            }
            zzqw2.zza("openableURLs", hashMap);
        }
    };
    public static final zzid zzHF = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            PackageManager packageManager = zzqw2.getContext().getPackageManager();
            String string2 = map.get("data");
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                zzqw2.zzb("openableIntents", new JSONObject());
                return;
            }
            try {
                jSONArray = jSONObject.getJSONArray("intents");
            }
            catch (JSONException jSONException) {
                zzqw2.zzb("openableIntents", new JSONObject());
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ResolveInfo resolveInfo;
                JSONObject jSONObject3;
                try {
                    jSONObject3 = jSONArray.getJSONObject(i);
                }
                catch (JSONException jSONException) {
                    zzpk.zzb((String)"Error parsing the intent data.", (Throwable)jSONException);
                    continue;
                }
                String string3 = jSONObject3.optString("id");
                String string4 = jSONObject3.optString("u");
                String string5 = jSONObject3.optString("i");
                String string6 = jSONObject3.optString("m");
                String string7 = jSONObject3.optString("p");
                String string8 = jSONObject3.optString("c");
                jSONObject3.optString("f");
                jSONObject3.optString("e");
                Intent intent = new Intent();
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    intent.setData(Uri.parse((String)string4));
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    intent.setAction(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    intent.setType(string6);
                }
                if (!TextUtils.isEmpty((CharSequence)string7)) {
                    intent.setPackage(string7);
                }
                if (!TextUtils.isEmpty((CharSequence)string8) && ((ResolveInfo)(resolveInfo = string8.split("/", 2))).length == 2) {
                    intent.setComponent(new ComponentName((String)resolveInfo[0], (String)resolveInfo[1]));
                }
                boolean bl = (resolveInfo = packageManager.resolveActivity(intent, 65536)) != null;
                try {
                    jSONObject2.put(string3, bl);
                    continue;
                }
                catch (JSONException jSONException) {
                    zzpk.zzb((String)"Error constructing openable urls response.", (Throwable)jSONException);
                }
            }
            zzqw2.zzb("openableIntents", jSONObject2);
        }
    };
    public static final zzid zzHG = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            Object object;
            String string2 = map.get("u");
            if (string2 == null) {
                zzpk.zzbh((String)"URL missing from click GMSG.");
                return;
            }
            Uri uri = Uri.parse((String)string2);
            try {
                object = zzqw2.zzlx();
                if (object != null && ((zzaw)object).zzc(uri)) {
                    uri = ((zzaw)object).zza(uri, zzqw2.getContext(), zzqw2.getView());
                }
            }
            catch (zzax zzax2) {
                String string3 = String.valueOf(string2);
                zzpk.zzbh((String)(string3.length() != 0 ? "Unable to append parameter to URL: ".concat(string3) : new String("Unable to append parameter to URL: ")));
            }
            if (zzw.zzdl().zzjU() && TextUtils.isEmpty((CharSequence)uri.getQueryParameter("fbs_aeid"))) {
                object = zzw.zzdl().zzF(zzqw2.getContext());
                uri = zzw.zzcM().zza(uri, "fbs_aeid", (String)object);
                zzw.zzdl().zzf(zzqw2.getContext(), (String)object);
            }
            string2 = uri.toString();
            object = new zzpy(zzqw2.getContext(), zzqw2.zzly().zzba, string2);
            ((zzpj)object).zziP();
        }
    };
    public static final zzid zzHH = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            com.google.android.gms.ads.internal.overlay.zze zze2 = zzqw2.zzlt();
            if (zze2 != null) {
                zze2.close();
            } else {
                com.google.android.gms.ads.internal.overlay.zze zze3 = zzqw2.zzlu();
                if (zze3 != null) {
                    zze3.close();
                } else {
                    zzpk.zzbh((String)"A GMSG tried to close something that wasn't an overlay.");
                }
            }
        }
    };
    public static final zzid zzHI = new zzid(){

        private void zzd(zzqw zzqw2) {
            zzn zzn2;
            zzpk.zzbg((String)"Received support message, responding.");
            zze zze2 = zzqw2.zzby();
            if (zze2 != null && (zzn2 = zze2.zzsO) != null) {
                zzqw2.getContext();
            }
            zzn2 = new JSONObject();
            try {
                zzn2.put("event", "checkSupport");
                zzn2.put("supports", false);
                zzqw2.zzb("appStreaming", (JSONObject)zzn2);
            }
            catch (Throwable throwable) {
                zzw.zzcQ().zza(throwable, "DefaultGmsgHandlers.processCheckSupportsMessage");
            }
        }

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            if ("checkSupport".equals(map.get("action"))) {
                this.zzd(zzqw2);
                return;
            }
            com.google.android.gms.ads.internal.overlay.zze zze2 = zzqw2.zzlt();
            if (zze2 != null) {
                zze2.zzg(zzqw2, map);
            }
        }
    };
    public static final zzid zzHJ = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            zzqw2.zzK("1".equals(map.get("custom_close")));
        }
    };
    public static final zzid zzHK = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            String string2 = map.get("u");
            if (string2 == null) {
                zzpk.zzbh((String)"URL missing from httpTrack GMSG.");
                return;
            }
            zzpy zzpy2 = new zzpy(zzqw2.getContext(), zzqw2.zzly().zzba, string2);
            zzpy2.zziP();
        }
    };
    public static final zzid zzHL = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            String string2 = String.valueOf(map.get("string"));
            zzpk.zzbg((String)(string2.length() != 0 ? "Received log message: ".concat(string2) : new String("Received log message: ")));
        }
    };
    public static final zzid zzHM = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            zzgy zzgy2 = zzqw2.zzlL();
            if (zzgy2 != null) {
                zzgy2.zzfX();
            }
        }
    };
    public static final zzid zzHN = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            String string2 = map.get("tx");
            String string3 = map.get("ty");
            String string4 = map.get("td");
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                zzaw zzaw2 = zzqw2.zzlx();
                if (zzaw2 != null) {
                    zzar zzar2 = zzaw2.zzT();
                    zzar2.zza(n, n2, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzpk.zzbh((String)"Could not parse touch parameters from gmsg.");
            }
        }
    };
    public static final zzid zzHO = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            if (!zzgd.zzDD.get().booleanValue()) {
                return;
            }
            String string2 = map.get("disabled");
            boolean bl = Boolean.parseBoolean(string2);
            zzqw2.zzL(!bl);
        }
    };
    public static final zzid zzHP = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            String string2 = map.get("action");
            if ("pause".equals(string2)) {
                zzqw2.zzbV();
            } else if ("resume".equals(string2)) {
                zzqw2.zzbW();
            }
        }
    };
    public static final zzid zzHQ = new zzio();
    public static final zzid zzHR = new zzip();
    public static final zzid zzHS = new zzij();
    public static final zzid zzHT = new zzit();
    public static final zzid zzHU = new zzib();
    public static final zzim zzHV = new zzim();
    public static final zzid zzHW = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            if (map.keySet().contains("start")) {
                zzqw2.zzlv().zzlU();
                return;
            }
            if (map.keySet().contains("stop")) {
                zzqw2.zzlv().zzlV();
                return;
            }
            if (map.keySet().contains("cancel")) {
                zzqw2.zzlv().zzlW();
                return;
            }
        }
    };
    public static final zzid zzHX = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            if (map.keySet().contains("start")) {
                zzqw2.zzM(true);
            }
            if (map.keySet().contains("stop")) {
                zzqw2.zzM(false);
            }
        }
    };
    public static final zzid zzHY = new zzid(){

        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            WindowManager windowManager = (WindowManager)zzqw2.getContext().getSystemService("window");
            Map<String, Integer> map2 = zzw.zzcM().zza((View)zzqw2, windowManager);
            zzqw2.zza("locationReady", map2);
            zzpk.zzbh((String)"GET LOCATION COMPILED");
        }
    };
}

