/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzqw;
import java.util.Map;
import java.util.Set;

@zzme
public class zzkr
extends zzkw {
    static final Set<String> zzLY = zzf.zzc((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzLZ = "top-right";
    private boolean zzMa = true;
    private int zzMb = 0;
    private int zzMc = 0;
    private int zzrD = -1;
    private int zzMd = 0;
    private int zzMe = 0;
    private int zzrC = -1;
    private final Object zzrJ = new Object();
    private final zzqw zzIs;
    private final Activity zzLO;
    private zzeg zzus;
    private ImageView zzMf;
    private LinearLayout zzMg;
    private zzkx zzMh;
    private PopupWindow zzMi;
    private RelativeLayout zzMj;
    private ViewGroup zzMk;

    public zzkr(zzqw zzqw2, zzkx zzkx2) {
        super(zzqw2, "resize");
        this.zzIs = zzqw2;
        this.zzLO = zzqw2.zzlr();
        this.zzMh = zzkx2;
    }

    private void zzj(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zzrC = zzw.zzcM().zzaY(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zzrD = zzw.zzcM().zzaY(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzMd = zzw.zzcM().zzaY(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzMe = zzw.zzcM().zzaY(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzMa = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzLZ = string2;
        }
    }

    boolean zzhk() {
        return this.zzrC > -1 && this.zzrD > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, String> map) {
        Object object = this.zzrJ;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzLO == null) {
                this.zzaz("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzIs.zzbC() == null) {
                this.zzaz("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzIs.zzbC().zzzz) {
                this.zzaz("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzIs.zzlz()) {
                this.zzaz("Cannot resize an expanded banner.");
                return;
            }
            this.zzj(map);
            if (!this.zzhk()) {
                this.zzaz("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzLO.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzaz("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzhl();
            if (nArray == null) {
                this.zzaz("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzel.zzeT().zzb((Context)this.zzLO, this.zzrC);
            int n2 = zzel.zzeT().zzb((Context)this.zzLO, this.zzrD);
            ViewParent viewParent = this.zzIs.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzIs.getView());
                if (this.zzMi == null) {
                    this.zzMk = (ViewGroup)viewParent;
                    bitmap = zzw.zzcM().zzp(this.zzIs.getView());
                    this.zzMf = new ImageView((Context)this.zzLO);
                    this.zzMf.setImageBitmap(bitmap);
                    this.zzus = this.zzIs.zzbC();
                    this.zzMk.addView((View)this.zzMf);
                } else {
                    this.zzMi.dismiss();
                }
            } else {
                this.zzaz("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzMj = new RelativeLayout((Context)this.zzLO);
            this.zzMj.setBackgroundColor(0);
            this.zzMj.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzMi = zzw.zzcM().zza((View)this.zzMj, n, n2, false);
            this.zzMi.setOutsideTouchable(true);
            this.zzMi.setTouchable(true);
            this.zzMi.setClippingEnabled(!this.zzMa);
            this.zzMj.addView(this.zzIs.getView(), -1, -1);
            this.zzMg = new LinearLayout((Context)this.zzLO);
            bitmap = new RelativeLayout.LayoutParams(zzel.zzeT().zzb((Context)this.zzLO, 50), zzel.zzeT().zzb((Context)this.zzLO, 50));
            switch (this.zzLZ) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzMg.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzkr.this.zzr(true);
                }
            });
            this.zzMg.setContentDescription((CharSequence)"Close button");
            this.zzMj.addView((View)this.zzMg, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzMi.showAtLocation(window.getDecorView(), 0, zzel.zzeT().zzb((Context)this.zzLO, nArray[0]), zzel.zzeT().zzb((Context)this.zzLO, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(runtimeException.getMessage());
                this.zzaz(string2.length() != 0 ? "Cannot show popup window: ".concat(string2) : new String("Cannot show popup window: "));
                this.zzMj.removeView(this.zzIs.getView());
                if (this.zzMk != null) {
                    this.zzMk.removeView((View)this.zzMf);
                    this.zzMk.addView(this.zzIs.getView());
                    this.zzIs.zza(this.zzus);
                }
                return;
            }
            this.zzc(nArray[0], nArray[1]);
            this.zzIs.zza(new zzeg((Context)this.zzLO, new AdSize(this.zzrC, this.zzrD)));
            this.zzd(nArray[0], nArray[1]);
            this.zzaB("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzr(boolean bl) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzMi != null) {
                this.zzMi.dismiss();
                this.zzMj.removeView(this.zzIs.getView());
                if (this.zzMk != null) {
                    this.zzMk.removeView((View)this.zzMf);
                    this.zzMk.addView(this.zzIs.getView());
                    this.zzIs.zza(this.zzus);
                }
                if (bl) {
                    this.zzaB("default");
                    if (this.zzMh != null) {
                        this.zzMh.zzcb();
                    }
                }
                this.zzMi = null;
                this.zzMj = null;
                this.zzMk = null;
                this.zzMg = null;
            }
        }
    }

    private int[] zzhl() {
        if (!this.zzhn()) {
            return null;
        }
        if (this.zzMa) {
            return new int[]{this.zzMb + this.zzMd, this.zzMc + this.zzMe};
        }
        int[] nArray = zzw.zzcM().zzi(this.zzLO);
        int[] nArray2 = zzw.zzcM().zzk(this.zzLO);
        int n = nArray[0];
        int n2 = this.zzMb + this.zzMd;
        int n3 = this.zzMc + this.zzMe;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zzrC > n) {
            n2 = n - this.zzrC;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zzrD > nArray2[1]) {
            n3 = nArray2[1] - this.zzrD;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzMb = n;
            this.zzMc = n2;
            if (this.zzMi != null && bl) {
                int[] nArray = this.zzhl();
                if (nArray != null) {
                    this.zzMi.update(zzel.zzeT().zzb((Context)this.zzLO, nArray[0]), zzel.zzeT().zzb((Context)this.zzLO, nArray[1]), this.zzMi.getWidth(), this.zzMi.getHeight());
                    this.zzd(nArray[0], nArray[1]);
                } else {
                    this.zzr(true);
                }
            }
        }
    }

    void zzc(int n, int n2) {
        if (this.zzMh != null) {
            this.zzMh.zza(n, n2, this.zzrC, this.zzrD);
        }
    }

    void zzd(int n, int n2) {
        int n3 = zzw.zzcM().zzk(this.zzLO)[0];
        this.zzb(n, n2 - n3, this.zzrC, this.zzrD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzhm() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzMi != null;
        }
    }

    public void zze(int n, int n2) {
        this.zzMb = n;
        this.zzMc = n2;
    }

    boolean zzhn() {
        int[] nArray = zzw.zzcM().zzi(this.zzLO);
        int[] nArray2 = zzw.zzcM().zzk(this.zzLO);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zzrC < 50 || this.zzrC > n) {
            zzpk.zzbh((String)"Width is too small or too large.");
            return false;
        }
        if (this.zzrD < 50 || this.zzrD > n2) {
            zzpk.zzbh((String)"Height is too small or too large.");
            return false;
        }
        if (this.zzrD == n2 && this.zzrC == n) {
            zzpk.zzbh((String)"Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzMa) {
            int n3;
            int n4;
            switch (this.zzLZ) {
                case "top-left": {
                    n4 = this.zzMb + this.zzMd;
                    n3 = this.zzMc + this.zzMe;
                    break;
                }
                case "top-center": {
                    n4 = this.zzMb + this.zzMd + this.zzrC / 2 - 25;
                    n3 = this.zzMc + this.zzMe;
                    break;
                }
                case "center": {
                    n4 = this.zzMb + this.zzMd + this.zzrC / 2 - 25;
                    n3 = this.zzMc + this.zzMe + this.zzrD / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = this.zzMb + this.zzMd;
                    n3 = this.zzMc + this.zzMe + this.zzrD - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = this.zzMb + this.zzMd + this.zzrC / 2 - 25;
                    n3 = this.zzMc + this.zzMe + this.zzrD - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = this.zzMb + this.zzMd + this.zzrC - 50;
                    n3 = this.zzMc + this.zzMe + this.zzrD - 50;
                    break;
                }
                default: {
                    n4 = this.zzMb + this.zzMd + this.zzrC - 50;
                    n3 = this.zzMc + this.zzMe;
                }
            }
            if (n4 < 0 || n4 + 50 > n || n3 < nArray2[0] || n3 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

