/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.CookieManager;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmf;
import com.google.android.gms.internal.zzmh;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zznd;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpj;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpn;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzpq;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqq;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
public class zzmg
extends zzpj
implements zzmh.zza {
    private final zzmf.zza zzRl;
    private final zzmk.zza zzRm;
    private final Object zzPU = new Object();
    private final Context mContext;
    private zzmk zzLo;
    private Runnable zzPT;
    zzpq zzRn;
    zzmn zzPS;
    zzjr zzKY;

    public zzmg(Context context, zzmk.zza zza2, zzmf.zza zza3) {
        this.zzRl = zza3;
        this.mContext = context;
        this.zzRm = zza2;
    }

    zzpq zza(zzqh zzqh2, zzqp<zzmk> zzqp2) {
        return zzmh.zza(this.mContext, zzqh2, zzqp2, this);
    }

    @Override
    public void zzco() {
        Object object;
        zzpk.zzbf((String)"AdLoaderBackgroundTask started.");
        this.zzPT = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzmg.this.zzPU;
                synchronized (object) {
                    if (zzmg.this.zzRn == null) {
                        return;
                    }
                    zzmg.this.onStop();
                    zzmg.this.zzd(2, "Timed out waiting for ad response.");
                }
            }
        };
        zzpo.zzXC.postDelayed(this.zzPT, zzgd.zzDL.get().longValue());
        long l = zzw.zzcS().elapsedRealtime();
        if (zzgd.zzDK.get().booleanValue() && this.zzRm.zzRy.extras != null && (object = this.zzRm.zzRy.extras.getString("_ad")) != null) {
            this.zzLo = new zzmk(this.zzRm, l, null, null, null);
            this.zza(zznd.zza(this.mContext, this.zzLo, (String)object));
            return;
        }
        object = new zzqq();
        zzpn.zza(new Runnable((zzqp)object){
            final /* synthetic */ zzqp zzRp;
            {
                this.zzRp = zzqp2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzmg.this.zzPU;
                synchronized (object) {
                    zzmg.this.zzRn = zzmg.this.zza(((zzmg)zzmg.this).zzRm.zzvn, this.zzRp);
                    if (zzmg.this.zzRn == null) {
                        zzmg.this.zzd(0, "Could not start the ad request service.");
                        zzpo.zzXC.removeCallbacks(zzmg.this.zzPT);
                    }
                }
            }
        });
        String string2 = zzw.zzdl().zzD(this.mContext);
        String string3 = zzw.zzdl().zzE(this.mContext);
        String string4 = zzw.zzdl().zzF(this.mContext);
        zzw.zzdl().zzh(this.mContext, string4);
        this.zzLo = new zzmk(this.zzRm, l, string2, string3, string4);
        object.zzg(this.zzLo);
    }

    private void zzd(int n, String string2) {
        if (n == 3 || n == -1) {
            zzpk.zzbg((String)string2);
        } else {
            zzpk.zzbh((String)string2);
        }
        this.zzPS = this.zzPS == null ? new zzmn(n) : new zzmn(n, this.zzPS.zzKL);
        zzmk zzmk2 = this.zzLo != null ? this.zzLo : new zzmk(this.zzRm, -1L, null, null, null);
        zzpb.zza zza2 = new zzpb.zza(zzmk2, this.zzPS, this.zzKY, null, n, -1L, this.zzPS.zzSr, null);
        this.zzRl.zza(zza2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(@NonNull zzmn zzmn2) {
        zzpk.zzbf((String)"Received ad response.");
        this.zzPS = zzmn2;
        long l = zzw.zzcS().elapsedRealtime();
        Object object = this.zzPU;
        synchronized (object) {
            this.zzRn = null;
        }
        zzw.zzcQ().zzd(this.mContext, this.zzPS.zzRV);
        if (zzgd.zzDc.get().booleanValue()) {
            if (this.zzPS.zzSh) {
                zzw.zzcQ().zzk(this.mContext, this.zzLo.zzvl);
            } else {
                zzw.zzcQ().zzl(this.mContext, this.zzLo.zzvl);
            }
        }
        object = null;
        try {
            if (this.zzPS.errorCode != -2 && this.zzPS.errorCode != -3) {
                int n = this.zzPS.errorCode;
                throw new zza(new StringBuilder(66).append("There was a problem getting an ad response. ErrorCode: ").append(n).toString(), this.zzPS.errorCode);
            }
            this.zzjm();
            if (this.zzLo.zzvr.zzzA != null) {
                object = this.zzb(this.zzLo);
            }
        }
        catch (zza zza2) {
            this.zzd(zza2.getErrorCode(), zza2.getMessage());
            zzpo.zzXC.removeCallbacks(this.zzPT);
            return;
        }
        zzw.zzcQ().zzE(this.zzPS.zzSx);
        zzw.zzcQ().zzF(this.zzPS.zzSK);
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.zzPS.zzSv)) {
            try {
                jSONObject = new JSONObject(this.zzPS.zzSv);
            }
            catch (Exception exception) {
                zzpk.zzb((String)"Error parsing the JSON for Active View.", (Throwable)exception);
            }
        }
        zzpb.zza zza3 = new zzpb.zza(this.zzLo, this.zzPS, this.zzKY, (zzeg)object, -2, l, this.zzPS.zzSr, jSONObject);
        this.zzRl.zza(zza3);
        zzpo.zzXC.removeCallbacks(this.zzPT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzPU;
        synchronized (object) {
            if (this.zzRn != null) {
                this.zzRn.cancel();
            }
        }
    }

    protected void zzjm() throws zza {
        if (this.zzPS.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzPS.body)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzw.zzcQ().zzc(this.mContext, this.zzPS.zzRG);
        if (this.zzPS.zzSn) {
            try {
                this.zzKY = new zzjr(this.zzPS.body);
                zzw.zzcQ().zzG(this.zzKY.zzKJ);
            }
            catch (JSONException jSONException) {
                zzpk.zzb((String)"Could not parse mediation config.", (Throwable)jSONException);
                String string2 = String.valueOf(this.zzPS.body);
                throw new zza(string2.length() != 0 ? "Could not parse mediation config: ".concat(string2) : new String("Could not parse mediation config: "), 0);
            }
        } else {
            zzw.zzcQ().zzG(this.zzPS.zzKJ);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzPS.zzRW) && zzgd.zzFb.get().booleanValue()) {
            zzpk.zzbf((String)"Received cookie from server. Setting webview cookie in CookieManager.");
            CookieManager cookieManager = zzw.zzcO().zzX(this.mContext);
            if (cookieManager != null) {
                cookieManager.setCookie("googleads.g.doubleclick.net", this.zzPS.zzRW);
            }
        }
    }

    protected zzeg zzb(zzmk zzmk2) throws zza {
        int n;
        int n2;
        if (this.zzPS.zzzC) {
            for (zzeg zzegArray : zzmk2.zzvr.zzzA) {
                if (!zzegArray.zzzC) continue;
                return new zzeg(zzegArray, zzmk2.zzvr.zzzA);
            }
        }
        if (this.zzPS.zzSq == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzPS.zzSq.split("x");
        if (stringArray.length != 2) {
            String string2 = String.valueOf(this.zzPS.zzSq);
            throw new zza(string2.length() != 0 ? "Invalid ad size format from the ad response: ".concat(string2) : new String("Invalid ad size format from the ad response: "), 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(this.zzPS.zzSq);
            throw new zza(string3.length() != 0 ? "Invalid ad size number from the ad response: ".concat(string3) : new String("Invalid ad size number from the ad response: "), 0);
        }
        for (zzeg zzeg2 : zzmk2.zzvr.zzzA) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = zzeg2.width == -1 ? (int)((float)zzeg2.widthPixels / f) : zzeg2.width;
            int n5 = n3 = zzeg2.height == -2 ? (int)((float)zzeg2.heightPixels / f) : zzeg2.height;
            if (n2 != n4 || n != n3 || zzeg2.zzzC) continue;
            return new zzeg(zzeg2, zzmk2.zzvr.zzzA);
        }
        String string4 = String.valueOf(this.zzPS.zzSq);
        throw new zza(string4.length() != 0 ? "The ad size from the ad response was not one of the requested sizes: ".concat(string4) : new String("The ad size from the ad response was not one of the requested sizes: "), 0);
    }

    @zzme
    static final class zza
    extends Exception {
        private final int zzPY;

        public zza(String string2, int n) {
            super(string2);
            this.zzPY = n;
        }

        public int getErrorCode() {
            return this.zzPY;
        }
    }
}

