/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zza;
import com.google.android.gms.ads.internal.overlay.zzae;
import com.google.android.gms.ads.internal.overlay.zzaf;
import com.google.android.gms.ads.internal.overlay.zzaj;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.overlay.zzr;
import com.google.android.gms.ads.internal.overlay.zzs;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzaiq;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zzaln;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzyk;
import java.util.Collections;

@zzaaz
public final class zzm
extends zzyk
implements zzaj {
    private static int zzOH = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzOI;
    private zzalm zzJK;
    private zzr zzOJ;
    private zzae zzOK;
    private boolean zzOL = false;
    private FrameLayout zzOM;
    private WebChromeClient.CustomViewCallback zzON;
    private boolean zzOO = false;
    private boolean zzOP = false;
    private zzq zzOQ;
    private boolean zzOR = false;
    private int zzOS = 0;
    private final Object zzOT = new Object();
    private Runnable zzOU;
    private boolean zzOV;
    private boolean zzOW;
    private boolean zzOX = false;
    private boolean zzOY = false;
    private boolean zzOZ = true;

    public zzm(Activity activity) {
        this.mActivity = activity;
    }

    public final void close() {
        this.zzOS = 2;
        this.mActivity.finish();
    }

    public final void zzfH() {
        if (this.zzOI != null && this.zzOL) {
            this.setRequestedOrientation(this.zzOI.orientation);
        }
        if (this.zzOM != null) {
            this.mActivity.setContentView((View)this.zzOQ);
            this.zzOW = true;
            this.zzOM.removeAllViews();
            this.zzOM = null;
        }
        if (this.zzON != null) {
            this.zzON.onCustomViewHidden();
            this.zzON = null;
        }
        this.zzOL = false;
    }

    @Override
    public final void zzfI() {
        this.zzOS = 1;
        this.mActivity.finish();
    }

    public final void onBackPressed() {
        this.zzOS = 0;
    }

    public final boolean zzfJ() {
        this.zzOS = 0;
        if (this.zzJK == null) {
            return true;
        }
        boolean bl = this.zzJK.zziB();
        if (!bl) {
            this.zzJK.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public final void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzOO = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzOI = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzOI == null) {
                throw new zzp("Could not get info for ad overlay.");
            }
            if (this.zzOI.zzvW.zzaaR > 7500000) {
                this.zzOS = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzOZ = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzOP = this.zzOI.zzPq != null ? this.zzOI.zzPq.zzuu : false;
            zzme<Boolean> zzme2 = zzmo.zzFk;
            if (zzbs.zzbK().zzd(zzme2).booleanValue() && this.zzOP && this.zzOI.zzPq.zzuz != -1) {
                new zzs(this, null).zzhK();
            }
            if (bundle == null) {
                if (this.zzOI.zzPh != null && this.zzOZ) {
                    this.zzOI.zzPh.zzaA();
                }
                if (this.zzOI.zzPo != 1 && this.zzOI.zzPg != null) {
                    this.zzOI.zzPg.onAdClicked();
                }
            }
            this.zzOQ = new zzq((Context)this.mActivity, this.zzOI.zzPp, this.zzOI.zzvW.zzaS);
            this.zzOQ.setId(1000);
            switch (this.zzOI.zzPo) {
                case 1: {
                    this.zzs(false);
                    return;
                }
                case 2: {
                    this.zzOJ = new zzr(this.zzOI.zzPi);
                    this.zzs(false);
                    return;
                }
                case 3: {
                    this.zzs(true);
                    return;
                }
                case 4: {
                    if (this.zzOO) {
                        this.zzOS = 3;
                        this.mActivity.finish();
                        return;
                    }
                    zzbs.zzbv();
                    if (zza.zza((Context)this.mActivity, this.zzOI.zzPf, this.zzOI.zzPn)) break;
                    this.zzOS = 3;
                    this.mActivity.finish();
                    return;
                }
                default: {
                    throw new zzp("Could not determine ad overlay type.");
                }
            }
            return;
        }
        catch (zzp zzp2) {
            zzahd.zzaT((String)zzp2.getMessage());
            this.zzOS = 3;
            this.mActivity.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zzme<Boolean> zzme2 = zzmo.zzGD;
        if (zzbs.zzbK().zzd(zzme2).booleanValue()) {
            if (this.zzJK != null && !this.zzJK.isDestroyed()) {
                zzbs.zzbA();
                zzaiq.zzl(this.zzJK);
                return;
            }
            zzahd.zzaT((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzOI != null && this.zzOI.zzPo == 4) {
            if (this.zzOO) {
                this.zzOS = 3;
                this.mActivity.finish();
            } else {
                this.zzOO = true;
            }
        }
        if (this.zzOI.zzPh != null) {
            this.zzOI.zzPh.onResume();
        }
        zzme<Boolean> zzme2 = zzmo.zzGD;
        if (!zzbs.zzbK().zzd(zzme2).booleanValue()) {
            if (this.zzJK != null && !this.zzJK.isDestroyed()) {
                zzbs.zzbA();
                zzaiq.zzl(this.zzJK);
                return;
            }
            zzahd.zzaT((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zzfH();
        if (this.zzOI.zzPh != null) {
            this.zzOI.zzPh.onPause();
        }
        zzme<Boolean> zzme2 = zzmo.zzGD;
        if (!(zzbs.zzbK().zzd(zzme2).booleanValue() || this.zzJK == null || this.mActivity.isFinishing() && this.zzOJ != null)) {
            zzbs.zzbA();
            zzaiq.zzk(this.zzJK);
        }
        this.zzfL();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzo(IObjectWrapper iObjectWrapper) {
        zzme<Boolean> zzme2 = zzmo.zzGC;
        if (zzbs.zzbK().zzd(zzme2).booleanValue() && com.google.android.gms.common.util.zzs.isAtLeastN()) {
            Configuration configuration = (Configuration)com.google.android.gms.dynamic.zzn.zzE((IObjectWrapper)iObjectWrapper);
            zzbs.zzby();
            if (zzail.zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
                return;
            }
            this.mActivity.getWindow().addFlags(2048);
            this.mActivity.getWindow().clearFlags(1024);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzOO);
    }

    public final void onStop() {
        zzme<Boolean> zzme2 = zzmo.zzGD;
        if (zzbs.zzbK().zzd(zzme2).booleanValue() && this.zzJK != null && (!this.mActivity.isFinishing() || this.zzOJ == null)) {
            zzbs.zzbA();
            zzaiq.zzk(this.zzJK);
        }
        this.zzfL();
    }

    public final void onDestroy() {
        if (this.zzJK != null) {
            this.zzOQ.removeView(this.zzJK.getView());
        }
        this.zzfL();
    }

    private final void zzr(boolean bl) {
        zzme<Integer> zzme2 = zzmo.zzGE;
        int n = zzbs.zzbK().zzd(zzme2);
        zzaf zzaf2 = new zzaf();
        new zzaf().size = 50;
        zzaf2.paddingLeft = bl ? n : 0;
        zzaf2.paddingRight = bl ? 0 : n;
        zzaf2.paddingTop = 0;
        zzaf2.paddingBottom = n;
        this.zzOK = new zzae((Context)this.mActivity, zzaf2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzOK.zza(bl, this.zzOI.zzPl);
        this.zzOQ.addView((View)this.zzOK, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzZ() {
        this.zzOW = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        if (this.zzOK != null) {
            this.zzOK.zza(bl, bl2);
        }
    }

    public final void zzfK() {
        this.zzOQ.removeView((View)this.zzOK);
        this.zzr(true);
    }

    public final void setRequestedOrientation(int n) {
        this.mActivity.setRequestedOrientation(n);
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzOM = new FrameLayout((Context)this.mActivity);
        this.zzOM.setBackgroundColor(-16777216);
        this.zzOM.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzOM);
        this.zzOW = true;
        this.zzON = customViewCallback;
        this.zzOL = true;
    }

    private final void zzs(boolean bl) throws zzp {
        zzaln zzaln2;
        boolean bl2;
        zzme<Boolean> zzme2;
        Window window;
        if (!this.zzOW) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zzp("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (com.google.android.gms.common.util.zzs.isAtLeastN()) {
            zzme2 = zzmo.zzGC;
            if (zzbs.zzbK().zzd(zzme2).booleanValue()) {
                zzbs.zzby();
                bl3 = zzail.zza(this.mActivity, this.mActivity.getResources().getConfiguration());
            }
        }
        boolean bl4 = bl2 = this.zzOI.zzPq != null && this.zzOI.zzPq.zzuv;
        if ((!this.zzOP || bl2) && bl3) {
            window.setFlags(1024, 1024);
            zzme2 = zzmo.zzDW;
            if (zzbs.zzbK().zzd(zzme2).booleanValue() && com.google.android.gms.common.util.zzs.zzsb() && this.zzOI.zzPq != null && this.zzOI.zzPq.zzuA) {
                window.getDecorView().setSystemUiVisibility(4098);
            }
        }
        boolean bl5 = (zzaln2 = this.zzOI.zzPi.zziv()) != null ? zzaln2.zzcm() : false;
        this.zzOR = false;
        if (bl5) {
            if (this.zzOI.orientation == zzbs.zzbA().zzhS()) {
                this.zzOR = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzOI.orientation == zzbs.zzbA().zzhT()) {
                this.zzOR = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzOR;
        zzahd.zzaC((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzOI.orientation);
        if (zzbs.zzbA().zza(window)) {
            zzahd.zzaC((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzOP) {
            this.zzOQ.setBackgroundColor(-16777216);
        } else {
            this.zzOQ.setBackgroundColor(zzOH);
        }
        this.mActivity.setContentView((View)this.zzOQ);
        this.zzOW = true;
        if (bl) {
            try {
                this.zzJK = zzbs.zzbz().zza((Context)this.mActivity, this.zzOI.zzPi.zzal(), true, bl5, null, this.zzOI.zzvW, null, null, this.zzOI.zzPi.zzaj(), zzig.zzdd());
            }
            catch (Exception exception) {
                throw new zzp("Could not obtain webview for the overlay.");
            }
            this.zzJK.zziv().zza(null, null, this.zzOI.zzPj, this.zzOI.zzPn, true, null, this.zzOI.zzPi.zziv().zziN(), null, null);
            this.zzJK.zziv().zza(new zzn(this));
            if (this.zzOI.url != null) {
                this.zzJK.loadUrl(this.zzOI.url);
            } else if (this.zzOI.zzPm != null) {
                this.zzJK.loadDataWithBaseURL(this.zzOI.zzPk, this.zzOI.zzPm, "text/html", "UTF-8", null);
            } else {
                throw new zzp("No URL or HTML to display in ad overlay.");
            }
            if (this.zzOI.zzPi != null) {
                this.zzOI.zzPi.zzc(this);
            }
        } else {
            this.zzJK = this.zzOI.zzPi;
            this.zzJK.setContext((Context)this.mActivity);
        }
        this.zzJK.zzb(this);
        ViewParent viewParent = this.zzJK.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzJK.getView());
        }
        if (this.zzOP) {
            this.zzJK.zziM();
        }
        this.zzOQ.addView(this.zzJK.getView(), -1, -1);
        if (!bl && !this.zzOR) {
            this.zzfO();
        }
        this.zzr(bl5);
        if (this.zzJK.zziw()) {
            this.zza(bl5, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzfL() {
        if (!this.mActivity.isFinishing() || this.zzOX) {
            return;
        }
        this.zzOX = true;
        if (this.zzJK != null) {
            int n = this.zzOS;
            this.zzJK.zzA(n);
            Object object = this.zzOT;
            synchronized (object) {
                if (!this.zzOV && this.zzJK.zziH()) {
                    this.zzOU = new zzo(this);
                    zzme<Long> zzme2 = zzmo.zzDV;
                    zzail.zzZt.postDelayed(this.zzOU, zzbs.zzbK().zzd(zzme2).longValue());
                    return;
                }
            }
        }
        this.zzfM();
    }

    final void zzfM() {
        if (this.zzOY) {
            return;
        }
        this.zzOY = true;
        if (this.zzJK != null) {
            this.zzOQ.removeView(this.zzJK.getView());
            if (this.zzOJ != null) {
                this.zzJK.setContext(this.zzOJ.zzqG);
                this.zzJK.zzA(false);
                this.zzOJ.parent.addView(this.zzJK.getView(), this.zzOJ.index, this.zzOJ.zzPc);
                this.zzOJ = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzJK.setContext(this.mActivity.getApplicationContext());
            }
            this.zzJK = null;
        }
        if (this.zzOI != null && this.zzOI.zzPh != null) {
            this.zzOI.zzPh.zzaz();
        }
    }

    public final void zzfN() {
        if (this.zzOR) {
            this.zzOR = false;
            this.zzfO();
        }
    }

    private final void zzfO() {
        this.zzJK.zzfO();
    }

    public final void zzfP() {
        this.zzOQ.zzPb = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzfQ() {
        Object object = this.zzOT;
        synchronized (object) {
            this.zzOV = true;
            if (this.zzOU != null) {
                zzail.zzZt.removeCallbacks(this.zzOU);
                zzail.zzZt.post(this.zzOU);
            }
            return;
        }
    }

    static /* synthetic */ Activity zza(zzm zzm2) {
        return zzm2.mActivity;
    }
}

