/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzk;
import com.google.android.gms.internal.zzadn;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzbim;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zznl;
import java.util.Locale;

public final class zzado {
    private int zzVH;
    private boolean zzVO;
    private boolean zzVP;
    private int zzVT;
    private int zzVX;
    private int zzVY;
    private String zzVK;
    private int zzVU;
    private int zzVV;
    private int zzVW;
    private boolean zzWb;
    private int zzWc;
    private double zzVZ;
    private boolean zzWa;
    private String zzWd;
    private String zzWe;
    private boolean zzVI;
    private boolean zzVJ;
    private String zzVL;
    private boolean zzVM;
    private boolean zzVN;
    private String zzVQ;
    private String zzVR;
    private float zzxU;
    private int zzSK;
    private int zzSL;
    private String zzVS;
    private boolean zzWf;

    public zzado(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzk(context);
        this.zzl(context);
        this.zzm(context);
        Locale locale = Locale.getDefault();
        this.zzVI = zzado.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzVJ = zzado.zza(packageManager, "http://www.google.com") != null;
        this.zzVL = locale.getCountry();
        zzji.zzdr();
        this.zzVM = zzakk.zzij();
        this.zzVN = zzk.zzaI((Context)context);
        this.zzVQ = locale.getLanguage();
        this.zzVR = zzado.zzb(context, packageManager);
        this.zzVS = zzado.zza(context, packageManager);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzxU = displayMetrics.density;
        this.zzSK = displayMetrics.widthPixels;
        this.zzSL = displayMetrics.heightPixels;
    }

    public zzado(Context context, zzadn zzadn2) {
        context.getPackageManager();
        this.zzk(context);
        this.zzl(context);
        this.zzm(context);
        Context context2 = context;
        zzado zzado2 = this;
        this.zzWd = Build.FINGERPRINT;
        zzado2.zzWe = Build.DEVICE;
        zzado2.zzWf = zznl.zzi(context2);
        this.zzVI = zzadn2.zzVI;
        this.zzVJ = zzadn2.zzVJ;
        this.zzVL = zzadn2.zzVL;
        this.zzVM = zzadn2.zzVM;
        this.zzVN = zzadn2.zzVN;
        this.zzVQ = zzadn2.zzVQ;
        this.zzVR = zzadn2.zzVR;
        this.zzVS = zzadn2.zzVS;
        this.zzxU = zzadn2.zzxU;
        this.zzSK = zzadn2.zzSK;
        this.zzSL = zzadn2.zzSL;
    }

    private final void zzk(Context context) {
        zzbs.zzby();
        AudioManager audioManager = zzail.zzL(context);
        if (audioManager != null) {
            try {
                this.zzVH = audioManager.getMode();
                this.zzVO = audioManager.isMusicActive();
                this.zzVP = audioManager.isSpeakerphoneOn();
                this.zzVT = audioManager.getStreamVolume(3);
                this.zzVX = audioManager.getRingerMode();
                this.zzVY = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzbs.zzbC().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzVH = -2;
        this.zzVO = false;
        this.zzVP = false;
        this.zzVT = 0;
        this.zzVX = 0;
        this.zzVY = 0;
    }

    @TargetApi(value=16)
    private final void zzl(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzVK = telephonyManager.getNetworkOperator();
        this.zzVV = telephonyManager.getNetworkType();
        this.zzVW = telephonyManager.getPhoneType();
        this.zzVU = -2;
        this.zzWb = false;
        this.zzWc = -1;
        zzbs.zzby();
        if (zzail.zzc(context, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzVU = networkInfo.getType();
                this.zzWc = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzVU = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzWb = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzm(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzVZ = (float)n2 / (float)n3;
            this.zzWa = n == 2 || n == 5;
            return;
        }
        this.zzVZ = -1.0;
        this.zzWa = false;
    }

    private static String zza(Context context, PackageManager packageManager) {
        try {
            PackageInfo packageInfo = zzbim.zzaP((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = String.valueOf(packageInfo.packageName);
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zzb(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzado.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = zzbim.zzaP((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = String.valueOf(activityInfo.packageName);
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        return packageManager.resolveActivity(intent, 65536);
    }

    public final zzadn zzgL() {
        return new zzadn(this.zzVH, this.zzVI, this.zzVJ, this.zzVK, this.zzVL, this.zzVM, this.zzVN, this.zzVO, this.zzVP, this.zzVQ, this.zzVR, this.zzVS, this.zzVT, this.zzVU, this.zzVV, this.zzVW, this.zzVX, this.zzVY, this.zzxU, this.zzSK, this.zzSL, this.zzVZ, this.zzWa, this.zzWb, this.zzWc, this.zzWd, this.zzWf, this.zzWe);
    }
}

