/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzagh;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zzaly;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zznn;
import com.google.android.gms.internal.zzno;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zznz;
import com.google.android.gms.internal.zzoa;
import com.google.android.gms.internal.zzob;
import com.google.android.gms.internal.zzod;
import com.google.android.gms.internal.zzoe;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzos;
import com.google.android.gms.internal.zzot;
import com.google.android.gms.internal.zzzt;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzaaz
public class zzoc
implements zzny {
    private final Object mLock = new Object();
    private final zznz zzIa;
    private final Context mContext;
    @Nullable
    private final JSONObject zzId;
    @Nullable
    private final zzzt zzuS;
    @Nullable
    private final zzoa zzIe;
    private final zzcu zzIf;
    @Nullable
    private final zzakq zztZ;
    boolean zzIg;
    @Nullable
    private String zzIh;
    @Nullable
    private zzagh zzun;
    private WeakReference<View> zzIi = null;

    public zzoc(Context context, zznz zznz2, @Nullable zzzt zzzt2, zzcu zzcu2, @Nullable JSONObject jSONObject, @Nullable zzoa zzoa2, @Nullable zzakq zzakq2, @Nullable String string) {
        this.mContext = context;
        this.zzIa = zznz2;
        this.zzuS = zzzt2;
        this.zzIf = zzcu2;
        this.zzId = jSONObject;
        this.zzIe = zzoa2;
        this.zztZ = zzakq2;
        this.zzIh = string;
    }

    @Override
    @Nullable
    public View zza(View.OnClickListener onClickListener, boolean bl) {
        zznn zznn2 = this.zzIe.zzej();
        if (zznn2 == null) {
            return null;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (!bl) {
            switch (zznn2.zzed()) {
                case 0: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(9);
                    break;
                }
                case 3: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(9);
                    break;
                }
                case 2: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(11);
                    break;
                }
                default: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(11);
                }
            }
        }
        zzno zzno2 = new zzno(this.mContext, zznn2, layoutParams);
        zzno2.setOnClickListener(onClickListener);
        zzme<String> zzme2 = zzmo.zzFD;
        zzno2.setContentDescription(zzbs.zzbK().zzd(zzme2));
        return zzno2;
    }

    @Override
    public boolean zzeo() {
        zznn zznn2 = this.zzIe.zzej();
        return zznn2 != null && zznn2.zzee();
    }

    @Override
    public final void zza(View view, String string, @Nullable Bundle bundle, Map<String, WeakReference<View>> map, View view2) {
        JSONObject jSONObject = this.zza(map, view2);
        JSONObject jSONObject2 = this.zzi(view2);
        JSONObject jSONObject3 = zzoc.zzj(view2);
        JSONObject jSONObject4 = null;
        try {
            JSONObject jSONObject5 = zzbs.zzby().zza(bundle, null);
            jSONObject4 = new JSONObject();
            jSONObject4.put("click_point", (Object)jSONObject5);
            jSONObject4.put("asset_id", (Object)string);
        }
        catch (Exception exception) {
            zzahd.zzb((String)"Error occured while grabbing click signals.", (Throwable)exception);
        }
        this.zza(view, jSONObject2, jSONObject, jSONObject3, string, jSONObject4, null);
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map, Bundle bundle, View view2) {
        zzbr.zzcz((String)"performClick must be called on the main UI thread.");
        if (map != null) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view3 = (View)entry.getValue().get();
                if (!view.equals(view3)) continue;
                this.zza(view, entry.getKey(), bundle, map, view2);
                return;
            }
        }
        if ("2".equals(this.zzIe.zzei())) {
            this.zza(view, "2099", bundle, map, view2);
            return;
        }
        if ("1".equals(this.zzIe.zzei())) {
            this.zza(view, "1099", bundle, map, view2);
        }
    }

    @Override
    public final void zzc(Bundle bundle) {
        if (bundle == null) {
            zzahd.zzaC((String)"Click data is null. No click is reported.");
            return;
        }
        String string = bundle.getBundle("click_signal").getString("asset_id");
        JSONObject jSONObject = zzbs.zzby().zza(bundle, null);
        this.zza(null, null, null, null, string, null, jSONObject);
    }

    private final void zza(View view, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, String string, JSONObject jSONObject4, JSONObject jSONObject5) {
        zzbr.zzcz((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzId);
            if (jSONObject2 != null) {
                jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject6.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject4 != null) {
                jSONObject6.put("click_signal", (Object)jSONObject4);
            }
            if (jSONObject3 != null) {
                jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            }
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("asset_id", (Object)string);
            jSONObject7.put("template", (Object)this.zzIe.zzei());
            jSONObject7.put("has_custom_click_handler", this.zzIa.zzs(this.zzIe.getCustomTemplateId()) != null);
            jSONObject6.put("has_custom_click_handler", this.zzIa.zzs(this.zzIe.getCustomTemplateId()) != null);
            try {
                JSONObject jSONObject8 = this.zzId.optJSONObject("tracking_urls_and_actions");
                if (jSONObject8 == null) {
                    jSONObject8 = new JSONObject();
                }
                String string2 = jSONObject8.optString("click_string");
                String string3 = this.zzIf.zzB().zza(this.mContext, string2, view);
                jSONObject7.put("click_signals", (Object)string3);
            }
            catch (Exception exception) {
                zzahd.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject6.put("click", (Object)jSONObject7);
            if (jSONObject5 != null) {
                jSONObject6.put("provided_signals", (Object)jSONObject5);
            }
            jSONObject6.put("ads_id", (Object)this.zzIh);
            this.zzuS.zza(new zzod(this, jSONObject6));
            return;
        }
        catch (JSONException jSONException) {
            zzahd.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zzd(MotionEvent motionEvent) {
        this.zzIf.zza(motionEvent);
    }

    @Override
    public final void zze(Bundle bundle) {
        if (bundle == null) {
            zzahd.zzaC((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzIf.zzB().zza(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(View view, Map<String, WeakReference<View>> map) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzIg) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.zza(view, map);
            return;
        }
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map) {
        JSONObject jSONObject = this.zzi(view);
        JSONObject jSONObject2 = this.zza(map, view);
        JSONObject jSONObject3 = zzoc.zzj(view);
        this.zza(jSONObject, jSONObject2, jSONObject3, null);
    }

    @Override
    public final boolean zzd(Bundle bundle) {
        JSONObject jSONObject = zzbs.zzby().zza(bundle, null);
        return this.zza(null, null, null, jSONObject);
    }

    private final boolean zza(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4) {
        zzbr.zzcz((String)"recordImpression must be called on the main UI thread.");
        this.zzIg = true;
        try {
            JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("ad", (Object)this.zzId);
            jSONObject5.put("ads_id", (Object)this.zzIh);
            if (jSONObject2 != null) {
                jSONObject5.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject5.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject3 != null) {
                jSONObject5.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject5.put("provided_signals", (Object)jSONObject4);
            }
            this.zzuS.zza(new zzoe(this, jSONObject5));
            this.zzuS.zza(new zzof(this.zzIa, this.zzIh));
        }
        catch (JSONException jSONException) {
            zzahd.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        this.zzIa.zza(this);
        this.zzIa.zzav();
        return true;
    }

    @Override
    public final View zzes() {
        if (this.zzIi != null) {
            return (View)this.zzIi.get();
        }
        return null;
    }

    @Override
    public final void zzg(View view) {
        this.zzIi = new WeakReference<View>(view);
    }

    public void zza(View view, Map<String, WeakReference<View>> map, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        zzme<Boolean> zzme2 = zzmo.zzFB;
        if (!zzbs.zzbK().zzd(zzme2).booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            View view2 = (View)iterator.next().getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(onTouchListener);
            view2.setClickable(true);
            view2.setOnClickListener(onClickListener);
        }
    }

    @Override
    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzme<Boolean> zzme2 = zzmo.zzFA;
        if (zzbs.zzbK().zzd(zzme2).booleanValue()) {
            return;
        }
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            View view2 = (View)iterator.next().getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(null);
            view2.setClickable(false);
            view2.setOnClickListener(null);
        }
    }

    public zzalm zzer() throws zzaly {
        if (this.zzId == null || this.zzId.optJSONObject("overlay") == null) {
            return null;
        }
        Object object = this;
        zzakq zzakq2 = ((zzoc)object).zztZ;
        zzcu zzcu2 = ((zzoc)object).zzIf;
        zziv zziv2 = zziv.zzg((Context)((zzoc)object).mContext);
        Context context = ((zzoc)object).mContext;
        zzalm zzalm2 = zzbs.zzbz().zza(context, zziv2, false, false, zzcu2, zzakq2, null, null, null, zzig.zzdd());
        zzalm2.getView().setVisibility(8);
        object = new zzog(zzalm2);
        this.zzuS.zza(new zzom((zzog)object));
        return zzalm2;
    }

    public final void zzd(Map<String, WeakReference<View>> map) {
        if (this.zzIe.zzek() != null) {
            if ("2".equals(this.zzIe.zzei())) {
                zzbs.zzbC().zzb(this.mContext, this.zzIa.getAdUnitId(), this.zzIe.zzei(), map.containsKey("2011"));
                return;
            }
            if ("1".equals(this.zzIe.zzei())) {
                zzbs.zzbC().zzb(this.mContext, this.zzIa.getAdUnitId(), this.zzIe.zzei(), map.containsKey("1009"));
            }
        }
    }

    @Override
    public final void zza(View view, zznw zznw2) {
        Object object;
        zzos zzos2;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        View view2 = this.zzIe.zzek();
        if (view2 != null) {
            ViewParent viewParent = view2.getParent();
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view2);
            }
            ((FrameLayout)view).addView(view2, (ViewGroup.LayoutParams)layoutParams);
            this.zzIa.zza(zznw2);
            return;
        }
        if (!(this.zzIe instanceof zzob)) {
            return;
        }
        zzob zzob2 = (zzob)this.zzIe;
        if (zzob2.getImages() != null && zzob2.getImages().size() > 0 && (zzos2 = (object = zzob2.getImages().get(0)) instanceof IBinder ? zzot.zzi((IBinder)((IBinder)object)) : null) != null) {
            try {
                IObjectWrapper iObjectWrapper = zzos2.zzef();
                if (iObjectWrapper != null) {
                    Drawable drawable2 = (Drawable)zzn.zzE((IObjectWrapper)iObjectWrapper);
                    object = this;
                    ImageView imageView = new ImageView(((zzoc)object).mContext);
                    imageView.setImageDrawable(drawable2);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
                return;
            }
            catch (RemoteException remoteException) {
                zzahd.zzaT((String)"Could not get drawable from image");
            }
        }
    }

    @Override
    public final void zzet() {
        this.zzIa.zzaN();
    }

    @Override
    public final void zzeu() {
        this.zzuS.zzfc();
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    private static int[] zzh(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    private final int zzm(int n) {
        zzji.zzdr();
        return zzakk.zzd((Context)this.mContext, (int)n);
    }

    private final JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zzm(rect.right - rect.left));
        jSONObject.put("height", this.zzm(rect.bottom - rect.top));
        jSONObject.put("x", this.zzm(rect.left));
        jSONObject.put("y", this.zzm(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zzi(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = zzoc.zzh(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zzm(view.getMeasuredWidth()));
            jSONObject3.put("height", this.zzm(view.getMeasuredHeight()));
            jSONObject3.put("x", this.zzm(nArray[0]));
            jSONObject3.put("y", this.zzm(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zzb(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("x", this.zzm(nArray[0]));
                jSONObject2.put("y", this.zzm(nArray[1]));
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzahd.zzaT((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private static JSONObject zzj(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbs.zzby();
            int n = zzail.zzp(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzoc.zzh(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = zzoc.zzh(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", this.zzm(view2.getMeasuredWidth()));
                jSONObject3.put("height", this.zzm(view2.getMeasuredHeight()));
                jSONObject3.put("x", this.zzm(nArray2[0] - nArray[0]));
                jSONObject3.put("y", this.zzm(nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = this.zzb(rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("x", this.zzm(nArray2[0] - nArray[0]));
                    jSONObject4.put("y", this.zzm(nArray2[1] - nArray[1]));
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzahd.zzaT((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }

    @Nullable
    public final zzagh zzev() {
        if (zzbs.zzbX().zzr(this.mContext)) {
            if (this.zzun == null) {
                this.zzun = new zzagh(this.mContext, this.zzIa.getAdUnitId());
            }
            return this.zzun;
        }
        return null;
    }
}

