/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.zzag;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzzm;

@zzzm
public final class zza {
    public static boolean zza(Context context, zzc zzc2, zzag zzag2) {
        String[] stringArray;
        if (zzc2 == null) {
            zzafq.zzaT((String)"No intent data for launcher overlay.");
            return false;
        }
        zzmo.initialize(context);
        if (zzc2.intent != null) {
            return zza.zza(context, zzc2.intent, zzag2);
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)zzc2.url)) {
            zzafq.zzaT((String)"Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.mimeType)) {
            intent.setDataAndType(Uri.parse((String)zzc2.url), zzc2.mimeType);
        } else {
            intent.setData(Uri.parse((String)zzc2.url));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)zzc2.packageName)) {
            intent.setPackage(zzc2.packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.zzOh)) {
            stringArray = zzc2.zzOh.split("/", 2);
            if (stringArray.length < 2) {
                String string = String.valueOf(zzc2.zzOh);
                zzafq.zzaT((String)(string.length() != 0 ? "Could not parse component name from open GMSG: ".concat(string) : new String("Could not parse component name from open GMSG: ")));
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        stringArray = zzc2.zzOi;
        if (!TextUtils.isEmpty((CharSequence)zzc2.zzOi)) {
            int n = 0;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzafq.zzaT((String)"Could not parse intent flags.");
            }
            intent.addFlags(n);
        }
        zzme<Boolean> zzme2 = zzmo.zzGs;
        if (zzbs.zzbL().zzd(zzme2).booleanValue()) {
            intent.addFlags(0x10000000);
            intent.putExtra("android.support.customtabs.extra.user_opt_out", true);
        } else {
            zzme2 = zzmo.zzGr;
            if (zzbs.zzbL().zzd(zzme2).booleanValue()) {
                zzbs.zzbz();
                zzagy.zzc(context, intent);
            }
        }
        return zza.zza(context, intent, zzag2);
    }

    private static boolean zza(Context context, Intent intent, zzag zzag2) {
        try {
            String string = String.valueOf(intent.toURI());
            zzafq.v(string.length() != 0 ? "Launching an intent: ".concat(string) : new String("Launching an intent: "));
            zzbs.zzbz();
            zzagy.zzb(context, intent);
            if (zzag2 != null) {
                zzag2.zzan();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzafq.zzaT((String)activityNotFoundException.getMessage());
            return false;
        }
        return true;
    }
}

